/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import Jama.Matrix;
import ciss.phase_viewer.acviewer.colormap.BaseColorMap;
import ciss.phase_viewer.common.BinaryOperator;
import java.util.Arrays;
import java.util.Vector;
import org.apache.log4j.Logger;

public class VolumetricData
implements BinaryOperator {
    public static int CHARGE_DENSITY = 0;
    public static int MOLECULAR_ORBITAL = 1;
    private int mode = CHARGE_DENSITY;
    private Vector molecularOrbitalIndeces = null;
    private Logger logger = Logger.getLogger((String)VolumetricData.class.getName());
    private float[] density;
    private float[] density_buff;
    private float[] sortedDensity;
    private int[] ndiv;
    private int[] ndiv_buff;
    private float[][] delta;
    private float[][] delta_buff;
    private float[] origin = new float[]{0.0f, 0.0f, 0.0f};
    private int Ntot;
    private float minVal = 10000.0f;
    private float maxVal = -10000.0f;
    private float midVal = 0.0f;
    public static int LOG = 0;
    public static int LINEAR = 1;
    private int interpolationScheme = LOG;
    public static float meaninglessValue = 1000.0f;
    private boolean pbc = true;
    private int nshift0 = 0;
    private int nshift1 = 0;
    private int nshift2 = 0;

    @Override
    public void add(BinaryOperator bo) {
        if (!(bo instanceof VolumetricData)) {
            return;
        }
        VolumetricData vdata = (VolumetricData)bo;
        if (vdata.density.length != this.density.length) {
            return;
        }
        int i = 0;
        while (i < this.density.length) {
            int n = i;
            this.density[n] = this.density[n] + vdata.density[i];
            ++i;
        }
    }

    @Override
    public void divide(BinaryOperator bo) {
    }

    @Override
    public void multiply(BinaryOperator bo) {
    }

    @Override
    public void subtract(BinaryOperator bo) {
        if (!(bo instanceof VolumetricData)) {
            return;
        }
        VolumetricData vdata = (VolumetricData)bo;
        if (vdata.density.length != this.density.length) {
            return;
        }
        int i = 0;
        while (i < this.density.length) {
            int n = i;
            this.density[n] = this.density[n] - vdata.density[i];
            ++i;
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
        this.interpolationScheme = LINEAR;
    }

    public int getMode() {
        return this.mode;
    }

    public void addMolecularOrbitalIndex(Object obj) {
        if (this.molecularOrbitalIndeces == null) {
            this.molecularOrbitalIndeces = new Vector();
            this.molecularOrbitalIndeces.add(obj);
        }
    }

    public void removeMolecularOrbitalIndex(Object obj) {
        if (this.molecularOrbitalIndeces != null) {
            this.molecularOrbitalIndeces.remove(obj);
        }
    }

    public Object[] getMolecularOrbitalIndeces() {
        if (this.molecularOrbitalIndeces == null) {
            return null;
        }
        Object[] ob = new Object[this.molecularOrbitalIndeces.size()];
        this.molecularOrbitalIndeces.copyInto(ob);
        return ob;
    }

    public VolumetricData(float[] density, int[] ndiv, float[][] delta, float[] origin) {
        if (!this.pbc) {
            this.density = density;
            this.ndiv = ndiv;
            this.delta = delta;
            this.origin = origin;
            this.Ntot = ndiv[0] * ndiv[1] * ndiv[2];
            this.init(density, ndiv);
        } else {
            this.delta = delta;
            this.origin = origin;
            this.density = density;
            this.ndiv = ndiv;
            this.Ntot = ndiv[0] * ndiv[1] * ndiv[2];
            this.doPBC(density, ndiv);
            this.init(density, ndiv);
        }
    }

    public void save() {
        this.density_buff = new float[this.density.length];
        int i = 0;
        while (i < this.density.length) {
            this.density_buff[i] = this.density[i];
            ++i;
        }
        this.ndiv_buff = new int[3];
        i = 0;
        while (i < this.ndiv.length) {
            this.ndiv_buff[i] = this.ndiv[i];
            ++i;
        }
        this.delta_buff = new float[3][3];
        i = 0;
        while (i < this.delta.length) {
            int j = 0;
            while (j < this.delta[i].length) {
                this.delta_buff[i][j] = this.delta[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void restore() {
        this.density = this.density_buff;
        this.ndiv = this.ndiv_buff;
        this.delta = this.delta_buff;
        this.logger.debug((Object)"restored data ");
        this.logger.debug((Object)("ndiv: " + this.ndiv[0] + ", " + this.ndiv[1] + ", " + this.ndiv[2]));
        int i = 0;
        while (i < 3) {
            this.logger.debug((Object)("delta " + i + ": " + this.delta[i][0] + ", " + this.delta[i][1] + ", " + this.delta[i][2]));
            ++i;
        }
    }

    public void stripPBC() {
        if (!this.pbc) {
            return;
        }
        int[] ndiv_tmp = new int[3];
        int i = 0;
        while (i < 3) {
            ndiv_tmp[i] = this.ndiv[i] - 1;
            ++i;
        }
        int Ntot_tmp = ndiv_tmp[0] * ndiv_tmp[1] * ndiv_tmp[2];
        float[] density_tmp = new float[Ntot_tmp];
        int i2 = 0;
        while (i2 < ndiv_tmp[0]) {
            int j = 0;
            while (j < ndiv_tmp[1]) {
                int k = 0;
                while (k < ndiv_tmp[2]) {
                    int index = i2 * this.ndiv[1] * this.ndiv[2] + j * this.ndiv[2] + k;
                    int newind = i2 * ndiv_tmp[1] * ndiv_tmp[2] + j * ndiv_tmp[2] + k;
                    density_tmp[newind] = this.density[index];
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        this.density = density_tmp;
        this.ndiv = ndiv_tmp;
        this.Ntot = Ntot_tmp;
    }

    public void doPBC(float[] den, int[] ndi) {
        int ind;
        int j;
        this.ndiv = new int[3];
        this.ndiv[0] = ndi[0] + 1;
        this.ndiv[1] = ndi[1] + 1;
        this.ndiv[2] = ndi[2] + 1;
        this.Ntot = this.ndiv[0] * this.ndiv[1] * this.ndiv[2];
        this.density = new float[this.Ntot];
        int i = 0;
        while (i < ndi[0]) {
            j = 0;
            while (j < ndi[1]) {
                int k = 0;
                while (k < ndi[2]) {
                    int index = i * ndi[1] * ndi[2] + j * ndi[2] + k;
                    int newind = i * this.ndiv[1] * this.ndiv[2] + j * this.ndiv[2] + k;
                    this.density[newind] = den[index];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.ndiv[0]) {
            j = 0;
            while (j < this.ndiv[1]) {
                ind = i * this.ndiv[1] * this.ndiv[2] + j * this.ndiv[2];
                this.density[ind + this.ndiv[2] - 1] = this.density[ind];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.ndiv[0]) {
            j = 0;
            while (j < this.ndiv[2]) {
                ind = i * this.ndiv[1] * this.ndiv[2] + j;
                this.density[ind + this.ndiv[2] * (this.ndiv[1] - 1)] = this.density[ind];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.ndiv[1]) {
            j = 0;
            while (j < this.ndiv[2]) {
                ind = i * this.ndiv[2] + j;
                this.density[this.ndiv[2] * this.ndiv[1] * (this.ndiv[0] - 1) + ind] = this.density[ind];
                ++j;
            }
            ++i;
        }
    }

    private float[] doPBC(float[] den) {
        int ind;
        int j;
        int[] ndi = new int[3];
        int i = 0;
        while (i < ndi.length) {
            ndi[i] = this.ndiv[i] - 1;
            ++i;
        }
        float[] tmpden = new float[this.Ntot];
        int i2 = 0;
        while (i2 < ndi[0]) {
            j = 0;
            while (j < ndi[1]) {
                int k = 0;
                while (k < ndi[2]) {
                    int index = i2 * ndi[1] * ndi[2] + j * ndi[2] + k;
                    int newind = i2 * this.ndiv[1] * this.ndiv[2] + j * this.ndiv[2] + k;
                    tmpden[newind] = den[index];
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.ndiv[0]) {
            j = 0;
            while (j < this.ndiv[1]) {
                ind = i2 * this.ndiv[1] * this.ndiv[2] + j * this.ndiv[2];
                tmpden[ind + this.ndiv[2] - 1] = tmpden[ind];
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.ndiv[0]) {
            j = 0;
            while (j < this.ndiv[2]) {
                ind = i2 * this.ndiv[1] * this.ndiv[2] + j;
                tmpden[ind + this.ndiv[2] * (this.ndiv[1] - 1)] = tmpden[ind];
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.ndiv[1]) {
            j = 0;
            while (j < this.ndiv[2]) {
                ind = i2 * this.ndiv[2] + j;
                tmpden[this.ndiv[2] * this.ndiv[1] * (this.ndiv[0] - 1) + ind] = tmpden[ind];
                ++j;
            }
            ++i2;
        }
        return tmpden;
    }

    public void setShift(int n1, int n2, int n3) {
        if (n1 > this.ndiv[0] || n2 > this.ndiv[1] || n3 > this.ndiv[2]) {
            this.logger.error((Object)"can't shift that much!");
            return;
        }
        this.nshift0 = n1;
        this.nshift1 = n2;
        this.nshift2 = n3;
    }

    public void setShiftOld(double d1, double d2, double d3) {
        double cell0 = this.delta[0][0] * (float)this.ndiv[0] + this.delta[0][1] * (float)this.ndiv[1] + this.delta[0][2] * (float)this.ndiv[2];
        double cell1 = this.delta[1][0] * (float)this.ndiv[0] + this.delta[1][1] * (float)this.ndiv[1] + this.delta[1][2] * (float)this.ndiv[2];
        double cell2 = this.delta[2][0] * (float)this.ndiv[0] + this.delta[2][1] * (float)this.ndiv[1] + this.delta[2][2] * (float)this.ndiv[2];
        double[][] cell = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                cell[i][j] = this.delta[i][j] * (float)this.ndiv[j];
                ++j;
            }
            ++i;
        }
        double[][] shift = new double[3][1];
        shift[0][0] = d1;
        shift[1][0] = d2;
        shift[2][0] = d3;
        Matrix A = new Matrix(cell);
        Matrix B = new Matrix(shift);
        Matrix N = A.solve(B);
        this.nshift0 = (int)Math.round(N.get(0, 0) * (double)this.ndiv[0]);
        this.nshift1 = (int)Math.round(N.get(1, 0) * (double)this.ndiv[1]);
        this.nshift2 = (int)Math.round(N.get(2, 0) * (double)this.ndiv[2]);
        this.logger.debug((Object)("set shift : " + this.nshift0 + ", " + this.nshift1 + ", " + this.nshift2 + " from float: " + d1 + ", " + d2 + ", " + d3));
    }

    public void setShift(double d1, double d2, double d3) {
        this.logger.debug((Object)("d1, d2, d3: " + d1 + ", " + d2 + ", " + d3));
        this.nshift0 = (int)Math.round(d1 * (double)this.ndiv[0]);
        this.nshift1 = (int)Math.round(d2 * (double)this.ndiv[1]);
        this.nshift2 = (int)Math.round(d3 * (double)this.ndiv[2]);
        this.logger.debug((Object)("nshift: " + this.nshift0 + ", " + this.nshift1 + ", " + this.nshift2));
    }

    public void setDiffShift(double d1, double d2, double d3) {
        this.nshift0 += (int)Math.round(d1 * (double)this.ndiv[0]);
        this.nshift1 += (int)Math.round(d2 * (double)this.ndiv[1]);
        this.nshift2 += (int)Math.round(d3 * (double)this.ndiv[2]);
    }

    public void enlarge(int n1, int n2, int n3) {
        try {
            int j;
            int nnew;
            int NtotOld = this.ndiv_buff[0] * this.ndiv_buff[1] * this.ndiv_buff[2];
            this.ndiv = new int[this.ndiv.length];
            this.ndiv[0] = this.ndiv_buff[0] * n1;
            this.ndiv[1] = this.ndiv_buff[1] * n2;
            this.ndiv[2] = this.ndiv_buff[2] * n3;
            this.Ntot = this.ndiv[0] * this.ndiv[1] * this.ndiv[2];
            float[] density_tmp = new float[this.ndiv[2] * this.ndiv_buff[1] * this.ndiv_buff[0]];
            boolean ntmp1 = false;
            boolean ntmp2 = false;
            boolean ntmp3 = false;
            boolean nbase = false;
            int i = 0;
            while (i < this.ndiv_buff[0] * this.ndiv_buff[1]) {
                int j2 = 0;
                while (j2 < this.ndiv_buff[2]) {
                    int nold = i * this.ndiv_buff[2] + j2;
                    int k = 0;
                    while (k < n3) {
                        int tmp = k * this.ndiv_buff[2];
                        nnew = i * this.ndiv[2] + j2 + tmp;
                        density_tmp[nnew] = this.density_buff[nold];
                        ++k;
                    }
                    ++j2;
                }
                ++i;
            }
            float[] density_tmp2 = new float[this.ndiv[2] * this.ndiv[1] * this.ndiv_buff[0]];
            int i2 = 0;
            while (i2 < this.ndiv_buff[0]) {
                j = 0;
                while (j < n3 * this.ndiv_buff[2] * this.ndiv_buff[1]) {
                    int nold = i2 * n3 * this.ndiv_buff[2] * this.ndiv_buff[1] + j;
                    int k = 0;
                    while (k < n2) {
                        int tmp = k * this.ndiv_buff[1] * this.ndiv[2];
                        int nnew2 = i2 * this.ndiv[1] * this.ndiv[2] + j + tmp;
                        density_tmp2[nnew2] = density_tmp[nold];
                        ++k;
                    }
                    ++j;
                }
                ++i2;
            }
            if (!this.pbc) {
                this.density = new float[this.Ntot];
                i2 = 0;
                while (i2 < density_tmp2.length) {
                    j = 0;
                    while (j < n1) {
                        int nnew3 = j * density_tmp2.length + i2;
                        this.density[nnew3] = density_tmp2[i2];
                        ++j;
                    }
                    ++i2;
                }
            } else {
                float[] den = new float[this.Ntot];
                int[] ndi = new int[]{this.ndiv[0], this.ndiv[1], this.ndiv[2]};
                int i3 = 0;
                while (i3 < density_tmp2.length) {
                    int j3 = 0;
                    while (j3 < n1) {
                        nnew = j3 * density_tmp2.length + i3;
                        den[nnew] = density_tmp2[i3];
                        ++j3;
                    }
                    ++i3;
                }
                this.doPBC(den, ndi);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void setInterpolationScheme(int interpolationScheme) {
        this.interpolationScheme = interpolationScheme;
    }

    public int binarySearch(float value) {
        Arrays.sort(this.sortedDensity);
        int ret = Arrays.binarySearch(this.sortedDensity, value);
        if (ret < 0) {
            ret *= -1;
        }
        return ret;
    }

    public float[] getOrigDensity() {
        return this.density_buff;
    }

    public float[] getOrigin() {
        return this.origin;
    }

    public void createBuffer(float[] den, int[] ndi) {
        this.init(den, ndi);
    }

    private void init(float[] den, int[] ndi) {
        int i;
        if (den != null) {
            i = 0;
            while (i < den.length) {
                if (den[i] != meaninglessValue) {
                    if (den[i] < this.minVal) {
                        this.minVal = den[i];
                    } else if (den[i] > this.maxVal) {
                        this.maxVal = den[i];
                    }
                }
                ++i;
            }
            this.sortedDensity = new float[den.length];
            this.density_buff = new float[den.length];
            i = 0;
            while (i < this.sortedDensity.length) {
                this.sortedDensity[i] = den[i];
                this.density_buff[i] = den[i];
                ++i;
            }
            if (this.interpolationScheme == LOG) {
                this.midVal = (float)BaseColorMap.getValueFromLogScaledValue(this.minVal, this.maxVal, 0.5);
            } else if (this.interpolationScheme == LINEAR) {
                this.midVal = (float)BaseColorMap.getValueFromLinearScaledValue(this.minVal, this.maxVal, 0.5);
            }
        }
        if (this.ndiv != null) {
            this.ndiv_buff = new int[ndi.length];
            i = 0;
            while (i < this.ndiv_buff.length) {
                this.ndiv_buff[i] = ndi[i];
                ++i;
            }
        }
        if (this.delta != null) {
            this.delta_buff = new float[3][3];
            i = 0;
            while (i < this.delta.length) {
                int j = 0;
                while (j < this.delta[i].length) {
                    this.delta_buff[i][j] = this.delta[i][j];
                    ++j;
                }
                ++i;
            }
        }
    }

    public float getMinVal() {
        return this.minVal;
    }

    public float getMaxVal() {
        return this.maxVal;
    }

    public int[] getNumDiv() {
        return this.ndiv;
    }

    public int getNtot() {
        if (this.ndiv == null || this.ndiv.length < 3) {
            return -1;
        }
        return this.ndiv[0] * this.ndiv[1] * this.ndiv[2];
    }

    public float getMidVal() {
        return this.midVal;
    }

    private float[] getShiftedDensity() {
        this.stripPBC();
        float[] den_tmp = new float[this.density.length];
        int i = 0;
        while (i < den_tmp.length) {
            den_tmp[i] = this.density[i];
            ++i;
        }
        i = 0;
        while (i < this.ndiv[2]) {
            int j = 0;
            while (j < this.ndiv[1]) {
                int k = 0;
                while (k < this.ndiv[0]) {
                    int itmp = i + this.nshift2;
                    int jtmp = j + this.nshift1;
                    int ktmp = k + this.nshift0;
                    if (itmp >= this.ndiv[2]) {
                        itmp -= this.ndiv[2];
                    } else if (itmp < 0) {
                        itmp += this.ndiv[2];
                    }
                    if (jtmp >= this.ndiv[1]) {
                        jtmp -= this.ndiv[1];
                    } else if (jtmp < 0) {
                        jtmp += this.ndiv[1];
                    }
                    if (ktmp >= this.ndiv[0]) {
                        ktmp -= this.ndiv[0];
                    } else if (ktmp < 0) {
                        ktmp += this.ndiv[0];
                    }
                    int ind1 = i + j * this.ndiv[2] + k * this.ndiv[2] * this.ndiv[1];
                    int ind2 = itmp + jtmp * this.ndiv[2] + ktmp * this.ndiv[2] * this.ndiv[1];
                    den_tmp[ind2] = this.density[ind1];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        this.doPBC(this.density, this.ndiv);
        den_tmp = this.doPBC(den_tmp);
        return den_tmp;
    }

    public float[] getDensity() {
        if (this.nshift0 == 0 && this.nshift1 == 0 && this.nshift2 == 0) {
            return this.density;
        }
        return this.getShiftedDensity();
    }

    public float[][][][] getCoordinates_explicitIndeces() {
        float[][][][] ret = new float[this.ndiv[2]][this.ndiv[1]][this.ndiv[0]][3];
        int i = 0;
        while (i < this.ndiv[2]) {
            int j = 0;
            while (j < this.ndiv[1]) {
                int k = 0;
                while (k < this.ndiv[0]) {
                    ret[i][j][k][0] = (float)k * this.delta[0][0] + (float)j * this.delta[1][0] + (float)i * this.delta[2][0];
                    ret[i][j][k][1] = (float)k * this.delta[0][1] + (float)j * this.delta[1][1] + (float)i * this.delta[2][1];
                    ret[i][j][k][2] = (float)k * this.delta[0][2] + (float)j * this.delta[1][2] + (float)i * this.delta[2][2];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public float[][][][] getCoordinates_explicitIndeces(float lenmax, float[] jusin) {
        float[][][][] ret = new float[this.ndiv[2]][this.ndiv[1]][this.ndiv[0]][3];
        int i = 0;
        while (i < this.ndiv[2]) {
            int j = 0;
            while (j < this.ndiv[1]) {
                int k = 0;
                while (k < this.ndiv[0]) {
                    ret[i][j][k][0] = ((float)k * this.delta[0][0] + (float)j * this.delta[1][0] + (float)i * this.delta[2][0] - jusin[0]) / lenmax;
                    ret[i][j][k][1] = ((float)k * this.delta[0][1] + (float)j * this.delta[1][1] + (float)i * this.delta[2][1] - jusin[1]) / lenmax;
                    ret[i][j][k][2] = ((float)k * this.delta[0][2] + (float)j * this.delta[1][2] + (float)i * this.delta[2][2] - jusin[2]) / lenmax;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public float[][][] getValue_explicitIndeces() {
        float[][][] ret = new float[this.ndiv[2]][this.ndiv[1]][this.ndiv[0]];
        if (this.nshift0 == 0 && this.nshift1 == 0 && this.nshift2 == 0) {
            int i = 0;
            while (i < this.ndiv[2]) {
                int j = 0;
                while (j < this.ndiv[1]) {
                    int k = 0;
                    while (k < this.ndiv[0]) {
                        int n = i + j * this.ndiv[2] + k * this.ndiv[2] * this.ndiv[1];
                        ret[i][j][k] = this.density[n];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            float[] den = this.getShiftedDensity();
            int i = 0;
            while (i < this.ndiv[2]) {
                int j = 0;
                while (j < this.ndiv[1]) {
                    int k = 0;
                    while (k < this.ndiv[0]) {
                        int n = i + j * this.ndiv[2] + k * this.ndiv[2] * this.ndiv[1];
                        ret[i][j][k] = den[n];
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return ret;
    }

    public float[][] getCoordinates() {
        float[][] ret = new float[3][this.Ntot];
        int i = 0;
        while (i < this.ndiv[2]) {
            int j = 0;
            while (j < this.ndiv[1]) {
                int k = 0;
                while (k < this.ndiv[0]) {
                    int n = i + j * this.ndiv[2] + k * this.ndiv[2] * this.ndiv[1];
                    ret[0][n] = (float)k * this.delta[0][0] + (float)j * this.delta[1][0] + (float)i * this.delta[2][0];
                    ret[1][n] = (float)k * this.delta[0][1] + (float)j * this.delta[1][1] + (float)i * this.delta[2][1];
                    ret[2][n] = (float)k * this.delta[0][2] + (float)j * this.delta[1][2] + (float)i * this.delta[2][2];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private int[] get3DIndexFrom1DIndex(int index1d) {
        int nz = index1d % this.ndiv[2];
        int ny = (index1d - nz) / this.ndiv[2] % this.ndiv[1];
        int nx = ((index1d - nz) / this.ndiv[2] - ny) / this.ndiv[1];
        return new int[]{nx, ny, nz};
    }

    private float[] getCoordinatesFrom(int[] index) {
        float[] ret = new float[3];
        int i = 0;
        while (i < 3) {
            ret[i] = 0.0f;
            int j = 0;
            while (j < 3) {
                int n = i;
                ret[n] = ret[n] + (float)index[j] * this.delta[j][i];
                ++j;
            }
            int n = i;
            ret[n] = ret[n] + this.origin[i];
            ++i;
        }
        return ret;
    }

    private float[] getCoordinatesFrom(int index) {
        return this.getCoordinatesFrom(this.get3DIndexFrom1DIndex(index));
    }

    public int getInterpolationScheme() {
        return this.interpolationScheme;
    }

    public String toString() {
        String ret = "min: " + String.valueOf(this.minVal) + ", max: " + String.valueOf(this.maxVal);
        return ret;
    }

    public float[][] getDelta() {
        return this.delta;
    }

    public void setDelta(float[][] delta) {
        this.delta = delta;
    }

    public void setDensity(float[] density) {
        this.density = density;
    }
}

