/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.UndoRedoObject;
import java.util.Stack;
import org.apache.log4j.Logger;

public class UndoRedo {
    private Logger logger = Logger.getLogger((String)UndoRedo.class.getName());
    private AtomList list;
    private Stack undoStack = new Stack();
    private Stack redoStack = new Stack();
    private Stack undoCount = new Stack();
    private Stack redoCount = new Stack();

    public UndoRedo(AtomList list) {
        this.list = list;
    }

    protected void init() {
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.undoCount = new Stack();
        this.redoCount = new Stack();
    }

    protected void addEntry(Atom atom, int index, int mode) {
        Atom copy = null;
        if (atom != null) {
            copy = atom.getCopy();
        }
        UndoRedoObject uro = new UndoRedoObject(copy, index, mode);
        this.undoStack.push(uro);
        this.redoStack.clear();
        this.redoCount.clear();
        this.logger.debug((Object)("pushed: " + uro));
    }

    protected void addEntry(Cell cell) {
        Cell copy = null;
        if (cell != null) {
            copy = cell.getCopy();
        }
        UndoRedoObject uro = new UndoRedoObject(copy);
        this.undoStack.push(uro);
        this.redoStack.clear();
        this.redoCount.clear();
    }

    protected void setUndoCount(int count) {
        this.undoCount.push(new Integer(count));
    }

    /*
     * Unable to fully structure code
     */
    protected boolean undoToFirstEntry() {
        if (!this.undoStack.empty()) ** GOTO lbl6
        this.logger.info((Object)"undo stack empty.");
        return false;
lbl-1000:
        // 1 sources

        {
            this.undo();
lbl6:
            // 2 sources

            ** while (!this.undoStack.empty())
        }
lbl7:
        // 1 sources

        return true;
    }

    protected boolean undo() {
        if (this.undoStack.empty()) {
            this.logger.info((Object)"undo stack empty.");
            return false;
        }
        int count = 1;
        if (!this.undoCount.empty()) {
            count = (Integer)this.undoCount.pop();
        }
        int i = 0;
        while (i < count) {
            UndoRedoObject uro = (UndoRedoObject)this.undoStack.pop();
            this.redoStack.push(this.doIt(this.undoStack, uro));
            ++i;
        }
        this.redoCount.push(new Integer(count));
        return true;
    }

    protected boolean redo() {
        if (this.redoStack.empty()) {
            this.logger.info((Object)"redo stack empty.");
            return false;
        }
        int count = 1;
        if (!this.redoCount.empty()) {
            count = (Integer)this.redoCount.pop();
        }
        int i = 0;
        while (i < count) {
            UndoRedoObject uro = (UndoRedoObject)this.redoStack.pop();
            this.undoStack.push(this.doIt(this.redoStack, uro));
            ++i;
        }
        this.undoCount.push(new Integer(count));
        return true;
    }

    private UndoRedoObject doIt(Stack stack, UndoRedoObject uro) {
        if (uro.isCell()) {
            Cell cell = uro.getCell();
            Cell tmpcell = this.list.getParent().getCell(cell.getCellScheme());
            this.list.getParent().setCell(cell, false);
            return new UndoRedoObject(tmpcell);
        }
        Atom atom = uro.getAtom();
        int index = uro.getIndex();
        int mode = uro.getMode();
        this.logger.debug((Object)("old UndoRedo: " + uro));
        if (atom == null || mode == UndoRedoObject.ADD) {
            this.list.removeAtomAt(index, false);
            UndoRedoObject newuro = new UndoRedoObject(atom, index, UndoRedoObject.REMOVE);
            this.logger.debug((Object)("new UndoRedoObject: " + newuro));
            return newuro;
        }
        int retmode = UndoRedoObject.ADD;
        Atom retAtom = null;
        if (mode == UndoRedoObject.REPLACE) {
            if (index < this.list.size()) {
                retAtom = ((Atom)this.list.get(index)).getCopy();
                this.list.replaceAtomAt(index, atom, false);
                this.logger.debug((Object)"at doIt.REPLACE");
                retmode = UndoRedoObject.REPLACE;
            } else {
                retAtom = atom;
                this.list.addAtom(atom, false);
                this.logger.debug((Object)"at doIt.REPLACE");
            }
        } else if (mode == UndoRedoObject.REMOVE) {
            if (index < this.list.size()) {
                retAtom = atom;
                this.list.addAtomAt(index, atom, false);
                this.logger.debug((Object)("at doIt.REMOVE; index: " + index));
            } else {
                retAtom = atom;
                this.list.addAtom(atom, false);
                this.logger.debug((Object)"at doIt.REMOVE");
            }
        }
        UndoRedoObject newuro = new UndoRedoObject(retAtom, index, retmode);
        this.logger.debug((Object)("new UndoRedoObject: " + newuro));
        return newuro;
    }

    public void nullify() {
        UndoRedoObject uro;
        while (!this.undoStack.empty()) {
            uro = (UndoRedoObject)this.undoStack.pop();
            uro.nullify();
        }
        this.undoStack = null;
        while (!this.redoStack.empty()) {
            uro = (UndoRedoObject)this.redoStack.pop();
            uro.nullify();
        }
        this.redoStack = null;
        this.list = null;
    }
}

