/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.common.VectorOperations;
import ciss.phase_viewer.inputinterface.InputInterface;
import java.text.DecimalFormat;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;

public class Cell {
    private static Logger logger = Logger.getLogger((String)Cell.class.getName());
    public static final int CELL_VEC = 0;
    public static final int CELL_ABC = 1;
    private int cellScheme = 0;
    private String[][] cell;
    private double[] cellOffset = new double[]{0.0, 0.0, 0.0};
    private DecimalFormat dformat = new DecimalFormat("#.##########");

    public Cell(String[][] cell, int cellScheme) {
        this.cell = cell;
        this.cellScheme = cellScheme;
    }

    public Cell(String a, String b, String c, String alpha, String beta, String gamma) {
        this.cellScheme = 1;
        this.cell = new String[2][3];
        this.cell[0][0] = a;
        this.cell[0][1] = b;
        this.cell[0][2] = c;
        this.cell[1][0] = alpha;
        this.cell[1][1] = beta;
        this.cell[1][2] = gamma;
    }

    public Cell(String[] a, String[] b, String[] c) {
        this.cellScheme = 0;
        this.cell = new String[3][3];
        this.cell[0] = a;
        this.cell[1] = b;
        this.cell[2] = c;
    }

    public Cell(double a, double b, double c, double alpha, double beta, double gamma) {
        this.cellScheme = 1;
        this.cell = new String[2][3];
        this.cell[0][0] = Double.toString(a);
        this.cell[0][1] = Double.toString(b);
        this.cell[0][2] = Double.toString(c);
        this.cell[1][0] = Double.toString(alpha);
        this.cell[1][1] = Double.toString(beta);
        this.cell[1][2] = Double.toString(gamma);
    }

    public Cell(double[] a, double[] b, double[] c) {
        this.cellScheme = 0;
        this.cell = new String[3][3];
        int i = 0;
        while (i < 3) {
            this.cell[0][i] = Double.toString(a[i]);
            this.cell[1][i] = Double.toString(b[i]);
            this.cell[2][i] = Double.toString(c[i]);
            ++i;
        }
    }

    public Cell getCopy() {
        return new Cell(this.cell, this.cellScheme);
    }

    public int getCellScheme() {
        return this.cellScheme;
    }

    public String[][] getCell() {
        return this.cell;
    }

    public double[][] getDouble() {
        int irow = 3;
        if (this.cellScheme == 1) {
            irow = 2;
        }
        double[][] ret = new double[irow][3];
        int i = 0;
        while (i < irow) {
            int j = 0;
            while (j < 3) {
                try {
                    ret[i][j] = Double.parseDouble(this.cell[i][j]);
                }
                catch (NumberFormatException nfe) {
                    logger.warn((Object)"failed to get a 'double' representation of cell");
                    return null;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public double[][] getReciprocalLattice() {
        int i;
        double[][] dcell = this.getDouble();
        double[][] cellVec = null;
        if (dcell == null) {
            return null;
        }
        if (dcell.length < 2) {
            return null;
        }
        if (dcell.length == 2) {
            int j;
            double[] cellLength = dcell[0];
            double alpha = dcell[1][0] * (Math.PI / 180);
            double beta = dcell[1][1] * (Math.PI / 180);
            double gamma = dcell[1][2] * (Math.PI / 180);
            double temp = 0.0;
            cellVec = new double[3][3];
            i = 0;
            while (i < 3) {
                j = 0;
                while (j < 3) {
                    cellVec[i][j] = 0.0;
                    ++j;
                }
                ++i;
            }
            cellVec[0][0] = 1.0;
            cellVec[1][0] = Math.cos(gamma);
            cellVec[2][0] = Math.cos(beta);
            cellVec[1][1] = Math.sin(gamma);
            cellVec[2][1] = temp = (Math.cos(alpha) - Math.cos(beta) * Math.cos(gamma)) / Math.sin(gamma);
            cellVec[2][2] = Math.sqrt(Math.sin(beta) * Math.sin(beta) - temp * temp);
            i = 0;
            while (i < 3) {
                j = 0;
                while (j < 3) {
                    double[] dArray = cellVec[j];
                    int n = i;
                    dArray[n] = dArray[n] * cellLength[j];
                    ++j;
                }
                ++i;
            }
        } else if (dcell.length == 3) {
            cellVec = dcell;
        }
        if (cellVec == null) {
            return null;
        }
        double[] b_cross_c = VectorOperations.crossProduct(cellVec[1], cellVec[2]);
        double[] c_cross_a = VectorOperations.crossProduct(cellVec[2], cellVec[0]);
        double[] a_cross_b = VectorOperations.crossProduct(cellVec[0], cellVec[1]);
        double volume = VectorOperations.dotProduct(cellVec[0], b_cross_c);
        if (volume == 0.0) {
            return null;
        }
        double twoPI = Math.PI * 2;
        double factor = Math.PI * 2 / volume;
        i = 0;
        while (i < 3) {
            int n = i;
            b_cross_c[n] = b_cross_c[n] * factor;
            int n2 = i;
            c_cross_a[n2] = c_cross_a[n2] * factor;
            int n3 = i++;
            a_cross_b[n3] = a_cross_b[n3] * factor;
        }
        return new double[][]{b_cross_c, c_cross_a, a_cross_b};
    }

    public void setCellOffset(double[] offset) {
        this.cellOffset = offset;
    }

    public double[] getCellOffset() {
        return this.cellOffset;
    }

    public Element getXMLElement() {
        Element element = new Element("cell");
        if (this.cellScheme == 0) {
            Element a = new Element("a_vec").setText(String.valueOf(this.cell[0][0]) + " " + this.cell[0][1] + " " + this.cell[0][2]);
            Element b = new Element("b_vec").setText(String.valueOf(this.cell[1][0]) + " " + this.cell[1][1] + " " + this.cell[1][2]);
            Element c = new Element("c_vec").setText(String.valueOf(this.cell[2][0]) + " " + this.cell[2][1] + " " + this.cell[2][2]);
            element.addContent((Content)a);
            element.addContent((Content)b);
            element.addContent((Content)c);
        } else {
            Element a = new Element("a").setText(this.cell[0][0]);
            Element b = new Element("b").setText(this.cell[0][1]);
            Element c = new Element("c").setText(this.cell[0][2]);
            Element alpha = new Element("alpha").setText(this.cell[1][0]);
            Element beta = new Element("beta").setText(this.cell[1][1]);
            Element gamma = new Element("gamma").setText(this.cell[1][2]);
            element.addContent((Content)a);
            element.addContent((Content)b);
            element.addContent((Content)c);
            element.addContent((Content)alpha);
            element.addContent((Content)beta);
            element.addContent((Content)gamma);
        }
        return element;
    }

    public static Cell[] createFrom(Element elem) {
        Cell[] ret = new Cell[2];
        String avec = elem.getChildTextTrim("a_vec");
        String bvec = elem.getChildTextTrim("b_vec");
        String cvec = elem.getChildTextTrim("c_vec");
        if (avec != null && bvec != null && cvec != null) {
            String[] aarray = avec.split("\\s+");
            String[] barray = bvec.split("\\s+");
            String[] carray = cvec.split("\\s+");
            if (aarray != null && aarray.length >= 3 && barray != null && barray.length >= 3 && carray != null && carray.length >= 3) {
                ret[0] = new Cell(aarray, barray, carray);
            }
        }
        String a = elem.getChildTextTrim("a");
        String b = elem.getChildTextTrim("b");
        String c = elem.getChildTextTrim("c");
        String alpha = elem.getChildTextTrim("alpha");
        String beta = elem.getChildTextTrim("beta");
        String gamma = elem.getChildTextTrim("gamma");
        if (a != null && a.length() != 0 && b != null && b.length() != 0 && c != null && c.length() != 0 && alpha != null && alpha.length() != 0 && beta != null && beta.length() != 0 && gamma != null && gamma.length() != 0) {
            ret[1] = new Cell(a, b, c, alpha, beta, gamma);
        }
        return ret;
    }

    public static Cell createFrom(InputInterface inputInterface) {
        String avec = inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.a_vector").getValue();
        String a = inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.a").getValue();
        if (avec.trim().length() != 0) {
            String bvec = inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.b_vector").getValue();
            String cvec = inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.c_vector").getValue();
            try {
                String[] av = avec.split("\\s+");
                String[] bv = bvec.split("\\s+");
                String[] cv = cvec.split("\\s+");
                double[] dav = new double[]{Double.parseDouble(av[0]), Double.parseDouble(av[1]), Double.parseDouble(av[2])};
                double[] dbv = new double[]{Double.parseDouble(bv[0]), Double.parseDouble(bv[1]), Double.parseDouble(bv[2])};
                double[] dcv = new double[]{Double.parseDouble(cv[0]), Double.parseDouble(cv[1]), Double.parseDouble(cv[2])};
                return new Cell(dav, dbv, dcv);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            catch (ArrayIndexOutOfBoundsException ai) {
                return null;
            }
        }
        if (a.trim().length() != 0) {
            String b = inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.b").getValue();
            String c = inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.c").getValue();
            String alpha = inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.alpha").getValue();
            String beta = inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.beta").getValue();
            String gamma = inputInterface.getInputInterfacePrimitiveEntry("structure.unit_cell.gamma").getValue();
            try {
                return new Cell(Double.parseDouble(a), Double.parseDouble(b), Double.parseDouble(c), Double.parseDouble(alpha), Double.parseDouble(beta), Double.parseDouble(gamma));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    public String toString() {
        String[][] ce = this.getCell();
        String ret = "";
        int i = 0;
        while (i < ce.length) {
            int j = 0;
            while (j < ce[i].length) {
                if (ce[i][j] != null) {
                    ret = String.valueOf(ret) + " " + ce[i][j] + " ";
                }
                ++j;
            }
            ret = String.valueOf(ret) + System.getProperty("line.separator");
            ++i;
        }
        return ret;
    }
}

