/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.atomcoord.AtomEditor;
import ciss.phase_viewer.atomcoord.AtomEditorEditors;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JTextField;

class AtomEditorTextField
extends JTextField
implements AtomEditorEditors {
    private String name;
    private AtomEditor parent;
    private DecimalFormat formater;
    private ActionListener[] listeners;

    AtomEditorTextField(String name, String init, AtomEditor parent, DecimalFormat formater) {
        super(init);
        this.setColumns(6);
        this.name = name;
        this.parent = parent;
        this.formater = formater;
        this.addListener();
    }

    @Override
    public void removeListeners() {
        this.listeners = this.getActionListeners();
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.length) {
            this.removeActionListener(this.listeners[i]);
            ++i;
        }
    }

    @Override
    public void restoreListeners() {
        if (this.listeners == null) {
            return;
        }
        int i = 0;
        while (i < this.listeners.length) {
            this.addActionListener(this.listeners[i]);
            ++i;
        }
    }

    private void addListener() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtomEditorTextField.this.parent.doIt();
            }
        });
    }

    @Override
    public String getValue() {
        return this.getText();
    }

    @Override
    public String getIdentifiers() {
        return this.name;
    }

    @Override
    public void setValue(String value) {
        String formatted = value;
        if (this.formater != null) {
            try {
                formatted = this.formater.format(Double.parseDouble(value));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
        this.setText(formatted);
        this.setCaretPosition(0);
    }
}

