/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomEditorEditors;
import ciss.phase_viewer.atomcoord.AtomEditors;
import ciss.phase_viewer.atomcoord.AtomEvent;
import ciss.phase_viewer.atomcoord.AtomListener;
import ciss.phase_viewer.common.TaggedString;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class AtomEditor
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)AtomEditor.class.getName());
    protected InputInterfaceTableColumns[] columns;
    private Vector atomListeners;
    protected Atom atom;
    protected int atomIndex;
    protected boolean newAtom = false;
    private String element = "element";
    private String rx = "rx";
    private String ry = "ry";
    private String rz = "rz";
    private Vector editors = new Vector();

    public AtomEditor(InputInterfaceTableColumns[] columns, String title, Dimension dimension) {
        super(title, dimension);
        this.columns = columns;
        this.atomIndex = -1;
        this.init();
        this.setVisible(true);
    }

    public AtomEditor(InputInterfaceTableColumns[] columns, Atom atom, boolean newAtom, int atomIndex, String title, Dimension dimension) {
        super(title, dimension);
        this.columns = columns;
        this.atom = atom;
        this.atomIndex = atomIndex;
        this.newAtom = newAtom;
        this.init();
        this.setVisible(true);
    }

    public void addAtomListener(AtomListener atomListener) {
        if (this.atomListeners == null) {
            this.atomListeners = new Vector();
        }
        this.atomListeners.addElement(atomListener);
    }

    private void init() {
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JScrollPane scr = new JScrollPane();
        int compCount = 0;
        JPanel p = null;
        int ign = 0;
        int i = 0;
        while (i < this.columns.length) {
            if (this.columns[i].ignoreOnSave()) {
                ++ign;
            }
            ++i;
        }
        int foo = this.columns.length % 4;
        int dummy = 4 - foo + ign;
        if (foo - ign == 0) {
            dummy = 0;
        }
        int i2 = 0;
        while (i2 < this.columns.length + dummy) {
            block7: {
                block8: {
                    block6: {
                        if (compCount == 0) {
                            p = new JPanel();
                            p.setLayout(new GridLayout(1, 4));
                        }
                        if (i2 >= this.columns.length) break block6;
                        if (this.columns[i2].ignoreOnSave()) break block7;
                        this.logger.debug((Object)("creating gui for: " + this.columns[i2].getName()));
                        p.add(this.createPanelFrom(this.columns[i2]));
                        break block8;
                    }
                    p.add(new JPanel());
                }
                if (++compCount == 4) {
                    compCount = 0;
                    container.add(p);
                }
            }
            ++i2;
        }
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new BoxLayout(btnpanel, 0));
        JButton btnok = new JButton("apply");
        JButton rmv = new JButton("remove selected");
        JButton btnclose = new JButton("close");
        btnpanel.add(btnok);
        btnpanel.add(rmv);
        btnpanel.add(btnclose);
        btnok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtomEditor.this.doIt();
            }
        });
        rmv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AtomEditor.this.removeSelected();
            }
        });
        btnclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AtomEditor.this.dispose();
            }
        });
        container.add(btnpanel);
    }

    protected void removeSelected() {
    }

    private JPanel createPanelFrom(InputInterfaceTableColumns column) {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(column.getName()));
        AtomEditorEditors editor = AtomEditors.getInstance(column, this.atom, this);
        panel.add((JComponent)((Object)editor));
        panel.setToolTipText(column.getToolTip());
        this.editors.addElement(editor);
        return panel;
    }

    protected void setValue(Atom newAtom) {
        if (this.editors == null) {
            return;
        }
        int i = 0;
        while (i < this.editors.size()) {
            AtomEditorEditors edi = (AtomEditorEditors)this.editors.elementAt(i);
            edi.removeListeners();
            AtomEditors.setValue(edi, edi.getIdentifiers(), newAtom);
            edi.restoreListeners();
            this.logger.debug((Object)("atom: " + newAtom));
            ++i;
        }
    }

    protected void doIt() {
        if (this.atomListeners == null) {
            return;
        }
        String elem = "";
        String[] pos = new String[3];
        Vector<TaggedString> auxvec = new Vector<TaggedString>();
        int i = 0;
        while (i < this.editors.size()) {
            AtomEditorEditors editor = (AtomEditorEditors)this.editors.elementAt(i);
            String ident = editor.getIdentifiers();
            if (ident.equals(this.element)) {
                elem = editor.getValue();
            } else if (ident.equals(this.rx)) {
                pos[0] = editor.getValue();
            } else if (ident.equals(this.ry)) {
                pos[1] = editor.getValue();
            } else if (ident.equals(this.rz)) {
                pos[2] = editor.getValue();
            } else {
                TaggedString aux = new TaggedString(ident, editor.getValue());
                auxvec.addElement(aux);
            }
            ++i;
        }
        this.atom = new Atom(elem, pos, auxvec);
        this.logger.debug((Object)("the atom object you've created : " + this.atom));
        int ind = this.atomIndex;
        if (this.newAtom) {
            ind = -1;
        }
        AtomEvent event = new AtomEvent(this.atom, ind);
        int i2 = 0;
        while (i2 < this.atomListeners.size()) {
            ((AtomListener)this.atomListeners.elementAt(i2)).atomStateChanged(event);
            ++i2;
        }
        this.post();
    }

    protected void post() {
    }
}

