/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements.bond;

import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.scenegraphelements.bond.BondInfo;
import ciss.phase_viewer.common.ElementDef;
import ciss.phase_viewer.common.ElementInfo;
import java.util.Arrays;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BondCalculator {
    private static Logger logger = Logger.getLogger((String)BondCalculator.class.getName());
    private int NumAt;
    private int NumBondMax;
    private int NumBond;
    private double rbond;
    private J3DDataManager mACVD;
    private ConfigDataManager mCD;
    private double[][] xyz;
    private double[][] Hatoms;
    private double[][][] HbondCandidates;
    private double[] HbondRmax;
    private double[][] hxyz;
    private int[] map;
    private double[] bigCell;
    private double[] smallCell;
    private int[] ndiv;
    private double[][] xyz_buff;
    private double[] covalentRadius;
    private double rbondMax;
    private Vector[][][] cell_atom_map;
    private String[] elements;
    private boolean[][] ignore;
    private Vector bonds;

    public BondCalculator() {
    }

    public BondCalculator(J3DDataManager mACVD, ConfigDataManager mCD) {
        this.mACVD = mACVD;
        this.mCD = mCD;
        this.NumAt = mCD.getNumAt();
        this.NumBondMax = this.NumAt * (this.NumAt - 1) / 2;
    }

    public int getNumBond() {
        return this.NumBond;
    }

    public int getNumBondMax() {
        return this.NumBondMax;
    }

    private boolean prepareForHbond() {
        this.map = new int[this.mCD.getNumAt()];
        ElementInfo einfo = ElementInfo.getElementInfo();
        ElementDef[] candidates = einfo.getHBondDonorAcceptorCandidates();
        if (candidates == null || candidates.length == 0) {
            return false;
        }
        String[] elements = this.mCD.getElements();
        Vector<double[]> vec = new Vector<double[]>();
        int count = 0;
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equals("H")) {
                vec.addElement(this.xyz[i]);
                this.map[i] = count++;
            }
            ++i;
        }
        if (vec.size() == 0) {
            logger.debug((Object)"found no H atoms");
            return false;
        }
        this.Hatoms = new double[vec.size()][];
        logger.debug((Object)("num. H atoms: " + this.Hatoms.length));
        vec.copyInto((Object[])this.Hatoms);
        vec.clear();
        this.HbondCandidates = new double[candidates.length][][];
        this.HbondRmax = new double[candidates.length];
        boolean found = false;
        this.rbondMax = -1.0E7;
        double lenmax = this.mCD.getLenMax();
        int i2 = 0;
        while (i2 < candidates.length) {
            int j = 0;
            while (j < elements.length) {
                if (candidates[i2].getSymbol().equals(elements[j])) {
                    vec.addElement(this.xyz[j]);
                    this.map[j] = count++;
                }
                ++j;
            }
            if (vec.size() != 0) {
                this.HbondCandidates[i2] = new double[vec.size()][];
                this.HbondRmax[i2] = candidates[i2].getMaxHbondDistance() / lenmax;
                if (this.HbondRmax[i2] > this.rbondMax) {
                    this.rbondMax = this.HbondRmax[i2];
                }
                vec.copyInto((Object[])this.HbondCandidates[i2]);
                found = true;
            }
            vec.clear();
            ++i2;
        }
        return found;
    }

    private void preProcessForHbond() {
        int j;
        int j2;
        double[] min = new double[3];
        double[] max = new double[3];
        int i = 0;
        while (i < 3) {
            min[i] = 1.0E7;
            max[i] = -1.0E7;
            ++i;
        }
        int numat2consider = 0;
        int i2 = 0;
        while (i2 < this.HbondCandidates.length) {
            if (this.HbondCandidates[i2] != null) {
                j2 = 0;
                while (j2 < this.HbondCandidates[i2].length) {
                    int k = 0;
                    while (k < 3) {
                        if (this.HbondCandidates[i2][j2][k] > max[k]) {
                            max[k] = this.HbondCandidates[i2][j2][k];
                        }
                        if (this.HbondCandidates[i2][j2][k] < min[k]) {
                            min[k] = this.HbondCandidates[i2][j2][k];
                        }
                        ++k;
                    }
                    ++numat2consider;
                    ++j2;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.Hatoms.length) {
            j2 = 0;
            while (j2 < this.Hatoms[i2].length) {
                if (this.Hatoms[i2][j2] > max[j2]) {
                    max[j2] = this.Hatoms[i2][j2];
                }
                if (this.Hatoms[i2][j2] < min[j2]) {
                    min[j2] = this.Hatoms[i2][j2];
                }
                ++j2;
            }
            ++numat2consider;
            ++i2;
        }
        this.bigCell = new double[3];
        i2 = 0;
        while (i2 < 3) {
            this.bigCell[i2] = max[i2] - min[i2] + 0.01;
            ++i2;
        }
        this.NumAt = numat2consider;
        this.xyz_buff = new double[numat2consider][3];
        this.hxyz = new double[numat2consider][3];
        this.covalentRadius = new double[numat2consider];
        int count = 0;
        int i3 = 0;
        while (i3 < this.Hatoms.length) {
            j = 0;
            while (j < 3) {
                this.xyz_buff[count][j] = this.Hatoms[i3][j] - min[j];
                this.hxyz[count][j] = this.Hatoms[i3][j];
                this.covalentRadius[count] = 0.0;
                ++j;
            }
            ++count;
            ++i3;
        }
        i3 = 0;
        while (i3 < this.HbondCandidates.length) {
            if (this.HbondCandidates[i3] != null) {
                j = 0;
                while (j < this.HbondCandidates[i3].length) {
                    int k = 0;
                    while (k < 3) {
                        this.xyz_buff[count][k] = this.HbondCandidates[i3][j][k] - min[k];
                        this.hxyz[count][k] = this.HbondCandidates[i3][j][k];
                        this.covalentRadius[count] = this.HbondRmax[i3];
                        ++k;
                    }
                    ++count;
                    ++j;
                }
            }
            ++i3;
        }
        this.ndiv = new int[3];
        this.smallCell = new double[3];
        logger.debug((Object)("rbondMax: " + this.rbondMax));
        i3 = 0;
        while (i3 < 3) {
            this.ndiv[i3] = (int)(this.bigCell[i3] / this.rbondMax) + 1;
            this.smallCell[i3] = this.bigCell[i3] / (double)this.ndiv[i3];
            ++i3;
        }
        logger.debug((Object)("ndiv: " + this.ndiv[0] + ", " + this.ndiv[1] + ", " + this.ndiv[2]));
        logger.debug((Object)("smallCell: " + this.smallCell[0] + ", " + this.smallCell[1] + ", " + this.smallCell[2]));
        this.cell_atom_map = new Vector[this.ndiv[0]][this.ndiv[1]][this.ndiv[2]];
        int i1 = 0;
        while (i1 < this.ndiv[0]) {
            int i22 = 0;
            while (i22 < this.ndiv[1]) {
                int i32 = 0;
                while (i32 < this.ndiv[2]) {
                    this.cell_atom_map[i1][i22][i32] = null;
                    ++i32;
                }
                ++i22;
            }
            ++i1;
        }
        i3 = 0;
        while (i3 < this.xyz_buff.length) {
            int i12 = (int)(this.xyz_buff[i3][0] / this.smallCell[0]);
            int i23 = (int)(this.xyz_buff[i3][1] / this.smallCell[1]);
            int i33 = (int)(this.xyz_buff[i3][2] / this.smallCell[2]);
            if (this.cell_atom_map[i12][i23][i33] == null) {
                this.cell_atom_map[i12][i23][i33] = new Vector();
            }
            logger.debug((Object)("i1, i2, i3: " + i12 + ", " + i23 + ", " + i33));
            this.cell_atom_map[i12][i23][i33].addElement(new Integer(i3));
            ++i3;
        }
    }

    private void preProcess() {
        int j;
        this.NumAt = this.mCD.getNumAt();
        double[] min = new double[3];
        double[] max = new double[3];
        int i = 0;
        while (i < 3) {
            min[i] = 1.0E7;
            max[i] = -1.0E7;
            ++i;
        }
        i = 0;
        while (i < this.NumAt) {
            j = 0;
            while (j < 3) {
                if (this.xyz[i][j] > max[j]) {
                    max[j] = this.xyz[i][j];
                }
                if (this.xyz[i][j] < min[j]) {
                    min[j] = this.xyz[i][j];
                }
                ++j;
            }
            ++i;
        }
        this.bigCell = new double[3];
        i = 0;
        while (i < 3) {
            this.bigCell[i] = max[i] - min[i] + 0.01;
            ++i;
        }
        this.xyz_buff = new double[this.NumAt][3];
        i = 0;
        while (i < this.NumAt) {
            j = 0;
            while (j < 3) {
                this.xyz_buff[i][j] = this.xyz[i][j] - min[j];
                ++j;
            }
            ++i;
        }
        this.covalentRadius = new double[this.NumAt];
        int NumEl = this.mACVD.getNumEl();
        this.elements = this.mCD.getElements();
        String[] elementString = new String[NumEl];
        double[] covRad = new double[NumEl];
        double lenMax = this.mCD.getLenMax();
        double bondFactor = this.mACVD.getBondFactor();
        int jele = 0;
        while (jele < NumEl) {
            elementString[jele] = this.mACVD.getElement()[jele];
            covRad[jele] = this.mACVD.getCovRad()[jele];
            ++jele;
        }
        this.rbondMax = -100000.0;
        Vector covrads = new Vector();
        i = 0;
        while (i < this.NumAt) {
            this.covalentRadius[i] = 0.0;
            int jele2 = 0;
            while (jele2 < NumEl) {
                if (this.elements[i] != null && this.elements[i].trim().length() != 0 && elementString[jele2].equals(this.elements[i])) {
                    this.covalentRadius[i] = bondFactor * covRad[jele2] / lenMax;
                }
                ++jele2;
            }
            ++i;
        }
        i = 0;
        while (i < this.covalentRadius.length) {
            if (this.covalentRadius[i] > this.rbondMax) {
                this.rbondMax = this.covalentRadius[i];
            }
            ++i;
        }
        if (this.rbondMax <= 0.0) {
            return;
        }
        this.rbondMax *= 2.0;
        this.ndiv = new int[3];
        this.smallCell = new double[3];
        logger.debug((Object)("rbondMax: " + this.rbondMax));
        i = 0;
        while (i < 3) {
            this.ndiv[i] = (int)(this.bigCell[i] / this.rbondMax) + 1;
            this.smallCell[i] = this.bigCell[i] / (double)this.ndiv[i];
            ++i;
        }
        logger.debug((Object)("ndiv: " + this.ndiv[0] + ", " + this.ndiv[1] + ", " + this.ndiv[2]));
        logger.debug((Object)("smallCell: " + this.smallCell[0] + ", " + this.smallCell[1] + ", " + this.smallCell[2]));
        this.cell_atom_map = new Vector[this.ndiv[0]][this.ndiv[1]][this.ndiv[2]];
        int i1 = 0;
        while (i1 < this.ndiv[0]) {
            int i2 = 0;
            while (i2 < this.ndiv[1]) {
                int i3 = 0;
                while (i3 < this.ndiv[2]) {
                    this.cell_atom_map[i1][i2][i3] = null;
                    ++i3;
                }
                ++i2;
            }
            ++i1;
        }
        int ii = 0;
        while (ii < this.NumAt) {
            int i12 = (int)(this.xyz_buff[ii][0] / this.smallCell[0]);
            int i2 = (int)(this.xyz_buff[ii][1] / this.smallCell[1]);
            int i3 = (int)(this.xyz_buff[ii][2] / this.smallCell[2]);
            if (this.cell_atom_map[i12][i2][i3] == null) {
                this.cell_atom_map[i12][i2][i3] = new Vector();
            }
            logger.debug((Object)("ii, i1, i2, i3: " + i12 + ", " + i2 + ", " + i3 + ", " + ii));
            this.cell_atom_map[i12][i2][i3].addElement(new Integer(ii));
            ++ii;
        }
    }

    public void setIgnore(boolean[][] ignore) {
        this.ignore = ignore;
    }

    public Vector getBonds() {
        return this.bonds;
    }

    public void doHbond(double[][] xyz) {
        this.xyz = xyz;
        if (!this.prepareForHbond()) {
            logger.debug((Object)"no Hbonds");
            return;
        }
        this.preProcessForHbond();
        this.bonds = new Vector();
        if (this.rbondMax <= 0.0) {
            return;
        }
        int i = 0;
        while (i < this.Hatoms.length) {
            Vector<BondInfo> bondInfos = new Vector<BondInfo>();
            int i1 = (int)(this.xyz_buff[i][0] / this.smallCell[0]);
            int i2 = (int)(this.xyz_buff[i][1] / this.smallCell[1]);
            int i3 = (int)(this.xyz_buff[i][2] / this.smallCell[2]);
            Vector centerCell = this.cell_atom_map[i1][i2][i3];
            if (centerCell != null) {
                logger.debug((Object)("num. atoms in cell: " + centerCell.size()));
                int ind1 = i;
                int ii1 = i1 - 1;
                while (ii1 <= i1 + 1) {
                    int ii2 = i2 - 1;
                    while (ii2 <= i2 + 1) {
                        int ii3 = i3 - 1;
                        while (ii3 <= i3 + 1) {
                            Vector vec;
                            if (ii1 >= 0 && ii2 >= 0 && ii3 >= 0 && ii1 < this.ndiv[0] && ii2 < this.ndiv[1] && ii3 < this.ndiv[2] && (vec = this.cell_atom_map[ii1][ii2][ii3]) != null) {
                                int ic2 = 0;
                                while (ic2 < vec.size()) {
                                    int ind2 = (Integer)vec.get(ic2);
                                    if (!(ind2 < this.Hatoms.length || this.ignore != null && this.ignore[this.map[ind1]][this.map[ind2]])) {
                                        double rbond2 = Math.pow(this.covalentRadius[ind2], 2.0);
                                        double r2 = Math.pow(this.xyz_buff[ind1][0] - this.xyz_buff[ind2][0], 2.0) + Math.pow(this.xyz_buff[ind1][1] - this.xyz_buff[ind2][1], 2.0) + Math.pow(this.xyz_buff[ind1][2] - this.xyz_buff[ind2][2], 2.0);
                                        if (r2 < rbond2 && r2 != 0.0) {
                                            logger.debug((Object)("neighboring cell: rbond2, r2 " + rbond2 + ", " + r2));
                                            logger.debug((Object)("and their indeces: " + ind1 + ", " + ind2));
                                            double[] NearestNeighbor_ = new double[]{this.hxyz[ind1][0], this.hxyz[ind1][1], this.hxyz[ind1][2], this.hxyz[ind2][0], this.hxyz[ind2][1], this.hxyz[ind2][2]};
                                            BondInfo binf = new BondInfo(ind1, ind2, NearestNeighbor_);
                                            binf.setBondLengthSquared(r2);
                                            binf.setCriticalDistanceSquared(rbond2);
                                            bondInfos.add(binf);
                                        }
                                    }
                                    ++ic2;
                                }
                            }
                            ++ii3;
                        }
                        ++ii2;
                    }
                    ++ii1;
                }
                if (bondInfos.size() < 2) {
                    bondInfos.clear();
                } else {
                    Object[] bi = new BondInfo[bondInfos.size()];
                    bondInfos.copyInto(bi);
                    Arrays.sort(bi);
                    double lenmax = this.mCD.getLenMax();
                    logger.debug((Object)("bi 0 and 1 " + ((BondInfo)bi[0]).getBondLength() * lenmax + " " + ((BondInfo)bi[1]).getBondLength() * lenmax));
                    this.bonds.addElement(bi[1]);
                }
            }
            ++i;
        }
    }

    public void doIt(double[][] xyz) {
        int i3;
        int i2;
        this.xyz = xyz;
        this.preProcess();
        this.bonds = new Vector();
        if (this.rbondMax <= 0.0) {
            return;
        }
        boolean[][][] passed = new boolean[this.ndiv[0]][this.ndiv[1]][this.ndiv[2]];
        int i1 = 0;
        while (i1 < this.ndiv[0]) {
            i2 = 0;
            while (i2 < this.ndiv[1]) {
                i3 = 0;
                while (i3 < this.ndiv[2]) {
                    passed[i1][i2][i3] = false;
                    ++i3;
                }
                ++i2;
            }
            ++i1;
        }
        i1 = 0;
        while (i1 < this.ndiv[0]) {
            i2 = 0;
            while (i2 < this.ndiv[1]) {
                i3 = 0;
                while (i3 < this.ndiv[2]) {
                    passed[i1][i2][i3] = true;
                    Vector centerCell = this.cell_atom_map[i1][i2][i3];
                    if (centerCell != null) {
                        logger.debug((Object)("num. atoms in cell: " + centerCell.size()));
                        int ic1 = 0;
                        while (ic1 < centerCell.size() - 1) {
                            int ic2 = ic1 + 1;
                            while (ic2 < centerCell.size()) {
                                int ind1 = (Integer)centerCell.get(ic1);
                                int ind2 = (Integer)centerCell.get(ic2);
                                if (this.ignore == null || !this.ignore[ind1][ind2]) {
                                    double rbond2 = Math.pow(this.covalentRadius[ind1] + this.covalentRadius[ind2], 2.0);
                                    double r2 = Math.pow(this.xyz_buff[ind1][0] - this.xyz_buff[ind2][0], 2.0) + Math.pow(this.xyz_buff[ind1][1] - this.xyz_buff[ind2][1], 2.0) + Math.pow(this.xyz_buff[ind1][2] - this.xyz_buff[ind2][2], 2.0);
                                    logger.debug((Object)("foobar: rbond2, r2 " + rbond2 + ", " + r2));
                                    if (r2 < rbond2) {
                                        double[] NearestNeighbor_ = new double[]{xyz[ind1][0], xyz[ind1][1], xyz[ind1][2], xyz[ind2][0], xyz[ind2][1], xyz[ind2][2]};
                                        BondInfo binf = new BondInfo(ind1, ind2, NearestNeighbor_);
                                        binf.setCriticalDistanceSquared(rbond2);
                                        this.bonds.add(binf);
                                    }
                                }
                                ++ic2;
                            }
                            ++ic1;
                        }
                        ic1 = 0;
                        while (ic1 < centerCell.size()) {
                            int ind1 = (Integer)centerCell.get(ic1);
                            int ii1 = i1 - 1;
                            while (ii1 <= i1 + 1) {
                                int ii2 = i2 - 1;
                                while (ii2 <= i2 + 1) {
                                    int ii3 = i3 - 1;
                                    while (ii3 <= i3 + 1) {
                                        Vector vec;
                                        if (!(ii1 < 0 || ii2 < 0 || ii3 < 0 || ii1 >= this.ndiv[0] || ii2 >= this.ndiv[1] || ii3 >= this.ndiv[2] || passed[ii1][ii2][ii3] || (vec = this.cell_atom_map[ii1][ii2][ii3]) == null || ii1 == 0 && ii2 == 0 && ii3 == 0)) {
                                            int ic2 = 0;
                                            while (ic2 < vec.size()) {
                                                int ind2 = (Integer)vec.get(ic2);
                                                if (this.ignore == null || !this.ignore[ind1][ind2]) {
                                                    double rbond2 = Math.pow(this.covalentRadius[ind1] + this.covalentRadius[ind2], 2.0);
                                                    double r2 = Math.pow(this.xyz_buff[ind1][0] - this.xyz_buff[ind2][0], 2.0) + Math.pow(this.xyz_buff[ind1][1] - this.xyz_buff[ind2][1], 2.0) + Math.pow(this.xyz_buff[ind1][2] - this.xyz_buff[ind2][2], 2.0);
                                                    if (r2 < rbond2 && r2 != 0.0) {
                                                        logger.debug((Object)("ind1 & 2: " + ind1 + ", " + ind2));
                                                        logger.debug((Object)("i1, i2, and i3: " + i1 + ", " + i2 + ", " + i3));
                                                        logger.debug((Object)("ii1, ii2, and ii3: " + ii1 + ", " + ii2 + ", " + ii3));
                                                        double[] NearestNeighbor_ = new double[]{xyz[ind1][0], xyz[ind1][1], xyz[ind1][2], xyz[ind2][0], xyz[ind2][1], xyz[ind2][2]};
                                                        BondInfo binf = new BondInfo(ind1, ind2, NearestNeighbor_);
                                                        binf.setCriticalDistanceSquared(rbond2);
                                                        this.bonds.addElement(binf);
                                                    }
                                                }
                                                ++ic2;
                                            }
                                        }
                                        ++ii3;
                                    }
                                    ++ii2;
                                }
                                ++ii1;
                            }
                            ++ic1;
                        }
                    }
                    ++i3;
                }
                ++i2;
            }
            ++i1;
        }
        logger.debug((Object)("num. bonds: " + this.bonds.size()));
    }
}

