/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements.atom;

import ciss.phase_viewer.acviewer.BaseJ3DPanel;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.CylinderCreator;
import ciss.phase_viewer.acviewer.mouselistener.MouseMotionListenerAction;
import ciss.phase_viewer.acviewer.scenegraphelements.CapableText2D;
import ciss.phase_viewer.acviewer.scenegraphelements.CylinderCreatorTG;
import ciss.phase_viewer.acviewer.scenegraphelements.DynamicallyEditableTG;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.Atom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomBufferBranchGroup;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.Circle;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.ElementInfo;
import ciss.phase_viewer.common.VectorOperations;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.Format;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class AtomObject
extends DynamicallyEditableTG {
    private static Logger logger = Logger.getLogger((String)AtomObject.class.getName());
    private int mobile;
    private int weight;
    private int atomicNumber;
    private String ID;
    private double[] dp;
    private double[] force;
    private Vector3d pos;
    private Vector3d pos_buff;
    private Vector3d vforce;
    private Transform3D translate = new Transform3D();
    private int labelOffset = 0;
    private float mobilityFactor = 1.0f;
    private float[] color = new float[3];
    private float scaleatom = 1.0f;
    private float radius = 1.0f;
    private int numNodes = 20;
    private Canvas3D canvas;
    private Atom atom;
    private boolean selected = false;
    private Circle circle;
    private BranchGroup forceArrow;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    private JPopupMenu popup = new JPopupMenu();
    private JLabel menuItem = new JLabel();
    private JLabel menuDist = new JLabel();
    private Format format = ConstParameters.formater_smaller_digits;
    private String elementName;
    private boolean drawArrow = false;
    private boolean drawValue = false;
    private double arrowScale = 1.0;
    private double arrowRadius = 0.005;
    private float arrowHeadRadius = 0.02f;
    private float arrowHeadHeight = 0.04f;
    float[] color_wk = new float[]{0.2f, 0.2f, 0.5f};
    private CylinderCreatorTG arrowCreator;
    private final DecimalFormat df = new DecimalFormat("#.###");
    private BranchGroup labelBranch;

    public AtomObject(String ID, int atomicNumber, double[] dp, int mobile, int weight) {
        this.ID = ID;
        this.atomicNumber = atomicNumber;
        this.mobile = mobile;
        this.weight = weight;
        this.dp = dp;
        this.pos = new Vector3d(dp);
        this.pos_buff = new Vector3d(this.pos);
        this.translate.set(this.pos);
        this.translate.setScale(1.0);
        this.setTransform(this.translate);
        this.setCapability(3);
        this.setCapability(4);
    }

    public AtomObject(String ID, int atomicNumber, double[] dp, double[] force, int mobile, int weight) {
        this.ID = ID;
        this.atomicNumber = atomicNumber;
        this.mobile = mobile;
        this.weight = weight;
        this.dp = dp;
        this.force = force;
        this.pos = new Vector3d(dp);
        this.pos_buff = new Vector3d(this.pos);
        this.vforce = new Vector3d(force);
        this.translate.set(this.pos);
        this.translate.setScale(1.0);
        this.setTransform(this.translate);
        this.setCapability(3);
        this.setCapability(4);
    }

    public void showPopup(int canvx, int canvy, double scale) {
        TransformGroup tg = this.getTransformBuffer();
        if (tg == null) {
            return;
        }
        Point loc = this.getLocationOnScreen(canvx, canvy, scale, tg);
        double[] cds = this.getCoordinatesInRealWorld(tg);
        this.menuItem.setText("atom No. " + this.ID + ", " + this.elementName + ", x: " + this.format.format(String.valueOf(cds[0])) + ", y: " + this.format.format(String.valueOf(cds[1])) + " z: " + this.format.format(String.valueOf(cds[2])));
        double[] origPos = this.getCoordinatesInRealWorld(this);
        double[] diff = new double[]{cds[0] - origPos[0], cds[1] - origPos[1], cds[2] - origPos[2]};
        String ori = this.format.format(String.valueOf(VectorOperations.norm(diff)));
        this.menuDist.setText("distance from original position: " + ori);
        this.popup.setLocation(loc.x, loc.y);
        if (!this.popup.isVisible()) {
            this.popup.setVisible(true);
        }
    }

    public Point getLocationOnScreen(int canvx, int canvy, double scale, TransformGroup atomTransform) {
        if (atomTransform == null) {
            return new Point(0, 0);
        }
        Transform3D tf3d = new Transform3D();
        this.parent.getTransform(tf3d);
        Transform3D atomTrans = new Transform3D();
        atomTransform.getTransform(atomTrans);
        Vector3d vec = new Vector3d();
        atomTrans.get(vec);
        Point3d atomvec = new Point3d();
        atomvec.x = vec.x;
        atomvec.y = vec.y;
        atomvec.z = vec.z;
        tf3d.transform(atomvec);
        int x = (int)((atomvec.x + scale) * (double)canvx / (2.0 * scale));
        int y = (int)((-atomvec.y + scale) * (double)canvy / (2.0 * scale));
        return new Point(x + ((BaseJ3DPanel)this.mACVD.getParent()).getLocationOnScreen().x, y + ((BaseJ3DPanel)this.mACVD.getParent()).getLocationOnScreen().y);
    }

    public void removePopup() {
        this.popup.setVisible(false);
    }

    String getAtomRenderingMethod() {
        return this.mACVD.getAtomRenderingMethod();
    }

    private BranchGroup getCopyOfAtom(float transparency, Transform3D transform) {
        Appearance app = this.createAppearance(transparency);
        Atom tmpatom = new Atom(this.radius * this.scaleatom, 1, this.numNodes, app, this);
        tmpatom.isTemp(true);
        TransformGroup group = new TransformGroup();
        group.setCapability(17);
        group.setCapability(18);
        group.setTransform(transform);
        group.addChild((Node)tmpatom);
        AtomBufferBranchGroup ret = new AtomBufferBranchGroup();
        ret.addChild((Node)group);
        ret.setTransformGroup(group);
        ret.setAtomObject(this);
        return ret;
    }

    private Appearance createAppearance(float transparency) {
        Appearance app = new Appearance();
        app.setCapability(0);
        ColoringAttributes ca = new ColoringAttributes();
        RenderingAttributes ra = new RenderingAttributes();
        ra.setIgnoreVertexColors(true);
        app.setRenderingAttributes(ra);
        Material material = new Material();
        material.setCapability(0);
        material.setDiffuseColor(new Color3f(this.color));
        material.setShininess(120.0f);
        app.setMaterial(material);
        TransparencyAttributes ta = new TransparencyAttributes(2, 0.0f);
        ta.setTransparency(transparency);
        app.setTransparencyAttributes(ta);
        return app;
    }

    private void setAttributes(boolean calscale) {
        int[] foo;
        if (this.mACVD.getText()) {
            this.setLabelOffset(this.mACVD.getLabelOffset());
        }
        if ((foo = TGAtom.getMobileAndWeight(this.mCD.getAuxils(), Integer.parseInt(this.ID) - 1)) != null && foo.length >= 1) {
            this.setMobile(String.valueOf(foo[0]));
        }
        if (this.mACVD.getMobile()) {
            this.setMobilityDisplayMode(this.mACVD.getMobilityDisplayMode());
        }
        if (calscale) {
            this.scaleatom = this.mCD.getScaleAtom();
        }
        if (this.atomicNumber < 0) {
            this.atomicNumber = 1;
        }
        this.setColor(this.mACVD.getColor()[this.atomicNumber]);
        this.setRad(this.mACVD.getRad()[this.atomicNumber]);
        this.setNumNodes(this.mACVD.getNumNodesAtom());
    }

    public void setAttributes() {
        this.setAttributes(true);
    }

    @Override
    public void configDataUpdate() {
        logger.debug((Object)"at configdata update");
        double lenmax = this.parent.getLenMax();
        double[] jusin = this.parent.getCOM();
        if (Integer.parseInt(this.ID) > this.mCD.getNumAt()) {
            return;
        }
        double[] pos_moto = this.mCD.getPos(Integer.parseInt(this.ID) - 1);
        int atnumNow = this.mCD.getAtomicNumber(Integer.parseInt(this.ID) - 1);
        logger.debug((Object)("atom no. " + this.ID + " is updating."));
        int i = 0;
        while (i < 3) {
            this.dp[i] = (pos_moto[i] - jusin[i]) / lenmax;
            ++i;
        }
        this.pos = new Vector3d(this.dp);
        if (!this.mCD.forceUpdate()) {
            if (this.forceArrow != null) {
                this.forceArrow.detach();
            }
            this.getArrowProps();
            this.force = this.mCD.getForce(Integer.parseInt(this.ID) - 1);
            if (this.force != null && this.drawArrow) {
                this.forceArrow = this.createForceArrow();
                if (this.forceArrow != null) {
                    this.addChild((Node)this.forceArrow);
                }
            }
        }
        if (this.pos.epsilonEquals((Tuple3d)this.pos_buff, 1.0E-4) && atnumNow == this.atomicNumber && !this.mCD.forceUpdate()) {
            return;
        }
        this.pos_buff = new Vector3d(this.pos);
        this.translate.set(this.pos);
        this.setTransform(this.translate);
        if (atnumNow == this.atomicNumber && !this.mCD.forceUpdate()) {
            logger.debug((Object)("updating : " + this.ID));
        } else {
            logger.debug((Object)("recreating : " + this.ID));
            this.atomicNumber = atnumNow;
            this.removeAllChildren();
            this.setAttributes();
            if (this.atomicNumber < 0) {
                return;
            }
            this.create();
            this.getArrowProps();
            if (this.force != null && this.drawArrow) {
                this.forceArrow = this.createForceArrow();
                if (this.forceArrow != null) {
                    this.addChild((Node)this.forceArrow);
                }
            }
            if (this.isSelected()) {
                this.setSelected();
            }
        }
    }

    public void setPos(Vector3d newpos) {
        double[] dnewpos = this.mCD.getPosfromVirtualWorld(newpos.x, newpos.y, newpos.z);
        AtomCoords coords = this.mCD.getAtomCoords();
        ciss.phase_viewer.atomcoord.Atom atnow = coords.getAtomList().getAtomAt(Integer.parseInt(this.ID) - 1);
        ciss.phase_viewer.atomcoord.Atom newatom = atnow.getCopy();
        newatom.setPos(dnewpos);
        coords.getAtomList().replaceAtomAt(Integer.parseInt(this.ID) - 1, newatom);
        this.mCD.setCoordsNoUpdate(coords);
    }

    private double[] getCoordinatesInRealWorld(TransformGroup trans) {
        Transform3D t3d = new Transform3D();
        trans.getTransform(t3d);
        Vector3d vec3d = new Vector3d();
        t3d.get(vec3d);
        double lenmax = this.parent.getLenMax();
        double[] jusin = this.parent.getCOM();
        double[] ret = new double[]{vec3d.x * lenmax + jusin[0], vec3d.y * lenmax + jusin[1], vec3d.z * lenmax + jusin[2]};
        return ret;
    }

    public Vector3d getCoordinatesInVirtualWorld() {
        return this.getCoordinatesInVirtualWorld(this);
    }

    public Vector3d getCoordinatesInVirtualWorld(TransformGroup trans) {
        Transform3D t3d = new Transform3D();
        trans.getTransform(t3d);
        double lenmax = this.parent.getLenMax();
        double[] jusin = this.parent.getCOM();
        double[] pos_moto = this.mCD.getPos(Integer.parseInt(this.ID) - 1);
        logger.debug((Object)("atom no. " + this.ID + " is updating."));
        int i = 0;
        while (i < 3) {
            this.dp[i] = (pos_moto[i] - jusin[i]) / lenmax;
            ++i;
        }
        this.pos = new Vector3d(this.dp);
        this.pos_buff = new Vector3d(this.pos);
        t3d.transform(this.pos);
        return this.pos;
    }

    @Override
    public void configDataUpdate(boolean foo, ConfigDataUpdateEvent e) {
        this.configDataUpdate();
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    public int getAtomicNumber() {
        return this.atomicNumber;
    }

    public void setAtomicNumber(int atomicNumber) {
        this.atomicNumber = atomicNumber;
    }

    public String getMobile() {
        return String.valueOf(this.mobile);
    }

    public void setMobile(String mobile) {
        try {
            this.mobile = Integer.parseInt(mobile);
        }
        catch (NumberFormatException nfe) {
            this.mobile = 0;
        }
    }

    public String getWeight() {
        return String.valueOf(this.weight);
    }

    public void setWeight(String weight) {
        try {
            this.weight = Integer.parseInt(weight);
        }
        catch (NumberFormatException nfe) {
            this.weight = 1;
        }
    }

    @Override
    public int getType() {
        return 0;
    }

    public Point3d getPos() {
        return new Point3d(this.dp);
    }

    public double[] getPosDouble() {
        return this.dp;
    }

    public void setPos(double[] pos) {
        this.dp = this.dp;
        this.pos = new Vector3d(this.dp);
        this.pos_buff = new Vector3d(pos);
    }

    public void setForce(double[] force) {
        this.force = force;
    }

    private void recreate() {
    }

    @Override
    public void create() {
        Appearance app = new Appearance();
        app.setCapability(0);
        app.setCapability(10);
        app.setCapability(2);
        ColoringAttributes ca = new ColoringAttributes();
        RenderingAttributes ra = new RenderingAttributes();
        ra.setIgnoreVertexColors(true);
        app.setRenderingAttributes(ra);
        Material material = new Material();
        material.setCapability(0);
        material.setDiffuseColor(new Color3f(this.color));
        material.setShininess(120.0f);
        app.setMaterial(material);
        this.atom = new Atom(this.radius * this.scaleatom, 1, this.numNodes, app, this);
        this.addChild((Node)this.atom);
        this.getArrowProps();
        if (this.force != null && this.drawArrow) {
            this.forceArrow = this.createForceArrow();
            if (this.forceArrow != null) {
                this.addChild((Node)this.forceArrow);
            }
        }
        ElementInfo info = ElementInfo.getElementInfo();
        this.elementName = info.getSymbolFromNumber(this.atomicNumber + 1);
        this.popup.setLightWeightPopupEnabled(false);
        this.popup.add(this.menuItem);
        this.popup.add(this.menuDist);
        this.popup.setInvoker((BaseJ3DPanel)this.mACVD.getParent());
    }

    private void getArrowProps() {
        try {
            this.drawArrow = new Boolean(this.gp.getProperty("arrow_draw"));
            this.drawValue = new Boolean(this.gp.getProperty("arrow_draw_value"));
            this.arrowScale = Double.parseDouble(this.gp.getProperty("arrow_scale"));
            this.arrowHeadRadius = Float.parseFloat(this.gp.getProperty("arrow_head_radius"));
            this.arrowHeadHeight = Float.parseFloat(this.gp.getProperty("arrow_head_height"));
            this.arrowRadius = Double.parseDouble(this.gp.getProperty("arrow_radius"));
            this.color_wk[0] = Float.parseFloat(this.gp.getProperty("arrow_color_r"));
            this.color_wk[1] = Float.parseFloat(this.gp.getProperty("arrow_color_g"));
            this.color_wk[2] = Float.parseFloat(this.gp.getProperty("arrow_color_b"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BranchGroup createForceArrow() {
        double len = VectorOperations.norm(new double[]{this.force[0] * this.arrowScale, this.force[1] * this.arrowScale, this.force[2] * this.arrowScale});
        float coneScale = 1.0f;
        if (len < (double)(this.radius * this.scaleatom)) {
            return null;
        }
        Point3d siten = new Point3d(0.0, 0.0, 0.0);
        Point3d syuten = new Point3d(this.force[0] * this.arrowScale, this.force[1] * this.arrowScale, this.force[2] * this.arrowScale);
        if (siten.epsilonEquals((Tuple3d)syuten, 1.0E-5)) {
            return null;
        }
        Appearance app = new Appearance();
        Material material = new Material();
        material.setDiffuseColor(new Color3f(this.color_wk));
        material.setShininess(120.0f);
        app.setMaterial(material);
        CylinderCreator cylindercreate = new CylinderCreator();
        BranchGroup bg = cylindercreate.create(siten, syuten, this.arrowRadius, this.arrowHeadRadius * coneScale, this.arrowHeadHeight * coneScale, app);
        if (this.drawValue) {
            Point3f lp3f = new Point3f(0.0f, 0.0f, 0.0f);
            CapableText2D ct = new CapableText2D(" " + this.df.format(len), this.mACVD);
            OrientedShape3D orientedShape = new OrientedShape3D(ct.getGeometry(), ct.getAppearance(), 1, lp3f);
            bg.addChild((Node)orientedShape);
        }
        return bg;
    }

    public Atom getAtom() {
        return this.atom;
    }

    public String getID() {
        return this.ID;
    }

    public int getIDint() {
        return Integer.parseInt(this.ID);
    }

    public void setID(int id) {
        this.ID = String.valueOf(id);
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    protected void setLabelOffset(int labelOffset) {
        Point3f lp3f = new Point3f(0.0f, 0.0f, 0.0f);
        this.labelOffset = labelOffset;
        Color3f color_wkl2 = this.mACVD.getFontColor();
        String offset = new String();
        int i = 0;
        while (i < labelOffset) {
            offset = String.valueOf(offset) + " ";
            ++i;
        }
        Font font = this.mACVD.getFont();
        Transform3D trans = new Transform3D();
        CapableText2D text2d = new CapableText2D(String.valueOf(offset) + this.ID, color_wkl2, font.getName(), font.getSize(), font.getStyle());
        OrientedShape3D orientedShape = new OrientedShape3D(text2d.getGeometry(), text2d.getAppearance(), 1, lp3f);
        trans.setTranslation(new Vector3d(0.0, 0.0, (double)this.radius));
        TransformGroup tg = new TransformGroup();
        tg.setTransform(trans);
        tg.addChild((Node)orientedShape);
        this.labelBranch = new BranchGroup();
        this.labelBranch.setCapability(17);
        this.labelBranch.addChild((Node)tg);
        this.addChild((Node)this.labelBranch);
    }

    protected void setMobilityDisplayMode(int mobilityDisplayMode) {
        if (this.mobile == 1) {
            if (mobilityDisplayMode == 0) {
                this.mobilityFactor = 0.6f;
            } else if (mobilityDisplayMode == 1) {
                this.mobilityFactor = 1.5f;
            }
        } else {
            this.mobilityFactor = 1.0f;
        }
    }

    protected void setScale(float scaleatom) {
        this.scaleatom = scaleatom;
    }

    protected void setColor(float[] color__) {
        logger.debug((Object)("mobile: " + this.mobile + " mobilityFactor: " + this.mobilityFactor));
        if (this.color == null) {
            this.color = new float[3];
        }
        int i = 0;
        while (i < 3) {
            this.color[i] = color__[i] * this.mobilityFactor;
            if (this.color[i] >= 1.0f) {
                this.color[i] = 1.0f;
            }
            ++i;
        }
    }

    protected void setRad(float radius) {
        this.radius = radius;
    }

    public float getRad() {
        return this.radius;
    }

    protected void setNumNodes(int numNodes) {
        this.numNodes = numNodes;
    }

    protected void setCanvas(Canvas3D canvas) {
        this.canvas = canvas;
    }

    public boolean toggleSelected() {
        boolean ret = this.selected;
        this.selected = !this.selected;
        this.doSelection();
        return !ret;
    }

    public void unSelect() {
        this.selected = false;
        this.doSelection();
    }

    public void setSelected() {
        this.selected = true;
        this.doSelection();
    }

    @Override
    public void createBuffer() {
        Transform3D t3d = new Transform3D();
        this.getTransform(t3d);
        float tr = 0.6f;
        try {
            tr = Float.parseFloat(this.gp.getProperty("transparency_of_temporary_atom"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.buffer = this.getCopyOfAtom(tr, t3d);
        int i = 0;
        while (i < this.buffer.numChildren()) {
            if (this.buffer.getChild(i) instanceof TransformGroup) {
                this.transformBuffer = (TransformGroup)this.buffer.getChild(i);
            }
            ++i;
        }
    }

    @Override
    protected void postIntermediateState(Transform3D diff, TransformGroup parent, InputEvent event) {
        if (!this.selected) {
            return;
        }
        MouseEvent me = (MouseEvent)event;
        TGAtom tgatom = (TGAtom)parent;
        double screenScale = MouseMotionListenerAction.getScreenScale(tgatom.getParentFrame());
        Point3d ptmp = MouseMotionListenerAction.getCoordsFromMousePos(tgatom.getParentFrame(), me);
        int canvSizex = tgatom.getParentFrame().getCanvas().getSize().width;
        int canvSizey = tgatom.getParentFrame().getCanvas().getSize().height;
        if (((TGAtom)parent).getSelectedAtomCount() == 1 && me.getModifiersEx() == 4224) {
            Point patom = this.getLocationOnScreen(canvSizex, canvSizey, screenScale, this.getTransformBuffer());
            logger.debug((Object)("atom: getLocationOnScreen: " + patom));
            this.showPopup(canvSizex, canvSizey, screenScale);
        }
    }

    @Override
    protected boolean intermediateStateNecessary() {
        return this.selected;
    }

    private void doSelection() {
        if (this.selected) {
            this.createBuffer();
            this.circle = new Circle(this.radius * this.scaleatom);
            this.addChild((Node)this.circle);
            this.parent.selected(this);
        } else {
            if (this.buffer != null) {
                this.buffer.detach();
            }
            int i = 0;
            while (i < this.numChildren()) {
                Node child = this.getChild(i);
                if (child instanceof Circle) {
                    this.removeChild(i);
                }
                ++i;
            }
            this.parent.deselected(this);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public BoundingSphere getTransformedBounds() {
        Transform3D translate = new Transform3D();
        this.getTransform(translate);
        Transform3D etc = new Transform3D();
        this.parent.getTransform(etc);
        etc.mul(translate);
        Bounds ret = this.getBounds();
        ret.transform(etc);
        return (BoundingSphere)ret;
    }

    @Override
    public void dynamicallyEditFinalize(TransformGroup parent) {
        if (this.selected) {
            Transform3D t3d = new Transform3D();
            this.transformBuffer.getTransform(t3d);
            Vector3d atompos = new Vector3d();
            t3d.get(atompos);
            this.setPos(atompos);
            this.removePopup();
        }
    }

    public String toString() {
        String ret = "ID: " + this.ID + ", atomic number: " + String.valueOf(this.atomicNumber) + ", pos: " + this.pos;
        return ret;
    }
}

