/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements.atom;

import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomEditor;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import java.awt.Dimension;
import org.apache.log4j.Logger;

public class ACVAtomEditor
extends AtomEditor
implements ConfigData {
    private Logger logger = Logger.getLogger((String)ACVAtomEditor.class.getName());
    private CoordsViewerInterface parent;

    public ACVAtomEditor(InputInterfaceTableColumns[] columns, Atom atom, boolean newAtom, int atomIndex, String title, Dimension dimension, int pos, CoordsViewerInterface parent) {
        super(columns, atom, newAtom, atomIndex, title, dimension);
        this.parent = parent;
        parent.getCD().register(this);
    }

    public ACVAtomEditor(InputInterfaceTableColumns[] columns, Atom atom, boolean newAtom, int atomIndex, String title, Dimension dimension, CoordsViewerInterface parent) {
        super(columns, atom, newAtom, atomIndex, title, dimension);
        this.parent = parent;
        parent.getCD().register(this);
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    @Override
    public void configDataUpdate() {
        if (this.parent.getCD().getAtomCoords().getNumAt() <= this.atomIndex) {
            return;
        }
        Atom newAtom = this.parent.getCD().getAtomCoords().getAtomList().getAtomAt(this.atomIndex);
        if (newAtom != null) {
            super.setValue(newAtom);
        }
    }

    @Override
    public void configDataUpdate(boolean bool, ConfigDataUpdateEvent e) {
        this.configDataUpdate();
    }

    @Override
    protected void post() {
        this.parent.getCD().getAtomCoords().getAtomList().setUndoCount(1);
    }

    @Override
    protected void removeSelected() {
        this.parent.getBasicOperations().removeSelectedAtoms();
        this.dispose();
    }
}

