/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.geom.Plane;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.abinitmp.MarchingCube;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

public class Isosurface
extends BranchGroup
implements ConfigData {
    private Logger logger = Logger.getLogger((String)Isosurface.class.getName());
    protected static int MC = 0;
    protected static int GINFO = 1;
    private int normalGenerator = MC;
    private int normalGenerator_buff = -1;
    private Color3f color = new Color3f(0.9f, 0.9f, 0.5f);
    private Color3f color_buff;
    private J3DPanel parentPanel;
    private VolumetricData chargeDensity;
    private float value;
    private float value_buff;
    private float transparency = 0.0f;
    private float transparency_buff = 0.0f;
    private int ID;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    private Plane[] planes;
    private boolean firstQuadrantOnly = false;
    private float[][] axisVector;
    private int cID;
    private boolean initinit = true;
    private float[] densityValue;
    private float[][] coordinates;
    private int[] ndiv;
    private MarchingCube mc;
    private Vector coordData;
    private Vector normal;
    private TGAtom tgatom;
    private Shape3D shape3D;
    private Appearance appearance;
    private PolygonAttributes polygonAttributes;
    private ColoringAttributes coloringAttributes;
    private TransparencyAttributes transparencyAttributes;
    private boolean forceCreation = false;

    public Isosurface(J3DPanel mainPanel, VolumetricData chargeDensity, Color3f color, float value, float transparency, int ID) {
        this.parentPanel = mainPanel;
        this.chargeDensity = chargeDensity;
        this.color = color;
        this.value = value;
        if (transparency >= 0.0f && transparency <= 1.0f) {
            this.transparency = transparency;
        }
        this.ID = ID;
        this.init();
    }

    public void setChargeID(int cID) {
        this.cID = cID;
    }

    public int getChargeID() {
        return this.cID;
    }

    public void setFirstQuadrantOnly(boolean firstQuadrantOnly, float[][] axisVector) {
        this.firstQuadrantOnly = firstQuadrantOnly;
        this.axisVector = axisVector;
    }

    public void setClippingPlane(Plane[] planes) {
        this.planes = planes;
    }

    public void setNormalGenerator(int normalGenerator) {
        this.normalGenerator = normalGenerator;
    }

    public int getNormalGenerator() {
        return this.normalGenerator;
    }

    public void setColor(Color3f color) {
        this.color = color;
    }

    public Color3f getColor() {
        return this.color;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public void setChargeDensity(VolumetricData chargeDensity) {
        this.chargeDensity = chargeDensity;
        this.initinit = false;
        this.init();
        this.forceCreation = true;
    }

    public void reset() {
        this.initinit = false;
        this.init();
        this.forceCreation = true;
    }

    public void setTransparency(float transparency) {
        if (transparency >= 0.0f && transparency <= 1.0f) {
            this.transparency = transparency;
            this.transparency_buff = transparency;
        }
    }

    public float getTransparency() {
        return this.transparency;
    }

    public float getValue() {
        return this.value;
    }

    public void setID(int ID) {
        this.ID = ID;
    }

    private void init() {
        this.setCapability(17);
        this.densityValue = this.chargeDensity.getDensity();
        this.ndiv = this.chargeDensity.getNumDiv();
        this.coordData = new Vector();
        this.normal = new Vector();
        this.mc = new MarchingCube();
        if (this.initinit) {
            this.shape3D = new Shape3D();
            this.shape3D.setCapability(15);
            this.shape3D.setCapability(13);
            this.appearance = new Appearance();
            this.appearance.setCapability(1);
            this.appearance.setCapability(15);
            this.appearance.setCapability(9);
            this.appearance.setCapability(11);
            this.appearance.setCapability(10);
            this.shape3D.setAppearance(this.appearance);
            this.polygonAttributes = new PolygonAttributes();
            this.polygonAttributes.setCapability(1);
            this.coloringAttributes = new ColoringAttributes();
            this.coloringAttributes.setCapability(3);
            this.transparencyAttributes = new TransparencyAttributes();
            this.transparencyAttributes.setCapability(3);
            this.transparencyAttributes.setCapability(2);
            this.transparencyAttributes.setCapability(1);
            if (this.transparency == 0.0f) {
                this.transparencyAttributes.setTransparencyMode(3);
            } else {
                this.transparencyAttributes.setTransparencyMode(2);
            }
            this.transparencyAttributes.setTransparency(this.transparency);
            this.appearance.setTransparencyAttributes(this.transparencyAttributes);
            this.addChild((Node)this.shape3D);
            if (this.parentPanel instanceof MainPanel) {
                ((CoordsViewerInterface)((Object)this.parentPanel)).getCD().register(this);
            }
        }
    }

    public void forceCreation(boolean forceCreation) {
        this.forceCreation = forceCreation;
    }

    public void createIsoSurface() {
        TransformGroup tgatom = null;
        if (this.parentPanel instanceof MainPanel) {
            tgatom = ((CoordsViewerInterface)((Object)this.parentPanel)).getScene().getTGAtom();
        }
        Material material = new Material();
        material.setDiffuseColor(this.color);
        material.setShininess(128.0f);
        this.appearance.setMaterial(material);
        this.transparencyAttributes = new TransparencyAttributes();
        this.transparencyAttributes.setCapability(3);
        this.transparencyAttributes.setCapability(2);
        this.transparencyAttributes.setCapability(1);
        if (this.transparency == 0.0f) {
            this.transparencyAttributes.setTransparencyMode(4);
        } else {
            this.transparencyAttributes.setTransparencyMode(2);
            this.transparencyAttributes.setSrcBlendFunction(2);
        }
        this.transparencyAttributes.setTransparency(this.transparency);
        this.appearance.setTransparencyAttributes(this.transparencyAttributes);
        this.polygonAttributes.setCullFace(0);
        this.appearance.setPolygonAttributes(this.polygonAttributes);
        this.logger.debug((Object)("forceCreation: " + this.forceCreation));
        if (this.value != this.value_buff || this.normalGenerator != this.normalGenerator_buff || this.forceCreation) {
            GeometryInfo ginfo;
            int i;
            this.forceCreation = false;
            this.densityValue = this.chargeDensity.getDensity();
            this.ndiv = this.chargeDensity.getNumDiv();
            double lenmax = 1.0;
            double[] jusin = new double[]{0.0, 0.0, 0.0};
            float[] fjusin = this.chargeDensity.getOrigin();
            if (tgatom instanceof TGAtom) {
                lenmax = ((TGAtom)tgatom).getLenMax();
                jusin = ((TGAtom)tgatom).getConfigData().getCellOriginVector();
                double[] cellshift = ((TGAtom)tgatom).getCellOffset();
                i = 0;
                while (i < 3) {
                    jusin[i] = -(jusin[i] + cellshift[i] * lenmax);
                    ++i;
                }
            } else if (fjusin != null) {
                jusin[0] = fjusin[0];
                jusin[1] = fjusin[1];
                jusin[2] = fjusin[2];
            }
            this.coordinates = this.chargeDensity.getCoordinates();
            int j = 0;
            while (j < 3) {
                int n = j;
                jusin[n] = jusin[n] / lenmax;
                i = 0;
                while (i < this.coordinates[j].length) {
                    float[] fArray = this.coordinates[j];
                    int n2 = i++;
                    fArray[n2] = (float)((double)fArray[n2] / lenmax);
                }
                ++j;
            }
            Point3f center = new Point3f((float)jusin[2], (float)jusin[1], (float)jusin[0]);
            this.coordData.clear();
            this.normal.clear();
            try {
                this.mc.create_isosurf(this.coordinates[2], this.coordinates[1], this.coordinates[0], this.ndiv[2], this.ndiv[1], this.ndiv[0], this.densityValue, this.value, this.coordData, this.normal, this.chargeDensity.getInterpolationScheme());
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            this.value_buff = this.value;
            if (this.coordData.size() == 0) {
                this.logger.debug((Object)"no data crosses value...");
                return;
            }
            this.logger.debug((Object)("num. vertices: " + this.coordData.size()));
            if (this.planes != null) {
                int i2 = 0;
                while (i2 < this.planes.length) {
                    this.logger.debug((Object)("plane no. " + i2));
                    this.logger.debug((Object)this.planes[i2]);
                    Point3f nor = this.planes[i2].getNormalVector();
                    this.planes[i2].setNormalVector(new Point3f(nor.z, nor.y, nor.x));
                    Point3f ori = this.planes[i2].getOrigin();
                    this.planes[i2].setOrigin(new Point3f(ori.z, ori.y, ori.x));
                    ++i2;
                }
                int numTriangles = this.coordData.size() / 3;
                this.logger.debug((Object)("clipping isosurface; num. triangles: " + numTriangles));
                Point3f genten = new Point3f();
                int i3 = numTriangles - 1;
                while (i3 >= 0) {
                    Point3f[] points = new Point3f[3];
                    Point3f point1 = (Point3f)this.coordData.get(i3 * 3);
                    Point3f point2 = (Point3f)this.coordData.get(i3 * 3 + 1);
                    Point3f point3 = (Point3f)this.coordData.get(i3 * 3 + 2);
                    point1.sub((Tuple3f)center);
                    point2.sub((Tuple3f)center);
                    point3.sub((Tuple3f)center);
                    points[0] = point1;
                    points[1] = point2;
                    points[2] = point3;
                    float[] fromgenten = new float[3];
                    int j2 = 0;
                    while (j2 < 3) {
                        fromgenten[j2] = points[j2].distance(genten);
                        ++j2;
                    }
                    int k = 0;
                    while (k < 2) {
                        int l = k + 1;
                        while (l < 3) {
                            if (fromgenten[k] > fromgenten[l]) {
                                Point3f tmp1 = points[k];
                                Point3f tmp2 = points[l];
                                float tmptmp1 = fromgenten[k];
                                float tmptmp2 = fromgenten[l];
                                points[k] = tmp2;
                                points[l] = tmp1;
                                fromgenten[k] = tmptmp2;
                                fromgenten[l] = tmptmp1;
                            }
                            ++l;
                        }
                        ++k;
                    }
                    int count1 = 0;
                    int count2 = 0;
                    int count3 = 0;
                    float nearest2 = 100000.0f;
                    float nearest3 = 100000.0f;
                    Plane nearestPlane2 = this.planes[0];
                    Plane nearestPlane3 = this.planes[0];
                    int j3 = 0;
                    while (j3 < this.planes.length) {
                        float d1 = this.planes[j3].getDistanceFrom(genten);
                        float dp1 = this.planes[j3].getDistanceFrom(points[0]);
                        float dp2 = this.planes[j3].getDistanceFrom(points[1]);
                        float dp3 = this.planes[j3].getDistanceFrom(points[2]);
                        if (Math.abs(dp2) < nearest2) {
                            nearest2 = Math.abs(dp2);
                            nearestPlane2 = this.planes[j3];
                        }
                        if (Math.abs(dp3) < nearest3) {
                            nearest3 = Math.abs(dp3);
                            nearestPlane3 = this.planes[j3];
                        }
                        if (d1 > 0.0f && dp1 > 0.0f || d1 < 0.0f && dp1 < 0.0f) {
                            ++count1;
                        }
                        if (d1 > 0.0f && dp2 > 0.0f || d1 < 0.0f && dp2 < 0.0f) {
                            ++count2;
                        }
                        if (d1 > 0.0f && dp3 > 0.0f || d1 < 0.0f && dp3 < 0.0f) {
                            ++count3;
                        }
                        ++j3;
                    }
                    float one_plane_three = Math.abs(nearestPlane3.getDistanceFrom(points[0]));
                    float two_plane_three = Math.abs(nearestPlane3.getDistanceFrom(points[1]));
                    float one_plane_two = Math.abs(nearestPlane2.getDistanceFrom(points[0]));
                    points[0].add((Tuple3f)center);
                    points[1].add((Tuple3f)center);
                    points[2].add((Tuple3f)center);
                    if (count1 != this.planes.length || count2 != this.planes.length || count3 != this.planes.length) {
                        float factor2;
                        float factor1;
                        if (count1 != this.planes.length && count2 != this.planes.length && count3 != this.planes.length) {
                            this.coordData.remove(i3 * 3 + 2);
                            this.coordData.remove(i3 * 3 + 1);
                            this.coordData.remove(i3 * 3);
                            this.normal.remove(i3 * 3 + 2);
                            this.normal.remove(i3 * 3 + 1);
                            this.normal.remove(i3 * 3);
                        } else if (count1 == this.planes.length && count2 == this.planes.length && count3 != this.planes.length) {
                            factor1 = one_plane_three / (nearest3 + one_plane_three);
                            factor2 = two_plane_three / (nearest3 + two_plane_three);
                            Point3f newpoint1 = new Point3f(points[0]);
                            Point3f tmp1 = new Point3f(points[2]);
                            tmp1.sub((Tuple3f)points[0]);
                            tmp1.scale(factor1);
                            newpoint1.add((Tuple3f)tmp1);
                            Point3f newpoint2 = new Point3f(points[1]);
                            Point3f tmp2 = new Point3f(points[2]);
                            tmp2.sub((Tuple3f)points[1]);
                            tmp2.scale(factor2);
                            newpoint2.add((Tuple3f)tmp2);
                            points[2].sub((Tuple3f)points[1]);
                            points[2].scale(factor2);
                            points[2].add((Tuple3f)points[1]);
                            this.coordData.add(i3 * 3 + 3, points[0]);
                            this.coordData.add(i3 * 3 + 4, newpoint1);
                            this.coordData.add(i3 * 3 + 5, points[2]);
                            Vector3f v1 = (Vector3f)this.normal.get(i3 * 3);
                            Vector3f v2 = (Vector3f)this.normal.get(i3 * 3 + 1);
                            Vector3f v3 = (Vector3f)this.normal.get(i3 * 3 + 2);
                            this.normal.add(i3 * 3 + 3, v1);
                            this.normal.add(i3 * 3 + 4, v2);
                            this.normal.add(i3 * 3 + 5, v3);
                        } else if (count1 == this.planes.length && count2 != this.planes.length && count3 != this.planes.length) {
                            factor1 = one_plane_two / (nearest2 + one_plane_two);
                            factor2 = one_plane_three / (nearest3 + one_plane_three);
                            points[1].sub((Tuple3f)points[0]);
                            points[1].scale(factor1);
                            points[1].add((Tuple3f)points[0]);
                            points[2].sub((Tuple3f)points[0]);
                            points[2].scale(factor2);
                            points[2].add((Tuple3f)points[0]);
                        } else {
                            this.coordData.remove(i3 * 3 + 2);
                            this.coordData.remove(i3 * 3 + 1);
                            this.coordData.remove(i3 * 3);
                            this.normal.remove(i3 * 3 + 2);
                            this.normal.remove(i3 * 3 + 1);
                            this.normal.remove(i3 * 3);
                        }
                    }
                    --i3;
                }
                i3 = 0;
                while (i3 < this.planes.length) {
                    Point3f nor = this.planes[i3].getNormalVector();
                    this.planes[i3].setNormalVector(new Point3f(nor.z, nor.y, nor.x));
                    Point3f ori = this.planes[i3].getOrigin();
                    this.planes[i3].setOrigin(new Point3f(ori.z, ori.y, ori.x));
                    ++i3;
                }
            }
            Point3f[] vertices = new Point3f[this.coordData.size()];
            Vector3f[] normals = new Vector3f[this.normal.size()];
            int j4 = 0;
            while (j4 < this.coordData.size()) {
                Point3f tmp = (Point3f)this.coordData.get(j4);
                vertices[j4] = new Point3f(tmp.z - center.z, tmp.y - center.y, tmp.x - center.x);
                ++j4;
            }
            j4 = 0;
            while (j4 < normals.length) {
                Vector3f tmpn;
                normals[j4] = tmpn = (Vector3f)this.normal.get(j4);
                normals[j4] = new Vector3f(tmpn.z, tmpn.y, tmpn.x);
                ++j4;
            }
            boolean foo = true;
            try {
                foo = new Boolean(this.gp.getProperty("isosurface_normal_generation").equals("j3d"));
            }
            catch (Exception tmpn) {
                // empty catch block
            }
            Object bg = null;
            if (this.normalGenerator == MC) {
                ginfo = new GeometryInfo(1);
                ginfo.setCoordinates(vertices);
                ginfo.setNormals(normals);
                ginfo.recomputeIndices();
                Stripifier st = new Stripifier();
                st.stripify(ginfo);
                GeometryArray ara = ginfo.getGeometryArray();
                this.shape3D.setGeometry((Geometry)ara);
            } else if (this.normalGenerator == GINFO) {
                try {
                    ginfo = new GeometryInfo(1);
                    ginfo.setCoordinates(vertices);
                    ginfo.recomputeIndices();
                    NormalGenerator gen = new NormalGenerator();
                    gen.setCreaseAngle(Math.PI);
                    gen.generateNormals(ginfo);
                    Stripifier st = new Stripifier();
                    st.stripify(ginfo);
                    this.shape3D.setGeometry((Geometry)ginfo.getGeometryArray());
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
            this.normalGenerator_buff = this.normalGenerator;
        }
    }

    public String toString() {
        return "no. " + String.valueOf(this.ID) + ", value: " + String.valueOf(this.value);
    }

    @Override
    public void configDataUpdate() {
    }

    @Override
    public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
        if (e.getType() == ConfigDataUpdateEvent.CELL_CHANGED) {
            this.detach();
            this.reset();
            this.createIsoSurface();
            this.parentPanel.getRootTransform().addChild((Node)this);
        }
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }
}

