/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.operations;

import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.VolumetricData;
import java.util.Vector;
import org.apache.log4j.Logger;

public class EnlargeCell {
    private Logger logger = Logger.getLogger((String)EnlargeCell.class.getName());
    private Vector origCell = new Vector();
    private Vector origAtoms = new Vector();
    private int na = 1;
    private int nb = 1;
    private int nc = 1;
    private boolean doallframes = false;
    private Vector frames;
    private MainPanel parent;

    public EnlargeCell(Vector frames, MainPanel parent) {
        this.frames = frames;
        this.parent = parent;
        this.createOrig();
    }

    public void setDoAllFrames(boolean doallframes) {
        this.doallframes = doallframes;
    }

    public void setEnlargeParams(int na, int nb, int nc) {
        this.na = na;
        this.nb = nb;
        this.nc = nc;
    }

    public void doEnlarge() {
        this.doEnlarge(this.na, this.nb, this.nc);
    }

    public void doEnlarge(int na, int nb, int nc) {
        ConfigDataManager mCD = this.parent.getCD();
        int start = 0;
        int end2 = this.origAtoms.size();
        int currentFrame = mCD.getFrameNum();
        if (!this.doallframes) {
            start = currentFrame;
            end2 = start + 1;
        }
        int orignumat = this.parent.getCD().getNumAt();
        this.parent.getCD().getAtomCoords().saveState();
        double[] com = new double[3];
        Vector sublatatoms = new Vector();
        int ii = start;
        while (ii < end2) {
            this.logger.debug((Object)("doing 'enlarge' for frame no.: " + ii));
            double[][] dCell = new double[3][3];
            double[][] baseAtom = new double[3][3];
            Cell originalCell = (Cell)this.origCell.get(ii);
            Atom[] originalAtoms = (Atom[])this.origAtoms.get(ii);
            double[][] dcell = originalCell.getDouble();
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 3) {
                    dCell[i][j] = dcell[i][j];
                    ++j;
                }
                ++i;
            }
            if (originalAtoms == null) {
                this.logger.error((Object)"no atoms allocated.");
                return;
            }
            AtomCoords coords = (AtomCoords)this.frames.get(ii);
            AtomList atomList = coords.getAtomList();
            int orgnumat = atomList.size();
            int i2 = orgnumat - 1;
            while (i2 >= 0) {
                atomList.removeAtomAt(i2);
                --i2;
            }
            int newAtomCount = 0;
            double celloffsetx = (double)(na - 1) * dCell[0][0] * 0.5 + (double)(nb - 1) * dCell[1][0] * 0.5 + (double)(nc - 1) * dCell[2][0] * 0.5;
            double celloffsety = (double)(na - 1) * dCell[0][1] * 0.5 + (double)(nb - 1) * dCell[1][1] * 0.5 + (double)(nc - 1) * dCell[2][1] * 0.5;
            double celloffsetz = (double)(na - 1) * dCell[0][2] * 0.5 + (double)(nb - 1) * dCell[1][2] * 0.5 + (double)(nc - 1) * dCell[2][2] * 0.5;
            int iat = 0;
            while (iat < originalAtoms.length) {
                double[] origpos = originalAtoms[iat].getDouble();
                Atom newAtom = originalAtoms[iat].getCopy();
                newAtom.setPos(new double[]{origpos[0] - celloffsetx, origpos[1] - celloffsety, origpos[2] - celloffsetz});
                ++newAtomCount;
                atomList.addAtom(newAtom, true);
                ++iat;
            }
            int ia = 0;
            while (ia < na) {
                int ib = 0;
                while (ib < nb) {
                    int ic = 0;
                    while (ic < nc) {
                        if (ia != 0 || ib != 0 || ic != 0) {
                            int iat2 = 0;
                            while (iat2 < originalAtoms.length) {
                                double[] origpos = originalAtoms[iat2].getDouble();
                                double xtmp = origpos[0] + (double)ia * dCell[0][0] + (double)ib * dCell[1][0] + (double)ic * dCell[2][0] - celloffsetx;
                                double ytmp = origpos[1] + (double)ia * dCell[0][1] + (double)ib * dCell[1][1] + (double)ic * dCell[2][1] - celloffsety;
                                double ztmp = origpos[2] + (double)ia * dCell[0][2] + (double)ib * dCell[1][2] + (double)ic * dCell[2][2] - celloffsetz;
                                Atom newAtom = originalAtoms[iat2].getCopy();
                                newAtom.setPos(new double[]{xtmp, ytmp, ztmp});
                                ++newAtomCount;
                                atomList.addAtom(newAtom, true);
                                ++iat2;
                            }
                        }
                        ++ic;
                    }
                    ++ib;
                }
                ++ia;
            }
            double[][] newCell = new double[3][3];
            int i3 = 0;
            while (i3 < 3) {
                newCell[0][i3] = (double)na * dCell[0][i3];
                newCell[1][i3] = (double)nb * dCell[1][i3];
                newCell[2][i3] = (double)nc * dCell[2][i3];
                ++i3;
            }
            this.logger.debug((Object)("newcell: " + newCell[0][0] + ", " + newCell[0][1] + ", " + newCell[0][2]));
            this.logger.debug((Object)("newcell: " + newCell[1][0] + ", " + newCell[1][1] + ", " + newCell[1][2]));
            this.logger.debug((Object)("newcell: " + newCell[2][0] + ", " + newCell[2][1] + ", " + newCell[2][2]));
            Cell newcell = new Cell(newCell[0], newCell[1], newCell[2]);
            newcell.setCellOffset(new double[]{celloffsetx, celloffsety, celloffsetz});
            coords.setCell(newcell);
            VolumetricData[] cden = coords.getChargeDensities();
            if (cden != null) {
                int i4 = 0;
                while (i4 < cden.length) {
                    cden[i4].enlarge(na, nb, nc);
                    ++i4;
                }
            }
            atomList.setUndoCount(orgnumat + newAtomCount + 1);
            ++ii;
        }
        try {
            AtomList list = this.parent.getCD().getAtomCoords().getAtomList();
            this.logger.debug((Object)("size: " + list.size()));
            this.logger.debug((Object)("new COM: " + com[0] + ", " + com[1] + ", " + com[2]));
            this.parent.getCD().isRenderingManual(true);
            this.parent.prepareRedraw();
            int[] sele = ((TGAtom)this.parent.getRootTransform()).getSelectedAtomsIndex();
            ((TGAtom)this.parent.getRootTransform()).deselectAll();
            this.parent.getCD().setCoords((AtomCoords)this.frames.get(currentFrame), ConfigDataUpdateEvent.CELL_CHANGED);
            AtomObject[] objs = ((TGAtom)this.parent.getRootTransform()).getAtomObjects();
            if (sele != null && objs != null) {
                int i = 0;
                while (i < sele.length) {
                    if (sele[i] < objs.length) {
                        objs[sele[i]].setSelected();
                    }
                    ++i;
                }
            }
            this.parent.doUnitCell(true);
            this.parent.postRedraw();
            this.parent.getCD().isRenderingManual(false);
            this.parent.getCD().getAtomCoords().finalizeState();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public void recreateOrig() {
        ConfigDataManager mCD = this.parent.getCD();
        AtomCoords coords = this.parent.getCD().getAtomCoords();
        AtomList atomList = coords.getAtomList();
        int numOrgAt = atomList.size();
        Vector<Atom> tmpvec = new Vector<Atom>();
        int i = 0;
        while (i < numOrgAt) {
            Atom tmp = atomList.getAtomAt(i);
            if (!tmp.isBoundaryAtom()) {
                Atom buf = tmp.getCopy();
                tmpvec.add(buf);
            }
            ++i;
        }
        if (tmpvec.size() == 0) {
            return;
        }
        Object[] oatoms = new Atom[tmpvec.size()];
        tmpvec.copyInto(oatoms);
        Cell ocell = coords.getCell(0);
        this.origAtoms.set(mCD.getFrameNum(), oatoms);
        this.origCell.set(mCD.getFrameNum(), ocell);
    }

    private void createOrig() {
        int i = 0;
        while (i < this.frames.size()) {
            AtomCoords coords = (AtomCoords)this.frames.get(i);
            AtomList atomList = coords.getAtomList();
            int numOrgAt = atomList.size();
            Vector<Atom> tmpvec = new Vector<Atom>();
            int j = 0;
            while (j < numOrgAt) {
                Atom tmp = atomList.getAtomAt(j);
                if (!tmp.isBoundaryAtom()) {
                    Atom buf = tmp.getCopy();
                    tmpvec.addElement(buf);
                }
                ++j;
            }
            if (tmpvec.size() == 0) {
                return;
            }
            Object[] originalAtoms = new Atom[tmpvec.size()];
            tmpvec.copyInto(originalAtoms);
            Cell originalCell = coords.getCell(0);
            this.origAtoms.addElement(originalAtoms);
            this.origCell.addElement(originalCell);
            ++i;
        }
    }
}

