/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.mouselistener;

import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.mouselistener.MouseMotionListenerAction;
import ciss.phase_viewer.acviewer.scenegraphelements.DynamicallyEditable;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObjectBG;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomSphere;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class RightClickAction
extends MouseMotionListenerAction {
    private Logger logger = Logger.getLogger((String)RightClickAction.class.getName());
    private double x_last = 0.0;
    private double y_last = 0.0;
    private Transform3D buffer;
    private PickCanvas pickTool;
    private boolean moveAtoms = false;
    private boolean inAction = false;

    public RightClickAction(MainPanel parent) {
        super(parent);
        this.pickTool = new PickCanvas(parent.getCanvas(), parent.getRootBranch());
        this.pickTool.setMode(256);
    }

    @Override
    void init(MouseEvent e) {
        if (this.inAction) {
            return;
        }
        this.x_last = 0.0;
        this.y_last = 0.0;
        this.buffer = new Transform3D();
        this.pickTool.setShapeLocation(e);
        PickResult[] result = this.pickTool.pickAllSorted();
        boolean tmp = false;
        if (result != null) {
            int i = 0;
            while (i < result.length) {
                AtomSphere atom;
                Primitive pri = (Primitive)result[i].getNode(4);
                if (pri != null && pri instanceof AtomSphere && (atom = (AtomSphere)pri).getAtomObject().isSelected()) {
                    tmp = true;
                    break;
                }
                ++i;
            }
        }
        this.moveAtoms = tmp;
        if (this.moveAtoms) {
            BranchGroup root = this.parent.getRootBranch();
            Enumeration enu = root.getAllChildren();
            while (enu.hasMoreElements()) {
                Object object = enu.nextElement();
                if (!(object instanceof MouseTranslate)) continue;
                ((Behavior)object).setEnable(false);
            }
        }
        this.inAction = true;
    }

    @Override
    void finalize(MouseEvent e) {
        this.inAction = false;
        TGAtom tgatom = (TGAtom)this.parent.getScene().getTGAtom();
        int selected = tgatom.getSelectedAtomCount();
        if (selected == 0) {
            return;
        }
        if (!this.moveAtoms) {
            return;
        }
        DynamicallyEditable[] editable = tgatom.getDynamicallyEditableElements();
        boolean update = false;
        Vector aobjVector = new Vector();
        Vector<BranchGroup> buffervec = new Vector<BranchGroup>();
        int i = 0;
        while (i < editable.length) {
            editable[i].dynamicallyEditFinalize(tgatom);
            buffervec.addElement(editable[i].getBuffer());
            ++i;
        }
        this.parent.getCD().getAtomCoords().getAtomList().setUndoCount(selected);
        this.parent.getCD().update();
        i = 0;
        while (i < buffervec.size()) {
            if (buffervec.elementAt(i) != null) {
                ((BranchGroup)buffervec.elementAt(i)).detach();
            }
            ++i;
        }
        i = 0;
        while (i < buffervec.size()) {
            if (buffervec.elementAt(i) instanceof AtomObjectBG) {
                ((AtomObjectBG)((Object)buffervec.elementAt(i))).getAssociatedAtomObject().createBuffer();
            }
            ++i;
        }
        this.x_last = 0.0;
        this.y_last = 0.0;
        this.buffer = new Transform3D();
        BranchGroup root = this.parent.getRootBranch();
        Enumeration enu = root.getAllChildren();
        while (enu.hasMoreElements()) {
            Object object = enu.nextElement();
            if (!(object instanceof MouseTranslate)) continue;
            ((Behavior)object).setEnable(true);
        }
    }

    @Override
    void processMouseDrag(MouseEvent e) {
        if (!this.moveAtoms) {
            this.logger.debug((Object)"moveAtoms=false");
            return;
        }
        this.logger.debug((Object)this);
        this.logger.debug((Object)(" modifiersex: " + MouseEvent.getModifiersExText(e.getModifiersEx())));
        Point3d ptmp = RightClickAction.getCoordsFromMousePos(this.parent, e);
        double x = ptmp.x;
        double y = ptmp.y;
        if (this.x_last == 0.0 && this.y_last == 0.0) {
            this.x_last = x;
            this.y_last = y;
            return;
        }
        Transform3D tgatom3d = new Transform3D();
        this.parent.getScene().getTGAtom().getTransform(tgatom3d);
        if (!tgatom3d.equals(this.buffer)) {
            this.buffer = new Transform3D(tgatom3d);
            this.x_last = x;
            this.y_last = y;
            return;
        }
        double dx = x - this.x_last;
        double dy = y - this.y_last;
        TGAtom tgatom = (TGAtom)this.parent.getScene().getTGAtom();
        Vector3d translation = new Vector3d();
        translation.x = dx;
        translation.y = -dy;
        Matrix3d rotation = new Matrix3d();
        Transform3D transform3d = new Transform3D(rotation, translation, 1.0);
        DynamicallyEditable[] editables = tgatom.getDynamicallyEditableElements();
        if (editables == null || editables.length == 0) {
            this.logger.debug((Object)"no editable tg");
            return;
        }
        int i = 0;
        while (i < editables.length) {
            editables[i].dynamicallyEditIntermediateState(transform3d, tgatom, e);
            ++i;
        }
        this.x_last = x;
        this.y_last = y;
        this.logger.debug((Object)("x_last, y_last: " + this.x_last + ", " + this.y_last));
    }

    @Override
    void processMouseMove(MouseEvent e) {
    }

    public String toString() {
        return "right click action!";
    }
}

