/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.mouselistener;

import com.sun.j3d.utils.behaviors.mouse.MouseBehavior;
import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class MyMouseRotate
extends MouseBehavior {
    private Logger logger = Logger.getLogger((String)MyMouseRotate.class.getName());
    private MouseBehaviorCallback callback = null;
    double x_angle;
    double y_angle;
    double x_factor = 0.03;
    double y_factor = 0.03;
    private boolean firstBoot = true;
    private Vector3d trans = new Vector3d(0.0, 0.0, 0.0);

    public MyMouseRotate(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public MyMouseRotate() {
        super(0);
    }

    public MyMouseRotate(int flags) {
        super(flags);
    }

    public MyMouseRotate(Component c) {
        super(c, 0);
    }

    public MyMouseRotate(Component c, TransformGroup transformGroup) {
        super(c, transformGroup);
    }

    public MyMouseRotate(Component c, int flags) {
        super(c, flags);
    }

    public void initialize() {
        super.initialize();
        this.x_angle = 0.0;
        this.y_angle = 0.0;
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.x_factor *= -1.0;
            this.y_factor *= -1.0;
        }
    }

    public double getXFactor() {
        return this.x_factor;
    }

    public double getYFactor() {
        return this.y_factor;
    }

    public void setFactor(double factor) {
        this.x_factor = this.y_factor = factor;
    }

    public void setFactor(double xFactor, double yFactor) {
        this.x_factor = xFactor;
        this.y_factor = yFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStimulus(Enumeration criteria) {
        block3: while (criteria.hasMoreElements()) {
            MouseEvent evt;
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent) {
                AWTEvent[] events = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                if (events.length <= 0) continue;
                evt = (MouseEvent)events[events.length - 1];
                this.doProcess(evt);
                continue;
            }
            if (!(wakeup instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseq;
                synchronized (linkedList) {
                    if (this.mouseq.isEmpty()) {
                        continue block3;
                    }
                    evt = (MouseEvent)this.mouseq.remove(0);
                    while (evt.getID() == 506 && !this.mouseq.isEmpty() && ((MouseEvent)this.mouseq.get(0)).getID() == 506) {
                        evt = (MouseEvent)this.mouseq.remove(0);
                    }
                }
                this.doProcess(evt);
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    public void setTranslation(Vector3d trans) {
        this.trans = trans;
    }

    void doProcess(MouseEvent evt) {
        if (this.x_last == 0 && this.y_last == 0) {
            this.x_last = evt.getX();
            this.y_last = evt.getY();
            if (this.firstBoot) {
                this.firstBoot = false;
            } else {
                return;
            }
        }
        this.processMouseEvent(evt);
        if (this.buttonPress && (this.flags & 1) == 0 || this.wakeUp && (this.flags & 1) != 0) {
            int id = evt.getID();
            if (id == 506 && !evt.isMetaDown() && !evt.isAltDown()) {
                this.x = evt.getX();
                this.y = evt.getY();
                int dx = this.x - this.x_last;
                int dy = this.y - this.y_last;
                if (!this.reset) {
                    this.x_angle = (double)dy * this.y_factor;
                    this.y_angle = (double)dx * this.x_factor;
                    Transform3D t3d = new Transform3D();
                    t3d.setTranslation(this.trans);
                    this.transformX.rotX(this.x_angle);
                    this.transformY.rotY(this.y_angle);
                    this.transformGroup.getTransform(this.currXform);
                    Matrix4d mat = new Matrix4d();
                    this.currXform.get(mat);
                    this.transformGroup.setTransform(t3d);
                    this.currXform.setTranslation(this.trans);
                    if (this.invert) {
                        this.currXform.mul(this.currXform, this.transformX);
                        this.currXform.mul(this.currXform, this.transformY);
                    } else {
                        this.currXform.mul(this.transformX, this.currXform);
                        this.currXform.mul(this.transformY, this.currXform);
                    }
                    Vector3d translation = new Vector3d(mat.m03, mat.m13, mat.m23);
                    this.logger.debug((Object)("translation: " + this.trans + "," + translation));
                    this.currXform.setTranslation(translation);
                    this.transformGroup.setTransform(this.currXform);
                    this.transformChanged(this.currXform);
                    if (this.callback != null) {
                        this.callback.transformChanged(0, this.currXform);
                    }
                } else {
                    this.reset = false;
                }
                this.x_last = this.x;
                this.y_last = this.y;
            } else if (id == 501) {
                this.x_last = evt.getX();
                this.y_last = evt.getY();
            }
        }
    }

    public void transformChanged(Transform3D transform) {
    }

    public void setupCallback(MouseBehaviorCallback callback) {
        this.callback = callback;
    }

    public void init() {
        this.x_last = 0;
        this.y_last = 0;
    }
}

