/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.geom;

import ciss.phase_viewer.acviewer.geom.AngComp;
import ciss.phase_viewer.common.VectorOperations;
import java.util.Arrays;
import java.util.Vector;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3f;
import org.apache.log4j.Logger;

public class Sorter {
    private static Logger logger = Logger.getLogger((String)Sorter.class.getName());

    private Sorter() {
    }

    public static Point3f[] radiallyClockWise(Point3f[] data) {
        if (data == null) {
            return null;
        }
        Vector<float[]> vec = new Vector<float[]>();
        int i = 0;
        while (i < data.length) {
            float[] fld = new float[]{data[i].x, data[i].y, data[i].z};
            vec.addElement(fld);
            ++i;
        }
        Vector retvec = Sorter.radiallyClockWise(vec, null);
        float[][] fret = new float[retvec.size()][];
        retvec.copyInto((Object[])fret);
        Point3f[] pret = new Point3f[fret.length];
        int i2 = 0;
        while (i2 < fret.length) {
            pret[i2] = new Point3f(fret[i2]);
            ++i2;
        }
        return pret;
    }

    public static Vector radiallyClockWise(Vector data, Vector associatedData) {
        return Sorter.radiallyClockWise(data, associatedData, false);
    }

    public static Vector radiallyClockWise(Vector data, Vector associatedData, boolean counterClockWise) {
        float verySmall = 1.0E-6f;
        float small = 0.001f;
        if (data == null || data.size() <= 2) {
            return null;
        }
        Object[] fdata = new Object[data.size()];
        data.copyInto(fdata);
        float[] f0 = (float[])fdata[0];
        int dim = f0.length;
        Object[] assobj = null;
        if (associatedData != null && associatedData.size() != 0) {
            assobj = new Object[associatedData.size()];
            associatedData.copyInto(assobj);
        }
        float[][] buff = new float[data.size()][f0.length];
        int i = 0;
        while (i < buff.length) {
            int j = 0;
            while (j < dim) {
                buff[i][j] = 0.0f;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < data.size()) {
            float[] fld = (float[])data.get(i);
            int j = 0;
            while (j < dim) {
                buff[i][j] = fld[j];
                ++j;
            }
            ++i;
        }
        int ind1 = 0;
        int ind2 = 1;
        boolean xissame = true;
        boolean yissame = true;
        boolean zissame = true;
        int i2 = 0;
        while (i2 < fdata.length - 1) {
            float[] flidat = (float[])fdata[i2];
            int j = i2 + 1;
            while (j < fdata.length) {
                float[] fljdat = (float[])fdata[j];
                int k = 0;
                while (k < fljdat.length) {
                    if (Math.abs(flidat[0] - fljdat[0]) > verySmall) {
                        xissame = false;
                    }
                    if (Math.abs(flidat[1] - fljdat[1]) > verySmall) {
                        yissame = false;
                    }
                    if (Math.abs(flidat[2] - fljdat[2]) > verySmall) {
                        zissame = false;
                    }
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        float[] f1 = (float[])fdata[1];
        float[] nor = VectorOperations.getNormalVector(f0, f1);
        Transform3D t3d = new Transform3D();
        t3d.rotX(0.5235987755982988);
        t3d.rotY(0.5235987755982988);
        int i3 = 0;
        while (i3 < buff.length) {
            Point3f p = new Point3f(buff[i3][0], buff[i3][1], buff[i3][2]);
            Point3f out = new Point3f();
            t3d.transform(p, out);
            buff[i3][0] = out.x;
            buff[i3][1] = out.y;
            buff[i3][2] = out.z;
            ++i3;
        }
        if (xissame) {
            ind1 = 1;
            ind2 = 2;
        }
        if (yissame) {
            ind1 = 0;
            ind2 = 2;
        }
        float[] origin = new float[dim];
        int i4 = 0;
        while (i4 < dim) {
            origin[i4] = 0.0f;
            ++i4;
        }
        i4 = 0;
        while (i4 < buff.length) {
            int j = 0;
            while (j < dim) {
                int n = j;
                origin[n] = origin[n] + buff[i4][j];
                ++j;
            }
            ++i4;
        }
        i4 = 0;
        while (i4 < dim) {
            int n = i4++;
            origin[n] = origin[n] / (float)data.size();
        }
        float[] ref = new float[dim];
        int i5 = 0;
        while (i5 < ref.length) {
            ref[i5] = buff[0][i5] - origin[i5];
            ++i5;
        }
        float norm0 = VectorOperations.norm(ref);
        if (norm0 == 0.0f) {
            int i6 = 0;
            while (i6 < ref.length) {
                int n = i6++;
                ref[n] = ref[n] + verySmall;
            }
            norm0 = VectorOperations.norm(ref);
        }
        Object[] comp = new AngComp[data.size()];
        Object obj = null;
        if (assobj != null) {
            obj = assobj[0];
        }
        comp[0] = new AngComp(f0, obj, 0.0f, counterClockWise);
        int i7 = 1;
        while (i7 < buff.length) {
            float cosine;
            float[] refi = new float[dim];
            int j = 0;
            while (j < dim) {
                refi[j] = buff[i7][j] - origin[j];
                ++j;
            }
            float normi = VectorOperations.norm(refi);
            if (normi == 0.0f) {
                normi = 1.0E-8f;
            }
            if ((cosine = VectorOperations.dotProduct(refi, ref) / (normi * norm0)) > 1.0f) {
                cosine = 1.0f;
            }
            if (cosine < -1.0f) {
                cosine = -1.0f;
            }
            float ang = (float)Math.acos(cosine);
            float foo = ref[ind1] * refi[ind2] - refi[ind1] * ref[ind2];
            if (foo < 0.0f) {
                ang = (float)Math.PI * 2 - ang;
            }
            float[] fldata = (float[])data.get(i7);
            Object obje = null;
            if (assobj != null) {
                obje = assobj[i7];
            }
            comp[i7] = new AngComp(fldata, obje, ang, counterClockWise);
            ++i7;
        }
        Arrays.sort(comp);
        Vector<Object> retvec = new Vector<Object>();
        int i8 = 0;
        while (i8 < comp.length) {
            retvec.addElement(((AngComp)comp[i8]).getVal());
            logger.debug((Object)("i, ang: " + i8 + "," + (double)((AngComp)comp[i8]).getAngle() * 57.29577951308232));
            ++i8;
        }
        if (assobj != null) {
            i8 = 0;
            while (i8 < comp.length) {
                retvec.addElement(((AngComp)comp[i8]).getAssociatedData());
                ++i8;
            }
        }
        return retvec;
    }
}

