/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.fbz;

import ciss.phase_viewer.acviewer.ChaseTransformGroup;
import ciss.phase_viewer.acviewer.fbz.FBZ;
import ciss.phase_viewer.atomcoord.VolumetricData;
import org.apache.log4j.Logger;

public class FBZTransform
extends ChaseTransformGroup {
    private Logger logger = Logger.getLogger((String)FBZTransform.class.getName());
    private FBZ fbz;

    public FBZTransform(FBZ fbz) {
        this.fbz = fbz;
    }

    @Override
    public float[][] getEffectiveBounds() {
        float[][] rl = this.fbz.getReciprocalLatticeVector();
        float[][] ret = new float[3][3];
        VolumetricData[] data = this.fbz.getAssociatedVolumetricData();
        if (data == null || data.length == 0) {
            return null;
        }
        float[] orig = data[0].getOrigin();
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                ret[i][j] = rl[i][j] * 0.5f + orig[j];
                ++j;
            }
            ++i;
        }
        return ret;
    }
}

