/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.colormap;

import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.colormap.BaseColorMap;
import ciss.phase_viewer.acviewer.colormap.ColorBar;
import ciss.phase_viewer.acviewer.colormap.ColorMap;
import ciss.phase_viewer.acviewer.colormap.ColorMapChangeEvent;
import ciss.phase_viewer.acviewer.colormap.ColorMapChangeListener;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.vecmath.Point3f;
import org.apache.log4j.Logger;

public class ColorMapPanel
extends JPanel {
    private Logger logger = Logger.getLogger((String)ColorMapPanel.class.getName());
    private J3DPanel parent;
    private JComboBox colorBars;
    private JButton update;
    private JButton add;
    private JButton remove;
    private Vector colorBarChangeListeners = new Vector();
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    private JComboBox colorMaps;
    private JCheckBox invert;
    private JTextField textBarTitle;
    private JTextField textBarPosx;
    private JTextField textBarPosy;
    private JTextField textBarPosz;
    private float minval = 0.0f;
    private float maxval = 0.0f;

    public ColorMapPanel(J3DPanel parent) {
        this.parent = parent;
        this.init();
    }

    public void addColorBarChangeListener(ColorMapChangeListener list) {
        this.colorBarChangeListeners.addElement(list);
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 0));
        ColorMap[] maps = BaseColorMap.getSupportedColorMaps();
        this.colorMaps = new JComboBox<ColorMap>(maps);
        if (maps == null || maps.length == 0) {
            this.logger.error((Object)"corrupted colormap file!!!");
        }
        JPanel pcmaps = new JPanel();
        pcmaps.setLayout(new BoxLayout(pcmaps, 0));
        pcmaps.setBorder(new TitledBorder("color map"));
        JPanel pcm = new JPanel();
        pcm.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 0;
        gc.anchor = 17;
        pcm.add((Component)this.colorMaps, gc);
        pcmaps.add(pcm);
        this.invert = new JCheckBox("invert");
        gc.anchor = 13;
        pcm.add((Component)this.invert, gc);
        pcmaps.add(pcm);
        this.colorBars = new JComboBox();
        BranchGroup rootBranch = this.parent.getRootBranch();
        Vector<Node> cbars = new Vector<Node>();
        int i = 0;
        while (i < rootBranch.numChildren()) {
            if (rootBranch.getChild(i) instanceof ColorBar) {
                cbars.add(rootBranch.getChild(i));
            }
            ++i;
        }
        if (cbars.size() != 0) {
            i = 0;
            while (i < cbars.size()) {
                this.colorBars.addItem(cbars.get(i));
                ++i;
            }
        }
        this.update = new JButton("update");
        this.add = new JButton("add");
        this.remove = new JButton("remove");
        JPanel pcbars = new JPanel();
        pcbars.setLayout(new BoxLayout(pcbars, 0));
        pcbars.setBorder(new TitledBorder("color bar"));
        JPanel pup = new JPanel();
        pup.add(this.update);
        JPanel padd = new JPanel();
        padd.add(this.add);
        JPanel prem = new JPanel();
        prem.add(this.remove);
        JPanel pcolorBars = new JPanel();
        pcolorBars.add(this.colorBars);
        pcbars.add(pcolorBars);
        JPanel pbtns = new JPanel();
        pbtns.setLayout(new BoxLayout(pbtns, 0));
        pbtns.add(pup);
        pbtns.add(padd);
        pbtns.add(prem);
        pcbars.add(pbtns);
        JPanel pcbarattr = new JPanel();
        pcbarattr.setBorder(new TitledBorder("color bar attributes"));
        JPanel ptitle = new JPanel();
        ptitle.setBorder(new TitledBorder("title"));
        this.textBarTitle = new JTextField(10);
        ptitle.add(this.textBarTitle);
        JPanel pos = new JPanel();
        pos.setLayout(new BoxLayout(pos, 0));
        pos.setBorder(new TitledBorder("position"));
        String[] pospos = null;
        try {
            pospos = this.gp.getProperty("colorbar_position").split(",");
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        JPanel posx = new JPanel();
        posx.setBorder(new TitledBorder("x"));
        this.textBarPosx = new JTextField(5);
        posx.add(this.textBarPosx);
        JPanel posy = new JPanel();
        posy.setBorder(new TitledBorder("y"));
        this.textBarPosy = new JTextField(5);
        posy.add(this.textBarPosy);
        JPanel posz = new JPanel();
        posz.setBorder(new TitledBorder("z"));
        this.textBarPosz = new JTextField(5);
        posz.add(this.textBarPosz);
        if (pospos != null && pospos.length >= 3) {
            this.textBarPosx.setText(pospos[0]);
            this.textBarPosy.setText(pospos[1]);
            this.textBarPosz.setText(pospos[2]);
        }
        pos.add(posx);
        pos.add(posy);
        pos.add(posz);
        pcbarattr.add(ptitle);
        pcbarattr.add(pos);
        JPanel pcb = new JPanel();
        pcb.setLayout(new BoxLayout(pcb, 1));
        pcb.add(pcbars);
        pcb.add(pcbarattr);
        this.add(pcmaps);
        this.add(pcb);
        this.colorBars.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorMapPanel.this.updateGUI();
            }
        });
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorMapPanel.this.drawColorBar();
            }
        });
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorMapPanel.this.removeColorBar();
            }
        });
        this.invert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColorMapPanel.this.updateAllColorBars();
                ColorMapPanel.this.notifyColorBarListeners();
            }
        });
        this.colorMaps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ColorMapPanel.this.updateAllColorBars();
                ColorMapPanel.this.notifyColorBarListeners();
            }
        });
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorMapPanel.this.updateColorBar();
                ColorMapPanel.this.notifyColorBarListeners();
            }
        });
    }

    private void updateGUI() {
        if (this.colorBars.getItemCount() == 0) {
            return;
        }
        ColorBar cb = (ColorBar)((Object)this.colorBars.getSelectedItem());
        if (cb == null) {
            return;
        }
        Point3f cen = cb.getPos();
        this.textBarPosx.setText(String.valueOf(cen.x));
        this.textBarPosy.setText(String.valueOf(cen.y));
        this.textBarPosz.setText(String.valueOf(cen.z));
        String tit = cb.getTitle();
        this.textBarTitle.setText(tit);
    }

    private void notifyColorBarListeners() {
        ColorMap cmap = null;
        Object obj = this.colorMaps.getSelectedItem();
        if (obj != null) {
            cmap = (ColorMap)obj;
        }
        boolean b = this.invert.isSelected();
        this.logger.debug((Object)("invert here: " + b));
        int i = 0;
        while (i < this.colorBarChangeListeners.size()) {
            ((ColorMapChangeListener)this.colorBarChangeListeners.get(i)).colorMapChanged(new ColorMapChangeEvent(cmap, b));
            ++i;
        }
    }

    public ColorMap getSelectedColorMap() {
        Object obj = this.colorMaps.getSelectedItem();
        if (obj == null) {
            return null;
        }
        return (ColorMap)obj;
    }

    public boolean isInvert() {
        return this.invert.isSelected();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.colorMaps.setEnabled(enabled);
        this.invert.setEnabled(enabled);
    }

    public void setMinVal(float minval) {
        this.minval = minval;
    }

    public void setMaxVal(float maxval) {
        this.maxval = maxval;
    }

    private void drawColorBar() {
        ColorMap map = (ColorMap)this.colorMaps.getSelectedItem();
        boolean b = this.invert.isSelected();
        ColorBar bar = new ColorBar(map, b, new Float(this.minval), new Float(this.maxval), this.parent);
        bar.setTitle(this.textBarTitle.getText());
        Point3f center = null;
        try {
            float x = Float.parseFloat(this.textBarPosx.getText());
            float y = Float.parseFloat(this.textBarPosy.getText());
            float z = Float.parseFloat(this.textBarPosz.getText());
            center = new Point3f(x, y, z);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (center != null) {
            bar.setPos(center);
        }
        bar.setInterpolationMode(this.parent.getAssociatedVolumetricData()[0].getInterpolationScheme());
        bar.create();
        this.parent.getRootBranch().addChild((Node)bar);
        this.colorBars.addItem(bar);
        this.logger.debug((Object)"colorbar added.");
    }

    private void updateAllColorBars() {
        int i = 0;
        while (i < this.colorBars.getItemCount()) {
            ColorBar bar = (ColorBar)((Object)this.colorBars.getItemAt(i));
            ColorMap map = (ColorMap)this.colorMaps.getSelectedItem();
            boolean b = this.invert.isSelected();
            bar.recreate(map, b);
            ++i;
        }
    }

    private void updateColorBar() {
        if (this.colorBars.getItemCount() == 0) {
            this.drawColorBar();
            return;
        }
        ColorBar bar = (ColorBar)((Object)this.colorBars.getSelectedItem());
        if (bar != null) {
            ColorMap map = (ColorMap)this.colorMaps.getSelectedItem();
            boolean b = this.invert.isSelected();
            bar.setTitle(this.textBarTitle.getText());
            Point3f center = null;
            try {
                float x = Float.parseFloat(this.textBarPosx.getText());
                float y = Float.parseFloat(this.textBarPosy.getText());
                float z = Float.parseFloat(this.textBarPosz.getText());
                center = new Point3f(x, y, z);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            if (center != null) {
                bar.setPos(center);
            }
            bar.recreate(map, b, new Float(this.minval), new Float(this.maxval));
        }
    }

    private void removeColorBar() {
        if (this.colorBars.getItemCount() == 0) {
            return;
        }
        try {
            ColorBar bar = (ColorBar)((Object)this.colorBars.getSelectedItem());
            if (bar != null) {
                bar.detach();
                this.colorBars.removeItem((Object)bar);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

