/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer;

import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.Rectangle;
import com.sun.j3d.utils.universe.PlatformGeometry;
import java.util.Enumeration;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

class RectangleCreator {
    private Logger logger = Logger.getLogger((String)RectangleCreator.class.getName());
    private MainPanel parent;
    private PlatformGeometry platform;
    private float x = 0.0f;
    private float y = 0.0f;
    private float width = 0.0f;
    private float height = 0.0f;
    private TransformGroup transform;
    private Rectangle rectangle;
    private float shift = -0.0f;
    private float factor = 1.0f;
    private float yfactor = 0.875f;
    private double dviewplat;

    protected RectangleCreator(MainPanel parent) {
        this.parent = parent;
        this.init();
    }

    protected RectangleCreator(MainPanel parent, float x, float y) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.init();
    }

    protected RectangleCreator(MainPanel parent, float x, float y, float width, float height) {
        this.parent = parent;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.init();
    }

    private void init() {
        Transform3D viewplat = new Transform3D();
        this.parent.getUniverse().getViewingPlatform().getViewPlatformTransform().getTransform(viewplat);
        Vector3d vvd = new Vector3d();
        viewplat.get(vvd);
        this.dviewplat = vvd.z;
        this.shift = -0.5f * (float)vvd.z;
        this.factor = Math.abs(this.shift) / (float)this.dviewplat;
        this.logger.debug((Object)("dviewplat x,y,z: " + vvd.x + ", " + vvd.y + ", " + vvd.z));
        this.platform = new PlatformGeometry();
        this.transform = new TransformGroup();
        this.transform.setCapability(17);
        this.transform.setCapability(18);
        this.transform.setCapability(14);
        this.transform.setCapability(12);
        this.transform.setCapability(13);
        Transform3D t3d = new Transform3D();
        Vector3f translate = new Vector3f(this.x, this.y, this.shift);
        t3d.setTranslation(translate);
        this.transform.setTransform(t3d);
        this.rectangle = new Rectangle(this.width, this.height);
        this.transform.addChild((Node)this.rectangle);
        this.platform.addChild((Node)this.transform);
    }

    protected void updateRectangle(float width, float height) {
        this.rectangle.setRectangleShape(width * this.factor, height * this.factor * this.yfactor);
        this.rectangle.updateRectangle();
        boolean found = false;
        Enumeration en = this.transform.getAllChildren();
        while (en.hasMoreElements()) {
            if (!(en.nextElement() instanceof Rectangle)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.transform.addChild((Node)this.rectangle);
        }
    }

    protected PlatformGeometry getPlatformGeometry() {
        return this.platform;
    }

    protected PlatformGeometry getPlatformGeometry(float width, float height) {
        this.updateRectangle(width, height);
        return this.platform;
    }

    protected void setLocation(float x, float y) {
        this.x = x * this.factor;
        this.y = y * this.factor * this.yfactor;
        this.logger.debug((Object)("location: " + x + ", " + y));
        Transform3D t3d = new Transform3D();
        Vector3f translate = new Vector3f(this.x, this.y, this.shift);
        t3d.setTranslation(translate);
        this.transform.setTransform(t3d);
    }

    protected void detach() {
        this.rectangle.detach();
    }
}

