/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer;

import ciss.phase_viewer.acviewer.ACVAction;
import ciss.phase_viewer.acviewer.Booter;
import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.MouseAdapterButton;
import ciss.phase_viewer.common.MenuTree;
import ciss.phase_viewer.common.MyJMenu;
import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.jdom.XMLUtils;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

public class PluginParser {
    private Logger logger = Logger.getLogger((String)PluginParser.class.getName());
    public static final String PLUGIN_ACV = "/ciss/phase_viewer/acviewer/plugins.xml";
    public static final String PLUGIN_KSPACE = "/ciss/phase_viewer/acviewer/fbz/plugins.xml";
    private J3DPanel parent;
    private Vector buttonVector = new Vector();
    private Vector menuVector = new Vector();
    private String pluginPath = "/ciss/phase_viewer/acviewer/plugins.xml";
    private long delay = 1000L;
    private MenuTree tree = new MenuTree();

    public PluginParser(J3DPanel parent) {
        this.parent = parent;
        this.init();
        this.parse();
    }

    public PluginParser(J3DPanel parent, String pluginPath) {
        this.parent = parent;
        this.pluginPath = pluginPath;
        this.init();
        this.parse();
    }

    private void init() {
        try {
            this.delay = Long.parseLong(this.parent.getJ3DProperties().getProperty("viewer_button_tooltip_delay"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JButton[] getButtons() {
        if (this.buttonVector.size() == 0) {
            return null;
        }
        Object[] buttons = new JButton[this.buttonVector.size()];
        this.buttonVector.copyInto(buttons);
        return buttons;
    }

    public JMenu[] getMenus() {
        return this.tree.getMenus();
    }

    private void parse() {
        URL url = PluginParser.class.getResource(this.pluginPath);
        Document doc = XMLUtils.getDocumentFromURL(url);
        if (doc == null) {
            this.logger.error((Object)"couldn't read plugin specification file...");
            return;
        }
        Element root = doc.getRootElement();
        List topmenus = root.getChildren("menus");
        if (topmenus == null || topmenus.size() == 0) {
            this.logger.warn((Object)"no definition for menu found... something is probably wrong.");
            return;
        }
        int i = 0;
        while (i < topmenus.size()) {
            this.createMenus((Element)topmenus.get(i));
            ++i;
        }
        List modules = root.getChildren("module");
        if (modules == null || modules.size() == 0) {
            this.logger.warn((Object)"no plugins found... something is probably wrong.");
            return;
        }
        int i2 = 0;
        while (i2 < modules.size()) {
            this.parseEachModule((Element)modules.get(i2));
            ++i2;
        }
    }

    private void createMenus(Element menus) {
        List children = menus.getChildren();
        int i = 0;
        while (i < children.size()) {
            Element menu = (Element)children.get(i);
            String[] menuName = menu.getName().split("\\.");
            Attribute attr = menu.getAttribute("shortcut");
            char shortcut = ' ';
            if (attr != null) {
                shortcut = attr.getValue().charAt(0);
            }
            this.createMenu(menuName, shortcut);
            ++i;
        }
    }

    private void createMenu(String[] menuName, char shortcut) {
        this.tree.selectRoot();
        int i = 0;
        while (i < menuName.length) {
            this.logger.debug((Object)("creating menu: " + menuName[i]));
            MyJMenu men = new MyJMenu(menuName[i]);
            men.setMnemonic(shortcut);
            this.tree.selectBlock(men);
            ++i;
        }
    }

    private void parseEachModule(Element module) {
        String name = module.getChildTextTrim("name");
        if (name == null) {
            name = "";
        }
        String action = module.getChildTextTrim("action");
        List booters = module.getChildren("booter");
        Vector<Booter> bootersVec = new Vector<Booter>();
        int i = 0;
        while (i < booters.size()) {
            Booter booter = new Booter((Element)booters.get(i));
            bootersVec.addElement(booter);
            ++i;
        }
        Object[] booterAr = null;
        if (bootersVec.size() != 0) {
            booterAr = new Booter[bootersVec.size()];
            bootersVec.copyInto(booterAr);
        }
        this.createModule(name, action, (Booter[])booterAr);
    }

    private void createModule(String name, String action, Booter[] booterAr) {
        if (booterAr == null || booterAr.length == 0) {
            return;
        }
        int i = 0;
        while (i < booterAr.length) {
            ACVAction acvaction;
            int type = booterAr[i].type;
            String text = booterAr[i].tooltiptext;
            String icon = booterAr[i].iconpath;
            String spec = booterAr[i].spec;
            char shortcut = booterAr[i].shortcut;
            boolean hasSep = booterAr[i].hasSep;
            if (type == Booter.BUTTON) {
                JButton btn = this.createButtonFrom(name, text, icon);
                acvaction = ACVAction.getAction(this.parent, action);
                btn.addActionListener(acvaction);
                this.buttonVector.addElement(btn);
            } else if (type == Booter.MENU) {
                JMenuItem menuItem = this.createMenuItemFrom(name, spec, text, icon);
                acvaction = ACVAction.getAction(this.parent, action);
                menuItem.addActionListener(acvaction);
                if (shortcut != ' ') {
                    menuItem.setMnemonic(shortcut);
                }
                this.addMenuItem(spec, menuItem, hasSep);
            }
            ++i;
        }
    }

    private JButton createButtonFrom(String name, String tooltipText, String iconpath) {
        ImageIcon ico;
        JButton btn = null;
        btn = iconpath.trim().length() == 0 ? new JButton(name) : ((ico = new ImageIcon(this.getClass().getResource(iconpath))) != null ? new JButton(ico) : new JButton(name));
        boolean viewer_button_no_tooltip = new Boolean(this.parent.getJ3DProperties().getProperty("viewer_button_no_tooltip"));
        if (tooltipText.trim().length() != 0 && !viewer_button_no_tooltip) {
            MouseAdapterButton adap = new MouseAdapterButton(tooltipText, this.delay);
            btn.addMouseListener(adap);
        }
        return btn;
    }

    private JMenuItem createMenuItemFrom(String name, String spec, String tooltipText, String iconpath) {
        ImageIcon ico;
        String[] menuSpec = spec.split("\\.");
        String menuItem = "";
        menuItem = menuSpec.length == 0 ? spec : menuSpec[menuSpec.length - 1];
        MyJMenuItem item = new MyJMenuItem(menuItem);
        if (tooltipText != null && tooltipText.trim().length() != 0) {
            item.setToolTipText(tooltipText);
        }
        if (iconpath != null && iconpath.trim().length() != 0 && (ico = new ImageIcon(this.getClass().getResource(iconpath))) != null) {
            item.setIcon(ico);
        }
        return item;
    }

    private void addMenuItem(String spec, JMenuItem item, boolean hasSep) {
        String[] menuSpec = spec.split("\\.");
        String menuItem = "";
        this.tree.selectRoot();
        int i = 0;
        while (i < menuSpec.length - 1) {
            this.tree.selectBlock(menuSpec[i]);
            ++i;
        }
        this.tree.addMenuItem(item, hasSep);
    }
}

