/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer;

import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.J3DDataManager;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.common.ElementInfo;
import ciss.phase_viewer.common.TaggedString;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ConfigDataManager {
    private Logger logger = Logger.getLogger((String)ConfigDataManager.class.getName());
    private String[][] XYZ;
    private String[][] originalXYZ;
    private int NumAt;
    private double lenmax;
    private double[] com = new double[]{0.0, 0.0, 0.0};
    private boolean cellorigin;
    private double[] cellorigin_vec;
    private boolean validcell = true;
    private AtomCoords coords;
    private AtomCoords coords_buff;
    private double[][] cell;
    private String[] elements;
    private TaggedString[][] auxils;
    private double[][] Dpos;
    private int[] mobile;
    private int[] weight;
    private Vector holdsConfigList = new Vector();
    private int frameNum = 0;
    private MainPanel parent;
    private float scaleatom;
    private int origNumAt;
    private J3DDataManager dataManager;
    private boolean renderingManual = false;
    private Vector atomData;
    private boolean forceUpdate = false;
    private double[] minCoords;

    public ConfigDataManager(AtomCoords coords) {
        this.coords = coords;
        this.coords_buff = coords.getCopy();
        this.origNumAt = coords.getNumAt();
        this.init();
    }

    public void resetOrigNumAt() {
        this.origNumAt = this.coords.getNumAt();
    }

    public void setJ3DDataManager(J3DDataManager dataMan) {
        this.dataManager = dataMan;
    }

    public void setScaleAtom(float scale) {
        this.scaleatom = 2.2f * scale / (float)Math.pow(this.origNumAt, 0.3333333432674408);
    }

    public float getScaleAtom() {
        return this.scaleatom;
    }

    public void isRenderingManual(boolean renderingManual) {
        this.renderingManual = renderingManual;
    }

    public void setCoords(AtomCoords coords) {
        this.coords = coords;
        this.init();
        this.update();
    }

    public void setCoords(AtomCoords coords, int updateType) {
        this.coords = coords;
        this.init();
        this.update(updateType);
    }

    public void setCoords(AtomCoords coords, boolean rescale) {
        this.coords = coords;
        this.init();
        this.update(rescale);
    }

    public void setCoordsNoUpdate(AtomCoords coords) {
        this.coords = coords;
        this.init();
    }

    public void doShiftScale() {
        double xmax = -100000.0;
        double ymax = -100000.0;
        double zmax = -100000.0;
        double xmin = -xmax;
        double ymin = -ymax;
        double zmin = -zmax;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        int i = 0;
        while (i < this.Dpos.length) {
            double x = this.Dpos[i][0];
            double y = this.Dpos[i][1];
            double z = this.Dpos[i][2];
            sumX += x;
            sumY += y;
            sumZ += z;
            if (x < xmin) {
                xmin = x;
            }
            if (y < ymin) {
                ymin = y;
            }
            if (z < zmin) {
                zmin = z;
            }
            if (x > xmax) {
                xmax = x;
            }
            if (y > ymax) {
                ymax = y;
            }
            if (z > zmax) {
                zmax = z;
            }
            ++i;
        }
        double lenx = xmax - xmin;
        double leny = ymax - ymin;
        double lenz = zmax - zmin;
        if (lenx > this.lenmax) {
            this.lenmax = lenx;
        }
        if (leny > this.lenmax) {
            this.lenmax = leny;
        }
        if (lenz > this.lenmax) {
            this.lenmax = lenz;
        }
        if (this.Dpos.length == 1) {
            this.lenmax = 1.0;
        }
        if (this.dataManager == null) {
            this.logger.error((Object)"dataManager is null...");
        }
        this.lenmax /= (double)this.dataManager.getScale();
        double jusinX = sumX / (double)this.Dpos.length;
        double jusinY = sumY / (double)this.Dpos.length;
        double jusinZ = sumZ / (double)this.Dpos.length;
        this.logger.debug((Object)("com " + jusinX + " " + jusinY + " " + jusinZ));
        if (this.cell != null && this.cell.length > 2) {
            this.logger.debug((Object)("cell " + this.cell[0][0] + " " + this.cell[0][1] + " " + this.cell[0][2]));
            this.logger.debug((Object)("cell " + this.cell[1][0] + " " + this.cell[1][1] + " " + this.cell[1][2]));
            this.logger.debug((Object)("cell " + this.cell[2][0] + " " + this.cell[2][1] + " " + this.cell[2][2]));
            double tx = 0.0;
            double ty = 0.0;
            double tz = 0.0;
            int ii = 0;
            while (ii < 3) {
                tx += this.cell[ii][0];
                ty += this.cell[ii][1];
                tz += this.cell[ii][2];
                ++ii;
            }
            this.logger.debug((Object)("center of cell " + tx * 0.5 + " " + ty * 0.5 + " " + tz * 0.5));
            jusinX = tx * 0.5;
            jusinY = ty * 0.5;
            jusinZ = tz * 0.5;
        }
        this.setCOM(new double[]{jusinX, jusinY, jusinZ});
    }

    private void init() {
        this.validcell = this.coords.isCellValid(0);
        this.NumAt = this.coords.getNumAt();
        if (this.validcell) {
            this.cell = this.coords.getCellDouble(0);
        }
        this.Dpos = this.coords.getPosDouble();
        this.elements = this.coords.getElements();
        this.auxils = this.coords.getAuxils();
        this.cellorigin = this.coords.isInternal();
        if (this.Dpos == null) {
            return;
        }
        double minx = 100000.0;
        double miny = 100000.0;
        double minz = 100000.0;
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        int i = 0;
        while (i < this.Dpos.length) {
            if (this.Dpos[i][0] < minx) {
                minx = this.Dpos[i][0];
            }
            if (this.Dpos[i][1] < miny) {
                miny = this.Dpos[i][1];
            }
            if (this.Dpos[i][2] < minz) {
                minz = this.Dpos[i][2];
            }
            sumX += this.Dpos[i][0];
            sumY += this.Dpos[i][1];
            sumZ += this.Dpos[i][2];
            ++i;
        }
        this.minCoords = new double[]{minx, miny, minz};
    }

    public void registerAtoms(ConfigData data) {
        if (this.atomData == null) {
            this.atomData = new Vector();
        }
        this.atomData.add(data);
    }

    public void removeConfigData(ConfigData data) {
        if (this.holdsConfigList != null) {
            this.holdsConfigList.remove(data);
        }
    }

    public void register(ConfigData data) {
        this.holdsConfigList.addElement(data);
    }

    public void setParent(MainPanel parent) {
        this.parent = parent;
    }

    public void update() {
        this.update(true);
    }

    private void update(int updateType) {
        try {
            if (!this.renderingManual) {
                this.parent.prepareRedraw();
            }
            int n = this.holdsConfigList.size();
            ((TGAtom)this.parent.getRootTransform()).prepare(false);
            ((TGAtom)this.parent.getRootTransform()).atomUpdate();
            int i = n - 1;
            while (i >= 0) {
                ConfigData data = (ConfigData)this.holdsConfigList.get(i);
                ConfigDataUpdateEvent e = new ConfigDataUpdateEvent(data, updateType);
                if (data.needsUpdate()) {
                    data.configDataUpdate(true, e);
                }
                --i;
            }
            if (!this.renderingManual) {
                this.parent.postRedraw();
            }
            this.forceUpdate = false;
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public boolean forceUpdate() {
        return this.forceUpdate;
    }

    public void forceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    public void update(boolean rescaleOnUpdate) {
        try {
            if (!this.renderingManual) {
                this.parent.prepareRedraw();
            }
            int n = this.holdsConfigList.size();
            ((TGAtom)this.parent.getRootTransform()).prepare(false);
            ((TGAtom)this.parent.getRootTransform()).atomUpdate();
            int i = n - 1;
            while (i >= 0) {
                ConfigData data = (ConfigData)this.holdsConfigList.get(i);
                ConfigDataUpdateEvent e = new ConfigDataUpdateEvent(data, ConfigDataUpdateEvent.GENERIC);
                if (data.needsUpdate()) {
                    data.configDataUpdate(rescaleOnUpdate, e);
                }
                --i;
            }
            if (!this.renderingManual) {
                this.parent.postRedraw();
            }
            this.forceUpdate = false;
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public AtomCoords getAtomCoords() {
        return this.coords;
    }

    public double[][] getOriginalCellVec() {
        double[][] cell_buff = null;
        if (this.validcell) {
            cell_buff = this.coords_buff.getCellDouble(0);
        }
        return cell_buff;
    }

    public double[][] getPos() {
        return this.coords.getPosDouble();
    }

    public double[] getPos(int key) {
        return this.coords.getPosDouble()[key];
    }

    public double[][] getForce() {
        return this.coords.getForceDouble();
    }

    public double[] getForce(int key) {
        return this.coords.getForceDouble()[key];
    }

    public double[][] getOriginalPos() {
        return this.coords_buff.getPosDouble();
    }

    public String[] getOriginalElements() {
        String[] elements_buff = this.coords_buff.getElements();
        return elements_buff;
    }

    public TaggedString[][] getOriginalAuxils() {
        TaggedString[][] auxils_buff = this.coords_buff.getAuxils();
        return auxils_buff;
    }

    public double[][] getCell() {
        if (this.coords.getCell() != null && this.coords.getCell()[0] != null) {
            return this.coords.getCell()[0].getDouble();
        }
        return null;
    }

    public void setCell(double[][] cell) {
        this.cell = cell;
    }

    public String[] getElements() {
        return this.elements;
    }

    public int getAtomicNumber(int key) {
        String elemtmp = this.elements[key];
        ElementInfo ei = ElementInfo.getElementInfo();
        return ei.getNumberFromSymbol(elemtmp);
    }

    public void setElements(String elements, int key) {
        this.elements[key] = elements;
    }

    public void setElements(String[] elements) {
        this.elements = elements;
    }

    public void setAuxils(TaggedString[][] auxils) {
        this.auxils = auxils;
    }

    public void setAuxils(TaggedString[] auxils, int key) {
        this.auxils[key] = auxils;
    }

    public TaggedString[][] getAuxils() {
        return this.auxils;
    }

    public TaggedString[] getAuxils(int key) {
        return this.auxils[key];
    }

    public void setLenMax(double lenmax) {
        this.lenmax = lenmax;
    }

    public double getLenMax() {
        return this.lenmax;
    }

    public double[] getCOM() {
        return this.com;
    }

    public void setCOM(double[] com) {
        this.com = com;
    }

    public int getNumAt() {
        return this.coords.getNumAt();
    }

    public boolean hasCellOrigin() {
        return this.cellorigin;
    }

    public double[] getMinCoords() {
        return this.minCoords;
    }

    public double[] getCellOriginVector(int shiftPolicy) {
        double[] ret = new double[3];
        double[] offset = new double[]{0.0, 0.0, 0.0};
        if (this.coords.getCell() != null && this.coords.getCell()[0] != null) {
            offset = this.coords.getCell()[0].getCellOffset();
        }
        if (this.hasCellOrigin() || shiftPolicy == J3DDataManager.CENTER_OF_CELL) {
            int i = 0;
            while (i < 3) {
                ret[i] = -this.com[i] - offset[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < 3) {
                ret[i] = this.minCoords[i] - this.com[i] - offset[i];
                ++i;
            }
        }
        return ret;
    }

    public double[] getCellOriginVector() {
        return this.getCellOriginVector(J3DDataManager.CENTER_OF_CELL);
    }

    private void setValidCell(boolean validcell) {
        this.validcell = validcell;
    }

    public boolean getValidCell() {
        return this.coords.isCellValid(0);
    }

    public void setFrameNum(int frameNum) {
        this.frameNum = frameNum;
    }

    public int getFrameNum() {
        return this.frameNum;
    }

    public double[] getPosfromVirtualWorld(double x, double y, double z) {
        double lenmax = this.getLenMax();
        double[] jusin = this.getCOM();
        double[] dnewpos = new double[]{x * lenmax + jusin[0], y * lenmax + jusin[1], z * lenmax + jusin[2]};
        return dnewpos;
    }
}

