/*
 * Decompiled with CFR 0.152.
 */
package jas.hist.util;

import jas.hist.HasSlices;
import jas.hist.Rebinnable1DHistogramData;
import jas.hist.Rebinnable2DHistogramData;
import jas.hist.SliceParameters;
import jas.hist.util.AbstractSlice;
import jas.hist.util.DefaultSliceParameters;
import jas.hist.util.ScatterAdapter;
import jas.hist.util.SliceAdapter;
import jas.hist.util.SliceEvent;
import jas.hist.util.SliceListener;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class TwoDSliceAdapter
extends ScatterAdapter
implements HasSlices,
SliceAdapter {
    protected Vector slices = new Vector();
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$jas$hist$util$SliceListener;

    public TwoDSliceAdapter(Rebinnable2DHistogramData rebinnable2DHistogramData) {
        super(rebinnable2DHistogramData);
    }

    public void addSliceListener(SliceListener sliceListener) {
        this.listenerList.add(class$jas$hist$util$SliceListener == null ? (class$jas$hist$util$SliceListener = TwoDSliceAdapter.class$("jas.hist.util.SliceListener")) : class$jas$hist$util$SliceListener, sliceListener);
    }

    public void removeSliceListener(SliceListener sliceListener) {
        this.listenerList.remove(class$jas$hist$util$SliceListener == null ? (class$jas$hist$util$SliceListener = TwoDSliceAdapter.class$("jas.hist.util.SliceListener")) : class$jas$hist$util$SliceListener, sliceListener);
    }

    protected void fireSliceAdded(int n) {
        SliceEvent sliceEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$jas$hist$util$SliceListener == null ? TwoDSliceAdapter.class$("jas.hist.util.SliceListener") : class$jas$hist$util$SliceListener)) continue;
            if (sliceEvent == null) {
                sliceEvent = new SliceEvent(this, SliceEvent.EventType.SLICEADDED, n);
            }
            ((SliceListener)objectArray[i + 1]).sliceAdded(sliceEvent);
        }
    }

    protected void fireSliceRemoved(int n) {
        SliceEvent sliceEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$jas$hist$util$SliceListener == null ? TwoDSliceAdapter.class$("jas.hist.util.SliceListener") : class$jas$hist$util$SliceListener)) continue;
            if (sliceEvent == null) {
                sliceEvent = new SliceEvent(this, SliceEvent.EventType.SLICEREMOVED, n);
            }
            ((SliceListener)objectArray[i + 1]).sliceRemoved(sliceEvent);
        }
    }

    public int getNSlices() {
        return this.slices.size();
    }

    public SliceParameters getSliceParameters(int n) {
        return ((AbstractSlice)this.slices.elementAt(n)).getParameters();
    }

    public Rebinnable1DHistogramData getSlice(int n) {
        return (Rebinnable1DHistogramData)this.slices.elementAt(n);
    }

    public boolean canAddRemoveSlices() {
        return true;
    }

    public int addSlice(double d, double d2, double d3, double d4, double d5) {
        int n = this.slices.size();
        String string = (d3 == Double.POSITIVE_INFINITY ? "Projection " : "Slice ") + n;
        if (this.source.isRebinnable()) {
            this.slices.addElement(new RebinnableSlice(string, d, d2, d3, d4, d5));
        } else {
            this.slices.addElement(new NonRebinnableSlice(string, d, d2, d3, d4, d5));
        }
        this.fireSliceAdded(n);
        return n;
    }

    public void removeSlice(int n) {
        this.fireSliceRemoved(n);
        this.slices.removeElementAt(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RebinnableSlice
    extends AbstractSlice {
        RebinnableSlice(String string, double d, double d2, double d3, double d4, double d5) {
            super(string, d3 == Double.POSITIVE_INFINITY);
            this.parm = new DefaultSliceParameters(this, d, d2, d3, d4, d5){
                private final /* synthetic */ RebinnableSlice this$1;
                {
                    this.this$1 = rebinnableSlice;
                }

                public void setPhi(double d) {
                    d += Math.PI * 2;
                    d = (d %= Math.PI) > 0.7853981633974483 && d < 2.356194490192345 ? 1.5707963267948966 : 0.0;
                    super.setPhi(d);
                }

                protected void changed() {
                    this.this$1.sendUpdate();
                }
            };
        }

        public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
            if (this.parm.phi == 0.0) {
                double[][][] dArray = TwoDSliceAdapter.this.source.rebin(n, d, d2, 1, this.parm.y - this.parm.height, this.parm.y + this.parm.height, bl, bl2, false);
                double[] dArray2 = new double[n];
                for (int i = 0; i < n; ++i) {
                    dArray2[i] = dArray[0][i][0];
                }
                double[][] dArrayArray = new double[][]{dArray2};
                return dArrayArray;
            }
            double[][][] dArray = TwoDSliceAdapter.this.source.rebin(1, this.parm.x - this.parm.height, this.parm.x + this.parm.height, n, d, d2, bl, bl2, false);
            return dArray[0];
        }

        public double getMin() {
            if (this.projection) {
                return this.parm.phi == 0.0 ? TwoDSliceAdapter.this.source.getXMin() : TwoDSliceAdapter.this.source.getYMin();
            }
            return this.parm.phi == 0.0 ? this.parm.x - this.parm.width : this.parm.y - this.parm.width;
        }

        public double getMax() {
            if (this.projection) {
                return this.parm.phi == 0.0 ? TwoDSliceAdapter.this.source.getXMax() : TwoDSliceAdapter.this.source.getYMax();
            }
            return this.parm.phi == 0.0 ? this.parm.x + this.parm.width : this.parm.y + this.parm.width;
        }

        public int getBins() {
            return 40;
        }

        public boolean isRebinnable() {
            return true;
        }
    }

    private class NonRebinnableSlice
    extends AbstractSlice {
        NonRebinnableSlice(String string, double d, double d2, double d3, double d4, double d5) {
            super(string, d3 == Double.POSITIVE_INFINITY);
            this.parm = new DefaultSliceParameters(this, d, d2, d3, d4, d5){
                private final /* synthetic */ NonRebinnableSlice this$1;
                {
                    this.this$1 = nonRebinnableSlice;
                }

                public void setPhi(double d) {
                    d += Math.PI * 2;
                    d = (d %= Math.PI) > 0.7853981633974483 && d < 2.356194490192345 ? 1.5707963267948966 : 0.0;
                    super.setPhi(d);
                }

                public void setX(double d) {
                    double d2 = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getXMin();
                    double d3 = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getXMax();
                    int n = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getXBins();
                    int n2 = Math.round((float)((double)n * (d - d2) / (d3 - d2)));
                    super.setX(d2 + (double)n2 * (d3 - d2) / (double)n);
                }

                public void setY(double d) {
                    double d2 = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getYMin();
                    double d3 = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getYMax();
                    int n = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getYBins();
                    int n2 = Math.round((float)((double)n * (d - d2) / (d3 - d2)));
                    super.setY(d2 + (double)n2 * (d3 - d2) / (double)n);
                }

                public void setWidth(double d) {
                    int n;
                    double d2;
                    double d3;
                    if (this.this$1.parm.phi == 0.0) {
                        d3 = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getXMin();
                        d2 = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getXMax();
                        n = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getXBins();
                    } else {
                        d3 = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getYMin();
                        d2 = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getYMax();
                        n = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getYBins();
                    }
                    double d4 = (d2 - d3) / (double)n;
                    int n2 = Math.round((float)(d / d4));
                    super.setWidth((double)n2 * d4);
                }

                public void setHeight(double d) {
                    int n;
                    double d2;
                    double d3;
                    if (this.this$1.parm.phi == 0.0) {
                        d3 = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getYMin();
                        d2 = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getYMax();
                        n = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getYBins();
                    } else {
                        d3 = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getXMin();
                        d2 = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getXMax();
                        n = NonRebinnableSlice.access$000((NonRebinnableSlice)this.this$1).source.getXBins();
                    }
                    double d4 = (d2 - d3) / (double)n;
                    int n2 = Math.round((float)(d / d4));
                    super.setHeight((double)n2 * d4);
                }

                protected void changed() {
                    this.this$1.sendUpdate();
                }
            };
        }

        public double[][] rebin(int n, double d, double d2, boolean bl, boolean bl2) {
            int n2;
            double d3 = TwoDSliceAdapter.this.source.getXMin();
            double d4 = TwoDSliceAdapter.this.source.getXMax();
            double d5 = TwoDSliceAdapter.this.source.getYMin();
            double d6 = TwoDSliceAdapter.this.source.getYMax();
            int n3 = TwoDSliceAdapter.this.source.getXBins();
            int n4 = TwoDSliceAdapter.this.source.getYBins();
            double[][][] dArray = TwoDSliceAdapter.this.source.rebin(n3, d3, d4, n4, d5, d6, bl, bl2, false);
            double[][] dArray2 = dArray[0];
            double[] dArray3 = new double[n];
            if (this.parm.phi == 0.0) {
                n2 = Math.round((float)((d - d3) * (double)n3 / (d4 - d3)));
                int n5 = Math.round((float)((d2 - d3) * (double)n3 / (d4 - d3)));
                if (n5 - n2 != n) {
                    throw new RuntimeException("Failed sanity check");
                }
                int n6 = Math.round((float)((this.parm.y - this.parm.height - d5) * (double)n4 / (d6 - d5)));
                int n7 = Math.round((float)((this.parm.y + this.parm.height - d5) * (double)n4 / (d6 - d5)));
                for (int i = Math.max(n2, 0); i < Math.min(n5, n3); ++i) {
                    for (int j = Math.max(n6, 0); j < Math.min(n7, n4); ++j) {
                        int n8 = i - n2;
                        dArray3[n8] = dArray3[n8] + dArray2[i][j];
                    }
                }
            } else {
                n2 = Math.round((float)((d - d5) * (double)n4 / (d6 - d5)));
                int n9 = Math.round((float)((d2 - d5) * (double)n4 / (d6 - d5)));
                if (n9 - n2 != n) {
                    throw new RuntimeException("Failed sanity check");
                }
                int n10 = Math.round((float)((this.parm.x - this.parm.height - d3) * (double)n3 / (d4 - d3)));
                int n11 = Math.round((float)((this.parm.x + this.parm.height - d3) * (double)n3 / (d4 - d3)));
                for (int i = Math.max(n2, 0); i < Math.min(n9, n4); ++i) {
                    for (int j = Math.max(n10, 0); j < Math.min(n11, n3); ++j) {
                        int n12 = i - n2;
                        dArray3[n12] = dArray3[n12] + dArray2[j][i];
                    }
                }
            }
            double[][] dArrayArray = new double[][]{dArray3};
            return dArrayArray;
        }

        public double getMin() {
            if (this.projection) {
                return this.parm.phi == 0.0 ? TwoDSliceAdapter.this.source.getXMin() : TwoDSliceAdapter.this.source.getYMin();
            }
            return this.parm.phi == 0.0 ? this.parm.x - this.parm.width : this.parm.y - this.parm.width;
        }

        public double getMax() {
            if (this.projection) {
                return this.parm.phi == 0.0 ? TwoDSliceAdapter.this.source.getXMax() : TwoDSliceAdapter.this.source.getYMax();
            }
            return this.parm.phi == 0.0 ? this.parm.x + this.parm.width : this.parm.y + this.parm.width;
        }

        public int getBins() {
            double d = this.getMin();
            double d2 = this.getMax();
            double d3 = this.parm.phi == 0.0 ? (TwoDSliceAdapter.this.source.getXMax() - TwoDSliceAdapter.this.source.getXMin()) / (double)TwoDSliceAdapter.this.source.getXBins() : (TwoDSliceAdapter.this.source.getYMax() - TwoDSliceAdapter.this.source.getYMin()) / (double)TwoDSliceAdapter.this.source.getYBins();
            return Math.round((float)((d2 - d) / d3));
        }

        public boolean isRebinnable() {
            return false;
        }

        static /* synthetic */ TwoDSliceAdapter access$000(NonRebinnableSlice nonRebinnableSlice) {
            return nonRebinnableSlice.TwoDSliceAdapter.this;
        }
    }
}

