/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Parameter;
import hep.aida.ref.pdf.Variable;
import java.util.ArrayList;
import java.util.Hashtable;

public class VariableList {
    public static int FUNCTION = 0;
    public static int DEPENDENT = 1;
    public static int PARAMETER = 2;
    public static int ANY = 3;
    private ArrayList list;
    private Hashtable hash = new Hashtable();
    private int type;

    public VariableList() {
        this(ANY);
    }

    public VariableList(int type) {
        this.list = new ArrayList();
        this.type = type;
    }

    public VariableList(int type, int dimension) {
        this.list = new ArrayList(dimension);
        this.type = type;
    }

    public void set(int index, Variable var) {
        if (index < 0 || index > this.list.size()) {
            throw new IllegalArgumentException("Index out of bound " + index);
        }
        this.checkVariable(var);
        Variable v = this.get(index);
        if (v != null) {
            this.hash.remove(v.name());
        }
        this.list.set(index, var);
        if (!this.hash.containsKey(var.name())) {
            this.hash.put(var.name(), var);
        }
    }

    public Variable get(int index) {
        if (index < 0 || index >= this.list.size()) {
            throw new IllegalArgumentException("Index out of bound " + index);
        }
        return (Variable)this.list.get(index);
    }

    public Variable get(String varName) {
        Variable var = (Variable)this.hash.get(varName);
        if (var == null) {
            throw new IllegalArgumentException("Variable with name " + varName + " is not in this list");
        }
        return var;
    }

    public void add(Variable var) {
        this.add(this.size(), var);
    }

    public void add(int index, Variable var) {
        if (index < 0 || index > this.list.size()) {
            throw new IllegalArgumentException("Index out of bound " + index);
        }
        this.checkVariable(var);
        this.list.add(index, var);
        if (!this.hash.containsKey(var.name())) {
            this.hash.put(var.name(), var);
        }
    }

    public void remove(Variable var) {
        this.list.remove(var);
        if (!this.list.contains(var)) {
            this.hash.remove(var.name());
        }
    }

    public void remove(int index) {
        Variable var = this.get(index);
        this.remove(var);
    }

    public void clear() {
        this.list.clear();
        this.hash.clear();
    }

    public int size() {
        return this.list.size();
    }

    public int indexOf(Variable var) {
        return this.list.indexOf(var);
    }

    public int indexOf(String varName) {
        return this.indexOf(this.get(varName));
    }

    public boolean contains(Variable var) {
        return this.list.contains(var);
    }

    public boolean contains(String varName) {
        return this.hash.containsKey(varName);
    }

    public int type() {
        return this.type;
    }

    private void checkVariable(Variable var) {
        boolean wrongType = false;
        if (this.type != ANY) {
            if (this.type == FUNCTION && !(var instanceof Function)) {
                wrongType = true;
            } else if (this.type == DEPENDENT && !(var instanceof Dependent)) {
                wrongType = true;
            } else if (this.type == PARAMETER && !(var instanceof Parameter)) {
                wrongType = true;
            }
        }
        if (wrongType) {
            throw new IllegalArgumentException("Wrong type " + var.getClass() + ". Cannot add to list of type " + this.type);
        }
        if (this.hash.containsKey(var.name()) && this.hash.get(var.name()) != var) {
            throw new IllegalArgumentException("A Variable with name " + var.name() + " is already in the list. It cannot be added.");
        }
    }
}

