/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.dataset.binner;

import hep.aida.ref.dataset.DataStatistics;
import hep.aida.ref.dataset.binner.BinError;
import hep.aida.ref.dataset.binner.Binner;
import hep.aida.ref.dataset.binner.GaussianBinError;

public class DefaultBinner
implements Binner {
    private int[] maxBins;
    private int nBins = 1;
    private int dimension;
    private DataStatistics[] binStats;
    private BinError binError;

    public DefaultBinner(int[] bins, String options) {
        int i;
        this.dimension = bins.length;
        this.maxBins = new int[this.dimension];
        for (int j = 0; j < this.dimension; ++j) {
            this.maxBins[j] = bins[j];
        }
        for (i = 0; i < this.dimension; ++i) {
            if (bins[i] < 0) {
                throw new IllegalArgumentException("Number of bins cannot be negative!!! " + bins);
            }
            this.nBins *= bins[i];
        }
        this.setBinError(new GaussianBinError());
        this.binStats = new DataStatistics[this.nBins];
        for (i = 0; i < this.nBins; ++i) {
            this.binStats[i] = new DataStatistics(this.dimension);
        }
    }

    protected int internalBin(int[] bin) {
        this.checkDimension(bin);
        int ibin = 0;
        int b = 1;
        for (int i = 0; i < this.dimension; ++i) {
            ibin += bin[i] * b;
            b *= this.maxBins[i];
        }
        return ibin;
    }

    private void checkDimension(int[] bin) {
        if (bin.length != this.dimension) {
            throw new IllegalArgumentException("Illegal dimension " + bin.length + ". It must be " + this.dimension);
        }
    }

    protected DataStatistics binStatistics(int bin) {
        return this.binStats[bin];
    }

    public void fill(int[] bin, double[] x, double weight) {
        int iBin = this.internalBin(bin);
        this.binStatistics(iBin).addEntry(x, weight);
    }

    public void setBinContent(int[] bin, int entries, double height, double[] mean, double[] rms) {
        int iBin = this.internalBin(bin);
        this.resetBin(iBin);
        this.binStatistics(iBin).addEntries(mean, rms, height, 0.0, entries);
    }

    public void addContentToBin(int[] bin, int entries, double height, double[] mean, double[] rms) {
        int iBin = this.internalBin(bin);
        this.binStatistics(iBin).addEntries(mean, rms, height, 0.0, entries);
    }

    public void removeContentFromBin(int[] bin, int entries, double height, double[] mean, double[] rms) {
        int iBin = this.internalBin(bin);
        this.binStatistics(iBin).removeEntries(mean, rms, height, 0.0, entries);
    }

    public void resetBin(int[] bin) {
        int iBin = this.internalBin(bin);
        this.resetBin(iBin);
    }

    public void reset() {
        for (int i = 0; i < this.nBins; ++i) {
            this.resetBin(i);
        }
    }

    private void resetBin(int bin) {
        this.binStatistics(bin).reset();
    }

    public int entries(int[] bin) {
        int iBin = this.internalBin(bin);
        return this.binStatistics(iBin).entries();
    }

    public double height(int[] bin) {
        int iBin = this.internalBin(bin);
        return this.binStatistics(iBin).sumOfWeights();
    }

    public double plusError(int[] bin) {
        int iBin = this.internalBin(bin);
        return this.binError.plusError(this.binStatistics(iBin).entries(), this.binStatistics(iBin).sumOfWeights());
    }

    public double minusError(int[] bin) {
        int iBin = this.internalBin(bin);
        return this.binError.minusError(this.binStatistics(iBin).entries(), this.binStatistics(iBin).sumOfWeights());
    }

    public double mean(int[] bin, int coord) {
        int iBin = this.internalBin(bin);
        return this.binStatistics(iBin).mean(coord);
    }

    public double rms(int[] bin, int coord) {
        int iBin = this.internalBin(bin);
        return this.binStatistics(iBin).rms(coord);
    }

    public void scale(double scaleFactor) {
        for (int i = 0; i < this.nBins; ++i) {
            this.binStatistics(i).scale(scaleFactor);
        }
    }

    public void setBinError(BinError binError) {
        this.binError = binError;
    }
}

