/*
 * Decompiled with CFR 0.152.
 */
package AbinitMp.Viewer;

import AbinitMp.Common.BaseWindow;
import AbinitMp.Common.GaussianCubeFile;
import AbinitMp.Structure.CoordInfo;
import AbinitMp.Tool.GridBagLayoutPanel;
import AbinitMp.Tool.MyButton;
import AbinitMp.Tool.MyLabel;
import AbinitMp.Tool.MyPanel;
import AbinitMp.Tool.MyResourceBundle;
import AbinitMp.Viewer.AbinitMpViewer;
import AbinitMp.Viewer.FileItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Switch;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.vecmath.Vector3f;

public class PeriodicWindow
extends BaseWindow {
    private AbinitMpViewer viewer;
    private Vector fileList;
    private FileItem fileItem;
    private JTextField xNumText = new JTextField("1", 3);
    private JTextField[] xIntervalText;
    private JTextField yNumText = new JTextField("1", 3);
    private JTextField[] yIntervalText;
    private JTextField zNumText = new JTextField("1", 3);
    private JTextField[] zIntervalText;

    public PeriodicWindow(AbinitMpViewer abinitMpViewer, Vector vector) {
        super(MyResourceBundle.getResourceString("PeriodicWindow.Title"));
        int n;
        this.viewer = abinitMpViewer;
        this.fileList = vector;
        this.fileItem = (FileItem)vector.get(0);
        Container container = this.getContentPane();
        container.remove(this.messagePanel);
        this.getJMenuBar().add(this.addMenuItem("PeriodicWindow.fileMenuTitle", "PeriodicWindow.fileMenu", (Action)new fileListener()));
        GridBagLayoutPanel gridBagLayoutPanel = new GridBagLayoutPanel();
        gridBagLayoutPanel.setBorder(new TitledBorder(""));
        this.xIntervalText = new JTextField[3];
        this.yIntervalText = new JTextField[3];
        this.zIntervalText = new JTextField[3];
        for (n = 0; n < 3; ++n) {
            this.xIntervalText[n] = new JTextField("0", 5);
        }
        for (n = 0; n < 3; ++n) {
            this.yIntervalText[n] = new JTextField("0", 5);
        }
        for (n = 0; n < 3; ++n) {
            this.zIntervalText[n] = new JTextField("0", 5);
        }
        gridBagLayoutPanel.layoutObject(new MyLabel("X"), 0, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(new MyLabel(MyResourceBundle.getResourceString("PeriodicWindow.n")), 5, 0, 2, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.xNumText, 7, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(new MyLabel(MyResourceBundle.getResourceString("PeriodicWindow.interval")), 12, 0, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.xIntervalText[0], 17, 0, 5, 1, 1.0, 0.0);
        if (this.fileItem.type == 8 || this.fileItem.type == 9 || this.fileItem.type == 10) {
            gridBagLayoutPanel.layoutObject(this.xIntervalText[1], 22, 0, 5, 1, 1.0, 0.0);
            gridBagLayoutPanel.layoutObject(this.xIntervalText[2], 27, 0, 5, 1, 1.0, 0.0);
        }
        gridBagLayoutPanel.layoutObject(new MyLabel("Y"), 0, 1, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(new MyLabel(MyResourceBundle.getResourceString("PeriodicWindow.n")), 5, 1, 2, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.yNumText, 7, 1, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(new MyLabel(MyResourceBundle.getResourceString("PeriodicWindow.interval")), 12, 1, 5, 1, 1.0, 0.0);
        if (this.fileItem.type == 8 || this.fileItem.type == 9 || this.fileItem.type == 10) {
            gridBagLayoutPanel.layoutObject(this.yIntervalText[0], 17, 1, 5, 1, 1.0, 0.0);
            gridBagLayoutPanel.layoutObject(this.yIntervalText[1], 22, 1, 5, 1, 1.0, 0.0);
            gridBagLayoutPanel.layoutObject(this.yIntervalText[2], 27, 1, 5, 1, 1.0, 0.0);
        } else {
            gridBagLayoutPanel.layoutObject(this.yIntervalText[1], 17, 1, 5, 1, 1.0, 0.0);
        }
        gridBagLayoutPanel.layoutObject(new MyLabel("Z"), 0, 2, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(new MyLabel(MyResourceBundle.getResourceString("PeriodicWindow.n")), 5, 2, 2, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(this.zNumText, 7, 2, 5, 1, 1.0, 0.0);
        gridBagLayoutPanel.layoutObject(new MyLabel(MyResourceBundle.getResourceString("PeriodicWindow.interval")), 12, 2, 5, 1, 1.0, 0.0);
        if (this.fileItem.type == 8 || this.fileItem.type == 9 || this.fileItem.type == 10) {
            gridBagLayoutPanel.layoutObject(this.zIntervalText[0], 17, 2, 5, 1, 1.0, 0.0);
            gridBagLayoutPanel.layoutObject(this.zIntervalText[1], 22, 2, 5, 1, 1.0, 0.0);
            gridBagLayoutPanel.layoutObject(this.zIntervalText[2], 27, 2, 5, 1, 1.0, 0.0);
        } else {
            gridBagLayoutPanel.layoutObject(this.zIntervalText[2], 17, 2, 5, 1, 1.0, 0.0);
        }
        MyPanel myPanel = new MyPanel(new FlowLayout(1));
        MyButton myButton = new MyButton(MyResourceBundle.getResourceString("draw"));
        myPanel.add(myButton);
        myButton.addActionListener(new drawListener());
        this.setDefaultData();
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)gridBagLayoutPanel, "Center");
        this.mainPanel.add((Component)myPanel, "South");
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        if (dimension2.width > 2000) {
            dimension2.width /= 2;
        }
        this.setLocation(dimension2.width - dimension.width, 0);
    }

    public void redrawCanvas() {
        int n;
        Object object;
        Object object2;
        int n2 = Integer.parseInt(this.xNumText.getText());
        int n3 = Integer.parseInt(this.yNumText.getText());
        int n4 = Integer.parseInt(this.zNumText.getText());
        float[] fArray = new float[3];
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        for (int i = 0; i < 3; ++i) {
            fArray[i] = Float.parseFloat(this.xIntervalText[i].getText());
            fArray2[i] = Float.parseFloat(this.yIntervalText[i].getText());
            fArray3[i] = Float.parseFloat(this.zIntervalText[i].getText());
        }
        if (this.fileItem.type == 8) {
            GaussianCubeFile gaussianCubeFile = (GaussianCubeFile)this.fileItem.file;
            gaussianCubeFile.createPeriodicData(n2, n3, n4);
            n2 = 1;
            n3 = 1;
            n4 = 1;
            this.viewer.calcCoordInfo();
        }
        SharedGroup sharedGroup = new SharedGroup();
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setUserData((Object)new String("Peridic"));
        Switch switch_ = this.viewer.createStructureNode();
        sharedGroup.addChild((Node)switch_);
        Switch switch_2 = this.viewer.createIsosurfaceNode();
        sharedGroup.addChild((Node)switch_2);
        for (int i = 0; i < this.fileList.size(); ++i) {
            object2 = (FileItem)this.fileList.get(i);
            if (((FileItem)object2).isosurfaceValueWindow == null || ((FileItem)object2).isosurfaceValueWindow.getIsosurfaceValuePanel().getSectionAssignWindow() == null) continue;
            object = new Switch(-2);
            ((FileItem)object2).isosurfaceValueWindow.getIsosurfaceValuePanel().getSectionAssignWindow().getSectionAssignPanel().createSectionNode((Switch)object);
            sharedGroup.addChild((Node)object);
        }
        float[] fArray4 = new float[3];
        object2 = new float[3];
        object = new float[3];
        for (n = 0; n < 3; ++n) {
            fArray4[n] = fArray[n] / 2.0f;
            object2[n] = fArray2[n] / 2.0f;
            object[n] = fArray3[n] / 2.0f;
        }
        n = (n2 + 1) % 2;
        int n5 = (n3 + 1) % 2;
        int n6 = (n4 + 1) % 2;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < n2; ++k) {
                    int n7 = 2 * (k - n2 / 2) + n;
                    int n8 = 2 * (j - n3 / 2) + n5;
                    int n9 = 2 * (i - n4 / 2) + n6;
                    float f = (float)n7 * fArray4[0] + (float)n8 * object2[0] + (float)n9 * object[0];
                    float f2 = (float)n7 * fArray4[1] + (float)n8 * object2[1] + (float)n9 * object[1];
                    float f3 = (float)n7 * fArray4[2] + (float)n8 * object2[2] + (float)n9 * object[2];
                    Transform3D transform3D = new Transform3D();
                    transform3D.setTranslation(new Vector3f(f, f2, f3));
                    TransformGroup transformGroup2 = new TransformGroup(transform3D);
                    Link link = new Link(sharedGroup);
                    transformGroup2.addChild((Node)link);
                    transformGroup.addChild((Node)transformGroup2);
                }
            }
        }
        this.viewer.getSceneViewer().setSceneGraph(transformGroup);
    }

    private void setDefaultData() {
        DecimalFormat decimalFormat = new DecimalFormat("0.0000");
        CoordInfo coordInfo = this.viewer.getCoordInfo();
        if (this.fileItem.type == 8 || this.fileItem.type == 9 || this.fileItem.type == 10) {
            GaussianCubeFile gaussianCubeFile = (GaussianCubeFile)this.fileItem.file;
            for (int i = 0; i < 3; ++i) {
                this.xIntervalText[i].setText(decimalFormat.format(gaussianCubeFile.deltaX[i] * (float)(gaussianCubeFile.nx - 1)));
                this.yIntervalText[i].setText(decimalFormat.format(gaussianCubeFile.deltaY[i] * (float)(gaussianCubeFile.ny - 1)));
                this.zIntervalText[i].setText(decimalFormat.format(gaussianCubeFile.deltaZ[i] * (float)(gaussianCubeFile.nz - 1)));
            }
        } else {
            this.xIntervalText[0].setText(decimalFormat.format(coordInfo.xlength));
            this.yIntervalText[1].setText(decimalFormat.format(coordInfo.ylength));
            this.zIntervalText[2].setText(decimalFormat.format(coordInfo.zlength));
        }
        this.xNumText.setText("1");
        this.yNumText.setText("1");
        this.zNumText.setText("1");
    }

    class fileListener
    extends AbstractAction {
        fileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = jMenuItem.getActionCommand();
            String[] stringArray = MyResourceBundle.getResourceStringsWithoutSeparator("PeriodicWindow.fileMenu");
            char c = string.charAt(0);
            if (PeriodicWindow.this.getNemonic(stringArray[0]) == c) {
                PeriodicWindow.this.viewer.reCreateNode();
                PeriodicWindow.this.setDefaultData();
            } else if (PeriodicWindow.this.getNemonic(stringArray[1]) == c) {
                PeriodicWindow.this.setVisible(false);
            }
        }
    }

    private class drawListener
    implements ActionListener {
        private drawListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PeriodicWindow.this.redrawCanvas();
        }
    }
}

