/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.remotehostexecuter;

import com.jcraft.jsch.Session;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import jp.advancesoft.chase.ssh.Execute;
import jp.advancesoft.chase.ssh.hosts.HostInfo;
import jp.advancesoft.chase.ssh.remotehostexecuter.BatchFileTransferer;
import jp.advancesoft.chase.ssh.remotehostexecuter.RemoteExecuterThread;
import jp.advancesoft.chase.ssh.sftp.SftpEvent;
import jp.advancesoft.chase.ssh.sftp.SftpListener;
import org.apache.log4j.Logger;

public class RemoteHostExecuter
implements SftpListener {
    private Logger logger = Logger.getLogger((String)RemoteHostExecuter.class.getName());
    private String projdir;
    private HostInfo hostinfo;
    private boolean islocalhost = false;
    private String script;
    private String targetdir;
    private BatchFileTransferer batchTransfer;
    private String subfile;
    private Execute exe;

    public RemoteHostExecuter(String projdir, HostInfo hostinfo, BatchFileTransferer batchTransfer) {
        this.projdir = projdir;
        this.hostinfo = hostinfo;
        this.batchTransfer = batchTransfer;
        if (hostinfo.getName().equals("localhost")) {
            this.islocalhost = true;
        }
        if (!projdir.endsWith(System.getProperty("file.separator"))) {
            projdir = projdir + System.getProperty("file.separator");
        }
        this.subfile = projdir + "submit.sh";
        batchTransfer.addSftpListener(this);
        this.targetdir = batchTransfer.getTargetDir();
    }

    public RemoteHostExecuter(Execute exe) {
        this.exe = exe;
    }

    public void uploadFinished(SftpEvent se) {
        this.remoteExecute();
    }

    public void downloadFinished(SftpEvent se) {
    }

    public void setScriptText(String script) {
        this.script = script;
    }

    public void execute() {
        if (this.islocalhost) {
            this.logger.error((Object)"this class is not intended for 'localhost'");
            return;
        }
        this.createScript();
        this.transferFiles();
    }

    private boolean createScript() {
        try {
            FileWriter fwriter = new FileWriter(this.subfile);
            BufferedWriter bwriter = new BufferedWriter(fwriter);
            bwriter.write(this.script, 0, this.script.length());
            bwriter.flush();
            fwriter.close();
        }
        catch (IOException ioe) {
            this.logger.error((Object)"failed to create script file.");
            return false;
        }
        this.batchTransfer.registerFiles(this.subfile);
        return true;
    }

    private void transferFiles() {
        this.batchTransfer.upload();
    }

    private void remoteExecute() {
        Session session = this.batchTransfer.getSession();
        this.exe = new Execute(session);
        String chmod = "chmod 755 " + this.targetdir + "/" + "submit.sh";
        String ret = this.exe.command(chmod);
        if (ret != null && ret.length() != 0) {
            this.logger.info((Object)"info from 'chmod' command");
            this.logger.info((Object)("\n" + ret));
        }
        new Thread(new RemoteExecuterThread(this.exe, this.targetdir, this.hostinfo, this.logger)).start();
    }
}

