/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase.projectinfo;

import java.util.Calendar;
import jp.advancesoft.chase.inputinterface.DataManager;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import jp.advancesoft.chase.phase.projectinfo.PhaseInfo;
import jp.advancesoft.chase.phase.projectinfo.ProjectIntegretyChecker;
import jp.advancesoft.chase.phase.projectinfo.SubProjectInfo;
import org.apache.log4j.Logger;

public class ProjectInfo {
    private static Logger logger = Logger.getLogger((String)ProjectInfo.class.getName());
    public static final String PROJECTFILE_NAME = "project.c3p";
    private final String FS = System.getProperty("file.separator");
    private String baseDir;
    private String projectFile;
    private InputInterface inputInterface;
    private InputInterfacePrimitiveEntry[] subprojs;

    public ProjectInfo(String baseDir) {
        this.baseDir = baseDir;
        this.projectFile = baseDir + this.FS + PROJECTFILE_NAME;
        DataManager dm = new DataManager(this.projectFile, true);
        dm.parse();
        this.inputInterface = dm.getInputInterface();
        ProjectIntegretyChecker checker = new ProjectIntegretyChecker(this.inputInterface);
        checker.check();
        this.subprojs = checker.getSubProjects();
        if (this.subprojs != null) {
            for (int i = 0; i < this.subprojs.length; ++i) {
                logger.debug((Object)("found subproject: " + this.subprojs[i].getName() + ", project type: " + this.subprojs[i].getValue()));
            }
        }
        this.debug();
    }

    public String getProjectDirectory() {
        return this.baseDir;
    }

    public InputInterface getInfo() {
        return this.inputInterface;
    }

    public SubProjectInfo getSubProjectInfo(int index) {
        String type = this.subprojs[index].getValue().trim();
        String name = this.subprojs[index].getName().trim();
        if (type.equals("scf")) {
            return this.createPhaseInfo(name, type);
        }
        return null;
    }

    public InputInterfacePrimitiveEntry[] getSubProjects() {
        return this.subprojs;
    }

    private void debug() {
        this.inputInterface.scanList();
        this.inputInterface.selectRoot();
        this.inputInterface.selectBlock("\\P");
        this.inputInterface.selectBlock("fnamesdata");
        InputInterfacePrimitiveEntry entry = this.inputInterface.getPrimitiveEntry("F_INP");
        logger.debug((Object)(entry.getName() + ": " + entry.getValue()));
        entry = this.inputInterface.getPrimitiveEntry("F_POT(1)");
        logger.debug((Object)(entry.getName() + ": " + entry.getValue()));
        logger.debug((Object)("project file: " + this.projectFile));
        Calendar calendar = Calendar.getInstance();
        logger.debug((Object)("the time is: " + calendar.get(1) + "/" + calendar.get(2) + "/" + calendar.get(5) + " " + calendar.get(10) + ":" + calendar.get(12) + ":" + calendar.get(13) + " (" + calendar.getTimeZone().getDisplayName() + ")"));
    }

    private PhaseInfo createPhaseInfo(String blockName, String type) {
        String subpath = this.FS + blockName;
        if (blockName.trim().equals("\\P")) {
            subpath = "";
        }
        this.inputInterface.selectRoot();
        if (this.inputInterface.selectBlock(blockName) && this.inputInterface.selectBlock("fnamesdata")) {
            InputInterfacePrimitiveEntry[] fnames = this.inputInterface.getAllPrimitiveEntries();
            PhaseInfo pi = new PhaseInfo(fnames, this.baseDir + subpath);
            pi.setType(type);
            return pi;
        }
        return null;
    }
}

