/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.util.EventObject;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.common.HasPost;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import jp.advancesoft.chase.phase.TableForNonTabularData;
import org.apache.log4j.Logger;

public class TableModelForNonTabularData
extends DefaultTableModel
implements Command,
HasPost {
    private static Logger logger = Logger.getLogger((String)TableModelForNonTabularData.class.getName());
    private TableForNonTabularData table;
    private String[] ignore;
    private boolean doPost = true;

    public TableModelForNonTabularData(TableForNonTabularData table) {
        this.table = table;
    }

    public TableModelForNonTabularData(TableForNonTabularData table, int rowCount, int columnCount) {
        super(rowCount, columnCount);
        this.table = table;
    }

    public TableModelForNonTabularData(TableForNonTabularData table, Object[][] data, Object[] columnNames) {
        super(data, columnNames);
        this.table = table;
    }

    public TableModelForNonTabularData(TableForNonTabularData table, Object[] columnNames, int rowCount) {
        super(columnNames, rowCount);
        this.table = table;
    }

    public TableModelForNonTabularData(TableForNonTabularData table, Vector columnNames, int rowCount) {
        super(columnNames, rowCount);
        this.table = table;
    }

    public TableModelForNonTabularData(TableForNonTabularData table, Vector data, Vector columnNames) {
        super(data, columnNames);
        this.table = table;
    }

    public void ignoreOnSave(String[] ignore) {
        this.ignore = ignore;
    }

    public void execute(EventObject e) {
        logger.debug((Object)"updating table data ...");
        int icol = this.getColumnCount();
        int irow = this.getRowCount();
        int rowStart = 1;
        if (!this.table.hasRowIdentifiers()) {
            rowStart = 0;
        }
        boolean rowOriented = this.table.isRowOriented();
        String[] columnName = new String[icol];
        for (int i = 0; i < icol; ++i) {
            columnName[i] = this.getColumnName(i);
        }
        InputInterface input = this.table.getInputInterface();
        Vector fullNameVector = this.table.getFullNameVector();
        Vector<InputInterfacePrimitiveEntry> entries = new Vector<InputInterfacePrimitiveEntry>();
        for (int i = 0; i < fullNameVector.size(); ++i) {
            int j;
            input.selectRoot();
            String[] fullName = (String[])fullNameVector.get(i);
            for (int j2 = 0; j2 < fullName.length - 1; ++j2) {
                String ident = fullName[j2];
                if (!input.selectBlock(ident)) {
                    logger.debug((Object)("couldn't select block: " + ident));
                    continue;
                }
                logger.debug((Object)("selected block: " + ident));
            }
            String accumData = "";
            String name = "";
            if (rowOriented) {
                for (j = rowStart; j < icol; ++j) {
                    accumData = accumData + (String)this.getValueAt(i, j) + " ";
                }
                name = ((String)this.getValueAt(i, 0)).trim();
            } else {
                for (j = 0; j < irow; ++j) {
                    accumData = accumData + (String)this.getValueAt(j, i + rowStart);
                }
                name = columnName[i + rowStart].trim();
            }
            InputInterfacePrimitiveEntry entry = new InputInterfacePrimitiveEntry(name, accumData, "");
            input.replaceEntry(entry);
            entries.addElement(entry);
            input.selectRoot();
        }
        if (this.doPost) {
            this.post(columnName, entries);
        }
    }

    public TableForNonTabularData getTable() {
        return this.table;
    }

    public boolean isRowOriented() {
        return this.table.isRowOriented();
    }

    public void disablePost() {
        this.doPost = false;
    }

    public void enablePost() {
        this.doPost = true;
    }

    public void post(String[] columnName, Vector entries) {
    }

    public void post() {
    }
}

