/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import jp.advancesoft.chase.common.ExternalProgramExecuter;
import jp.advancesoft.chase.common.MyMessageBox;

public class FileNamesData {
    public static final String FN_DATA = "file_names.data";
    public static final int COPY = 1;
    public static final int DELETE = 2;
    private MyMessageBox mbox = new MyMessageBox();
    private String fndata = new String();
    private String[] identifiers = new String[]{"F_INP", "F_DYNM", "F_ENF", "F_CHR", "F_DOS", "F_ENERG", "F_ZAJ", "F_CHGT", "F_CNTN", "F_CNTN_BIN", "F_KPOINT"};
    private int numIdent = this.identifiers.length;
    private String[] fileNames = new String[]{"nfinp.data", "nfdynm.data", "nfene.data", "nfchr.cube", "dos.data", "nfenergy.data", "nfzaj.data", "nfchgt.data", "continue.data", "continue_bin.data", "kpoint.data"};
    private Vector ppVector = new Vector();
    private Vector ppVectorAbs = new Vector();
    private String FS = System.getProperty("file.separator");
    private boolean byRelativePath = true;
    private boolean byRelativePathPP = false;
    private String projdir = System.getProperty("user.home");

    public FileNamesData() {
    }

    public FileNamesData(String fndata) {
        this.fndata = fndata;
    }

    public void read() {
        this.readFrom(this.fndata);
    }

    public void readFrom(String file) {
        if (!new File(file).exists()) {
            System.out.println("file_names.data non-existent!");
            return;
        }
        String ident = new String();
        String value = new String();
        this.ppVector.clear();
        try {
            String entry;
            BufferedReader br = new BufferedReader(new FileReader(file));
            while ((entry = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(entry, "=");
                if (st.countTokens() < 2) continue;
                ident = st.nextToken().trim();
                value = st.nextToken().trim();
                char[] cvalue = new char[value.length()];
                cvalue = value.toCharArray();
                value = String.copyValueOf(cvalue, 1, value.length() - 2);
                String valueName = new File(value).getName();
                for (int i = 0; i < this.numIdent; ++i) {
                    if (!ident.equalsIgnoreCase(this.identifiers[i])) continue;
                    this.fileNames[i] = valueName;
                }
                if (!ident.startsWith("F_POT(")) continue;
                File ppFile = new File(value);
                String valueAbs = value;
                System.out.println("pp-file " + ppFile + " is specified by relative path: " + !ppFile.isAbsolute());
                if (!ppFile.isAbsolute()) {
                    valueAbs = new File(this.fndata).getParent() + this.FS + value;
                    this.byRelativePathPP = true;
                }
                if (!(ppFile = new File(valueAbs)).exists()) {
                    this.mbox.setText("pp-file " + valueAbs + " does not exist.");
                    continue;
                }
                this.ppVector.addElement(value);
                this.ppVectorAbs.addElement(valueAbs);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("failed read from: " + file);
        }
    }

    public void write() {
        this.writeTo(this.fndata);
    }

    public void setWriteMode(boolean byRelativePath) {
        this.byRelativePath = byRelativePath;
    }

    public void setPPWriteMode(boolean byRelativePathPP) {
        this.byRelativePathPP = byRelativePathPP;
    }

    public boolean getPPWriteMode() {
        System.out.println("write pp by relative path: " + this.byRelativePathPP);
        return this.byRelativePathPP;
    }

    public void setProjDir(String projdir) {
        this.projdir = projdir;
    }

    public void writeTo(String file) {
        System.out.println("saving file_names.data at: " + file);
        String dirString = this.projdir;
        if (this.byRelativePath) {
            dirString = "." + this.FS;
        }
        if (!this.byRelativePath && this.projdir == null) {
            System.out.println("invalid specification of project directory!");
            return;
        }
        try {
            int i;
            PrintWriter fout = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            fout.println("&fnames");
            fout.println(" " + this.identifiers[0] + " ='" + dirString + this.fileNames[0] + "'");
            for (i = 0; i < this.ppVector.size(); ++i) {
                int ii = i + 1;
                String ppWrite = (String)this.ppVector.get(i);
                File ppfiletmp = new File(ppWrite);
                if (!this.byRelativePathPP && !ppfiletmp.isAbsolute()) {
                    ppWrite = this.projdir + ppWrite;
                }
                if (this.byRelativePathPP && ppfiletmp.isAbsolute()) {
                    ppWrite = "." + this.FS + ppfiletmp.getName();
                }
                fout.println(" F_POT(" + ii + ") = '" + ppWrite + "'");
            }
            for (i = 1; i < this.numIdent; ++i) {
                if (this.fileNames[i].trim().length() == 0) continue;
                fout.println(" " + this.identifiers[i] + " = '" + dirString + this.fileNames[i] + "'");
            }
            fout.println("&end");
            fout.close();
        }
        catch (Exception exc) {
            System.out.println("failed write to: " + file);
        }
    }

    public boolean manipulatePPFiles(int COPY_OR_DELETE, Vector ppvec) {
        String originalPP = new String();
        String ppName = new String();
        String ppPath = new String();
        for (int i = 0; i < ppvec.size(); ++i) {
            originalPP = (String)ppvec.get(i);
            ppName = new File(originalPP).getName();
            ppPath = this.projdir + ppName;
            if (COPY_OR_DELETE == 1) {
                System.out.println("copying pp-files (if non-existent) to : " + this.projdir);
                if (new File(ppPath).exists()) continue;
                try {
                    ExternalProgramExecuter.copy(originalPP, ppPath);
                    System.out.println("copied " + originalPP + " to: " + this.projdir);
                    continue;
                }
                catch (Exception exc) {
                    System.out.println("failed copy of: " + originalPP);
                    return false;
                }
            }
            if (COPY_OR_DELETE != 2) continue;
            new File(ppPath).delete();
        }
        return true;
    }

    public String getFNData() {
        return this.fndata;
    }

    public void setFNData(String fndata) {
        this.fndata = fndata;
    }

    public String getFileName(String ident) {
        ident = ident.trim();
        for (int i = 0; i < this.numIdent; ++i) {
            if (!ident.equalsIgnoreCase(this.identifiers[i])) continue;
            return this.fileNames[i];
        }
        return "";
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getIdentifiers() {
        return this.identifiers;
    }

    public boolean setFileName(String ident, String name) {
        ident = ident.trim();
        boolean bset = false;
        for (int i = 0; i < this.numIdent; ++i) {
            if (!ident.equalsIgnoreCase(this.identifiers[i])) continue;
            this.fileNames[i] = name;
            bset = true;
            break;
        }
        return bset;
    }

    public Vector getPPVector() {
        return this.ppVector;
    }

    public Vector getPPVectorAbs() {
        return this.ppVectorAbs;
    }

    public String getPPString(int i) {
        if (i > this.ppVector.size()) {
            return "";
        }
        return (String)this.ppVector.get(i);
    }

    public String getPPStringAbs(int i) {
        if (i > this.ppVectorAbs.size()) {
            return "";
        }
        return (String)this.ppVectorAbs.get(i);
    }

    public void setPPVector(Vector ppVector) {
        this.ppVector = ppVector;
    }

    public void setPPString(String ppString) {
        this.ppVector.addElement(ppString);
    }

    public void setPPVectorAbs(Vector ppVectorAbs) {
        this.ppVectorAbs = ppVectorAbs;
    }

    public void setPPStringAbs(String ppStringAbs) {
        this.ppVectorAbs.addElement(ppStringAbs);
    }

    public void clearPPVector() {
        this.ppVector.clear();
    }

    public void clearPPVectorAbs() {
        this.ppVectorAbs.clear();
    }
}

