/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.common.MyMessageBox;
import jp.advancesoft.chase.phase.PhaseInputFrame;
import jp.advancesoft.pmodel.Pmodel;
import jp.advancesoft.pmodel.PmodelException;

public class AtomicConfigReaderWriter {
    private File file;
    private PhaseInputFrame phaseinpfrm;
    private MyMessageBox mbox = new MyMessageBox();
    private PrintWriter fout;
    private final String FS = System.getProperty("file.separator");
    private final String homeDir = System.getProperty("user.home");
    private DecimalFormat formater = ConstParameters.formater;
    private int icellscheme = 0;
    private int icount = 0;
    private String Comment = new String();
    protected int NumAt;
    protected String[][] Atoms;
    protected String[][] CellVec = new String[4][3];
    protected String[][] CellVec2 = new String[2][3];
    private String a;
    private String b;
    private String c;
    private String alpha;
    private String beta;
    private String gamma;
    private String coordScheme = "internal";

    public AtomicConfigReaderWriter(PhaseInputFrame phaseinpfrm) {
        this.phaseinpfrm = phaseinpfrm;
    }

    public AtomicConfigReaderWriter() {
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean readFile(String type) {
        String str = new String();
        try {
            FileReader reader = new FileReader(this.file);
            BufferedReader br = new BufferedReader(reader);
            if (type.equals("xyz")) {
                str = br.readLine();
                str = str.trim();
                this.NumAt = Integer.parseInt(str);
                this.Comment = str = br.readLine();
                this.Atoms = new String[this.NumAt][4];
                for (int i = 0; i < this.NumAt; ++i) {
                    str = br.readLine();
                    StringTokenizer st = new StringTokenizer(str);
                    this.Atoms[i][0] = st.nextToken();
                    this.Atoms[i][1] = st.nextToken();
                    this.Atoms[i][2] = st.nextToken();
                    this.Atoms[i][3] = st.nextToken();
                }
                reader.close();
            } else if (type.equals("cif")) {
                if (!this.bootCIFParser()) {
                    return false;
                }
            } else if (type.equals("cell")) {
                this.CellVec = new String[4][3];
                this.CellVec2 = new String[2][3];
                int i = 0;
                while ((str = br.readLine()) != null) {
                    StringTokenizer st;
                    if (str.startsWith("#")) continue;
                    if (this.icellscheme == 0) {
                        st = new StringTokenizer(str);
                        this.CellVec[i][0] = st.nextToken();
                        this.CellVec[i][1] = st.nextToken();
                        this.CellVec[i][2] = st.nextToken();
                    } else if (this.icellscheme == 1) {
                        st = new StringTokenizer(str);
                        this.CellVec2[i][0] = st.nextToken();
                        this.CellVec2[i][1] = st.nextToken();
                        this.CellVec2[i][2] = st.nextToken();
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            if (this.file != null) {
                this.mbox.setText("import from " + this.file + " failed.");
                System.out.println(e);
            }
            return false;
        }
        return true;
    }

    public void writeFile(String type, String Comment) {
    }

    public void setCellScheme(int icellscheme) {
        this.icellscheme = icellscheme;
    }

    public int getCellScheme() {
        return this.icellscheme;
    }

    public void setCoordScheme(String coordScheme) {
        this.coordScheme = coordScheme;
    }

    private boolean bootCIFParser() {
        int i;
        boolean bret = true;
        String fileName = this.file.getAbsolutePath();
        System.out.println("parsing cif file... " + fileName);
        Pmodel pmodel = new Pmodel();
        try {
            pmodel.makeLattice(fileName);
        }
        catch (PmodelException exception) {
            this.mbox.setText("unsupported symmetry type");
            return false;
        }
        this.NumAt = pmodel.getNumberOfAtoms();
        this.Atoms = new String[this.NumAt][4];
        double[][] DAtom = pmodel.getInternalPosition();
        String[] Symbols = pmodel.getSymbol();
        if (this.coordScheme.equalsIgnoreCase("cartesian")) {
            DAtom = pmodel.getCartesianPosition();
        } else if (this.coordScheme.equalsIgnoreCase("internal")) {
            DAtom = pmodel.getInternalPosition();
        } else {
            System.out.println("wrong specification for 'coordScheme'");
        }
        for (int i2 = 0; i2 < this.NumAt; ++i2) {
            this.Atoms[i2][0] = Symbols[i2];
            for (int j = 0; j < 3; ++j) {
                try {
                    this.Atoms[i2][j + 1] = this.formater.format(DAtom[i2][j]);
                    continue;
                }
                catch (NumberFormatException ne) {
                    ne.printStackTrace();
                    System.out.println("failed to cast pos data; may not be a number");
                    return false;
                }
            }
        }
        double[] cellAngle = pmodel.getCellAngle();
        double[] cellLength = pmodel.getCellLength();
        double[][] cellVec = pmodel.getCellVec();
        this.CellVec2 = new String[2][3];
        for (i = 0; i < 3; ++i) {
            try {
                this.CellVec2[0][i] = this.formater.format(cellLength[i]);
                this.CellVec2[1][i] = this.formater.format(cellAngle[i]);
                continue;
            }
            catch (NumberFormatException ne) {
                ne.printStackTrace();
                System.out.println("failed to cast cell data; may not be a number");
            }
        }
        this.CellVec = new String[4][3];
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                try {
                    this.CellVec[i][j] = this.formater.format(cellVec[i][j]);
                    continue;
                }
                catch (NumberFormatException ne) {
                    ne.printStackTrace();
                    System.out.println("failed to cast cell data; may not be a number");
                    return false;
                }
            }
        }
        return true;
    }

    private void parseParsedCIF(String strRow) {
        StringTokenizer st = new StringTokenizer(strRow);
        String ident = st.nextToken();
        if (ident.equals("celllength")) {
            this.a = st.nextToken();
            this.b = st.nextToken();
            this.c = st.nextToken();
            System.out.println(this.a + " " + this.b + " " + this.c);
            return;
        }
        if (ident.equals("numAt")) {
            this.NumAt = Integer.parseInt(st.nextToken());
            this.Atoms = new String[this.NumAt][4];
            return;
        }
        if (ident.equals("cellangle")) {
            this.alpha = st.nextToken();
            this.beta = st.nextToken();
            this.gamma = st.nextToken();
            System.out.println(this.alpha + " " + this.beta + " " + this.gamma);
            return;
        }
        if (ident.equals("xyz")) {
            String element = st.nextToken();
            String x = st.nextToken();
            String y = st.nextToken();
            String z = st.nextToken();
            this.Atoms[this.icount][0] = element;
            this.Atoms[this.icount][1] = x;
            this.Atoms[this.icount][2] = y;
            this.Atoms[this.icount][3] = z;
            ++this.icount;
            System.out.println(element + " " + x + " " + y + " " + z);
            return;
        }
    }
}

