/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.mainpanel;

import java.awt.Dimension;
import javax.swing.JFrame;
import jp.advancesoft.chase.mainpanel.ChaseDesktop;
import jp.advancesoft.chase.mainpanel.ChaseFrame;
import jp.advancesoft.chase.mainpanel.ComponentListenerFrameChase;
import jp.advancesoft.chase.mainpanel.Desktop4Frame;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;

public class FrameChase
extends JFrame
implements ChaseFrame {
    private int mode = 0;
    private Dimension size;

    public FrameChase(String title, int mode, Dimension size) {
        super(title);
        this.mode = mode;
        this.size = size;
        this.initFrame();
    }

    public FrameChase(String title, Dimension size) {
        super(title);
        this.size = size;
        this.initFrame();
    }

    private void initFrame() {
        Desktop4Frame.getDesktop().add(this);
        Desktop4Frame.getDesktop().initialLocation(this, this.mode);
        int x = this.size.width;
        int y = this.size.height;
        GlobalProperties props = PropertiesManager.getGlobalProperties(6);
        String ident = FrameChase.class.getName();
        String title = this.getTitle();
        String winx = ident + "." + title + ".window_size_x";
        String winy = ident + "." + title + ".window_size_y";
        try {
            x = Integer.parseInt(props.getProperty(winx));
            y = Integer.parseInt(props.getProperty(winy));
        }
        catch (Exception exc) {
            // empty catch block
        }
        this.setSize(x, y);
        this.addComponentListener(new ComponentListenerFrameChase(this));
    }

    public ChaseDesktop getDesktop() {
        return Desktop4Frame.getDesktop();
    }

    public void selected() {
    }

    public void selected(boolean init) {
    }

    public void unselect() {
    }

    public boolean isHeavyWeight() {
        return true;
    }

    public void saveState() {
        String ident = FrameChase.class.getName();
        String title = this.getTitle();
        String winx = ident + "." + title + ".window_size_x";
        String winy = ident + "." + title + ".window_size_y";
        GlobalProperties props = PropertiesManager.getGlobalProperties(6);
        props.setProperty(winx, String.valueOf(this.getSize().width));
        props.setProperty(winy, String.valueOf(this.getSize().height));
        props.storeProperty();
    }
}

