/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.imageviewer;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import jp.advancesoft.chase.imageviewer.GraphicsPanel;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;

public class FixedImageViewer
extends InternalFrameChase {
    private String fileName = new String();
    private int geta = 80;

    public FixedImageViewer(String fileName) {
        this.fileName = fileName;
        this.createMainPanel();
    }

    public FixedImageViewer(String fileName, String title) {
        super(title);
        this.fileName = fileName;
        this.createMainPanel();
    }

    private void createMainPanel() {
        Container cont = this.getContentPane();
        cont.setLayout(new BoxLayout(cont, 1));
        JPanel panel = this.createImagePanel();
        if (panel != null) {
            cont.add(panel);
        } else {
            System.out.println("unsupported image");
        }
        cont.add(this.createButtonPanel());
    }

    private JPanel createImagePanel() {
        JPanel pimage = new JPanel();
        pimage.setLayout(new FlowLayout(1));
        try {
            BufferedImage bi = ImageIO.read(new File(this.fileName));
            int width = bi.getWidth();
            int height = bi.getHeight() + this.geta;
            GraphicsPanel graphics = new GraphicsPanel(bi);
            this.setSize(width, height);
            this.setResizable(false);
            pimage.add(graphics);
        }
        catch (Exception exc) {
            System.out.println(this.fileName + " : unsupported");
        }
        return pimage;
    }

    private JPanel createButtonPanel() {
        JPanel pbtn = new JPanel();
        JButton btnclose = new JButton("close");
        pbtn.add(btnclose);
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FixedImageViewer.this.dispose();
            }
        });
        return pbtn;
    }

    private final class MyListener
    extends WindowAdapter {
        private MyListener() {
        }

        public void windowClosing(WindowEvent event) {
            FixedImageViewer.this.dispose();
        }
    }
}

