/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.atomcoord;

import java.util.LinkedList;
import java.util.Vector;
import jp.advancesoft.chase.atomcoord.Atom;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.atomcoord.UndoRedo;
import jp.advancesoft.chase.atomcoord.UndoRedoObject;
import jp.advancesoft.chase.common.TaggedString;
import org.apache.log4j.Logger;

public class AtomList
extends LinkedList {
    private static Logger logger = Logger.getLogger((String)AtomList.class.getName());
    private UndoRedo undoRedo;
    private boolean updateUndoStack = true;
    private AtomCoords parent;

    public AtomList(AtomCoords parent) {
        this.parent = parent;
        this.undoRedo = new UndoRedo(this);
    }

    public AtomList(Atom atom, AtomCoords parent) {
        this.parent = parent;
        this.undoRedo = new UndoRedo(this);
        this.addAtom(atom);
    }

    public AtomCoords getParent() {
        return this.parent;
    }

    protected UndoRedo getUndoRedoObject() {
        return this.undoRedo;
    }

    public void addAtom(Atom atom) {
        this.undoRedo.addEntry(atom, this.size(), UndoRedoObject.ADD);
        this.addLast(atom);
    }

    public void addAtom(Atom atom, boolean addToStack) {
        if (addToStack) {
            this.addAtom(atom);
            return;
        }
        this.addLast(atom);
    }

    public void addAtom(String elementName, String[] pos) {
        Atom atom = new Atom(elementName, pos);
        this.undoRedo.addEntry(atom, this.size(), UndoRedoObject.ADD);
        this.addLast(atom);
    }

    public void addAtom(String elementName, String[] pos, TaggedString[] auxil) {
        Atom atom = new Atom(elementName, pos, auxil);
        this.undoRedo.addEntry(atom, this.size(), UndoRedoObject.ADD);
        this.addLast(atom);
    }

    public void addAtom(String elementName, String[] pos, Vector auxil) {
        Atom atom = new Atom(elementName, pos, auxil);
        this.undoRedo.addEntry(atom, this.size(), UndoRedoObject.ADD);
        this.addLast(atom);
    }

    public void setUndoCount(int count) {
        this.undoRedo.setUndoCount(count);
    }

    public boolean undoToFirst() {
        boolean ret = this.undoRedo.undoFirstEntry();
        return ret;
    }

    public void initializeUndoRedo() {
        this.undoRedo.init();
    }

    public Atom getAtomAt(int i) {
        Atom atom;
        try {
            atom = (Atom)this.get(i);
        }
        catch (Exception e) {
            logger.warn((Object)("failed to get atom at: " + i));
            return null;
        }
        return atom;
    }

    public void replaceAtomAt(int i, Atom atom) {
        logger.debug((Object)("atom now: " + this.getAtomAt(i)));
        this.undoRedo.addEntry(this.getAtomAt(i), i, UndoRedoObject.REPLACE);
        this.set(i, atom);
    }

    public void removeAtomAt(int i) {
        this.undoRedo.addEntry(this.getAtomAt(i), i, UndoRedoObject.REMOVE);
        this.remove(i);
    }

    public void removeAtom(Atom atom) {
        int index = this.indexOf(atom);
        if (index < 0) {
            index = this.size();
        }
        this.undoRedo.addEntry(atom, index, UndoRedoObject.REMOVE);
        this.remove(atom);
    }

    public boolean undo() {
        boolean ret = this.undoRedo.undo();
        logger.debug((Object)this);
        return ret;
    }

    public boolean redo() {
        boolean ret = this.undoRedo.redo();
        logger.debug((Object)this);
        return ret;
    }

    public String toString() {
        String ret = "";
        for (int i = 0; i < this.size(); ++i) {
            ret = ret + " atom no. " + i + " " + this.getAtomAt(i) + System.getProperty("line.separator");
        }
        return ret;
    }
}

