/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.atomcoord;

import java.util.Vector;
import jp.advancesoft.chase.common.TaggedString;
import org.apache.log4j.Logger;

public class Atom {
    private static Logger logger = Logger.getLogger((String)Atom.class.getName());
    private String elementName;
    private String[] pos;
    private TaggedString[] auxil;
    private String[] force;

    public Atom(String elementName, String[] pos) {
        this.elementName = elementName;
        this.pos = pos;
    }

    public Atom(String elementName, String[] pos, String[] force) {
        this.elementName = elementName;
        this.pos = pos;
        this.force = force;
    }

    public Atom(String elementName, String[] pos, TaggedString[] auxil) {
        this.elementName = elementName;
        this.pos = pos;
        this.auxil = auxil;
    }

    public Atom(String elementName, double[] pos, TaggedString[] auxil) {
        this.elementName = elementName;
        this.pos = new String[3];
        for (int i = 0; i < 3; ++i) {
            this.pos[i] = String.valueOf(pos[i]);
        }
        this.auxil = auxil;
    }

    public Atom(String elementName, double[] pos) {
        this.elementName = elementName;
        this.pos = new String[3];
        for (int i = 0; i < 3; ++i) {
            this.pos[i] = String.valueOf(pos[i]);
        }
    }

    public Atom(String elementName, String[] pos, Vector aux) {
        this.elementName = elementName;
        this.pos = pos;
        if (aux != null) {
            this.auxil = new TaggedString[aux.size()];
            aux.copyInto(this.auxil);
        }
    }

    public Atom(String elementName, double[] pos, Vector aux) {
        int i;
        this.elementName = elementName;
        this.pos = new String[3];
        for (i = 0; i < 3; ++i) {
            this.pos[i] = String.valueOf(pos[i]);
        }
        if (aux != null) {
            this.auxil = new TaggedString[aux.size()];
            for (i = 0; i < aux.size(); ++i) {
                try {
                    this.auxil[i] = (TaggedString)aux.elementAt(i);
                    continue;
                }
                catch (ClassCastException cce) {
                    // empty catch block
                }
            }
        }
    }

    public Atom getCopy() {
        String elembuf = new String(this.elementName);
        String[] posbuf = new String[3];
        for (int i = 0; i < posbuf.length; ++i) {
            posbuf[i] = new String(this.pos[i]);
        }
        TaggedString[] aubuf = null;
        if (this.auxil != null && this.auxil.length != 0) {
            aubuf = new TaggedString[this.auxil.length];
            for (int i = 0; i < aubuf.length; ++i) {
                if (this.auxil[i].getTag() == null || this.auxil[i].getValue() == null) continue;
                aubuf[i] = new TaggedString(this.auxil[i].getTag(), this.auxil[i].getValue());
            }
        }
        return new Atom(elembuf, posbuf, aubuf);
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }

    public String[] getForce() {
        return this.force;
    }

    public String[] getPos() {
        return this.pos;
    }

    public double[] getDouble() {
        double[] ret = new double[3];
        for (int i = 0; i < 3; ++i) {
            try {
                ret[i] = Double.parseDouble(this.pos[i]);
                continue;
            }
            catch (NumberFormatException nfe) {
                logger.warn((Object)"failed to get 'double' representation for atom coords.");
                return null;
            }
        }
        return ret;
    }

    public void setPos(String[] pos) {
        this.pos = pos;
    }

    public void setPos(double[] pos) {
        for (int i = 0; i < 3; ++i) {
            this.pos[i] = Double.toString(pos[i]);
        }
    }

    public TaggedString[] getAuxil() {
        return this.auxil;
    }

    public void setAuxil(TaggedString[] auxil) {
        this.auxil = auxil;
    }

    public void setAuxil(Vector aux) {
        if (aux != null) {
            this.auxil = new TaggedString[aux.size()];
            aux.copyInto(this.auxil);
        }
    }

    public String toString() {
        String ret = "";
        ret = "symbol: " + this.elementName + " x: " + this.pos[0] + " y: " + this.pos[1] + " z: " + this.pos[2];
        if (this.auxil != null) {
            for (int i = 0; i < this.auxil.length; ++i) {
                ret = ret + " " + this.auxil[i].getTag() + ": " + this.auxil[i].getValue();
            }
        }
        return ret;
    }
}

