/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.scenegraphelements.bond;

import jp.advancesoft.chase.acviewer.ACVDataManager;
import jp.advancesoft.chase.acviewer.ConfigDataManager;
import jp.advancesoft.chase.acviewer.scenegraphelements.bond.BondInfo;
import org.apache.log4j.Logger;

public class BondCalculator {
    private static Logger logger = Logger.getLogger((String)BondCalculator.class.getName());
    private int NumAt;
    private int NumBondMax;
    private int i;
    private int j;
    private int NumBond;
    private double rbond;
    private BondInfo[] bondInfo;
    private ACVDataManager mACVD;
    private ConfigDataManager mCD;
    private double[][] xyz;

    public BondCalculator() {
    }

    public BondCalculator(ACVDataManager mACVD, ConfigDataManager mCD) {
        this.mACVD = mACVD;
        this.mCD = mCD;
        this.NumAt = mCD.getNumAt();
        this.NumBondMax = this.NumAt * (this.NumAt - 1) / 2;
        this.bondInfo = new BondInfo[this.NumBondMax];
        for (int i = 0; i < this.NumBondMax; ++i) {
            this.bondInfo[i] = new BondInfo();
        }
    }

    public void calculateBond(double[][] xyz) {
        this.xyz = xyz;
        this.calcNearestNeighbor();
    }

    public BondInfo[] getBondInfo() {
        return this.bondInfo;
    }

    public int getNumBond() {
        return this.NumBond;
    }

    public int getNumBondMax() {
        return this.NumBondMax;
    }

    public int getBondIndex(int atom1, int atom2) {
        if (this.bondInfo == null) {
            return -1;
        }
        for (int i = 0; i < this.bondInfo.length; ++i) {
            int[] pair = this.bondInfo[i].getIndexPair();
            if ((pair[0] != atom1 || pair[1] != atom2) && (pair[0] != atom2 || pair[1] != atom1)) continue;
            return i;
        }
        return -1;
    }

    private void calcNearestNeighbor() {
        int jele;
        int ilabel = 0;
        int jlabel = 0;
        int BondCount = 0;
        int pairIndex = 0;
        int NumEl = this.mACVD.getNumEl();
        String[] elements = this.mCD.getElements();
        String[] elementString = new String[NumEl];
        double[] covRad = new double[NumEl];
        double lenMax = this.mCD.getLenMax();
        double bondFactor = this.mACVD.getBondFactor();
        for (jele = 0; jele < NumEl; ++jele) {
            elementString[jele] = this.mACVD.getElement()[jele];
            covRad[jele] = this.mACVD.getCovRad()[jele];
        }
        this.i = 0;
        while (this.i < this.NumAt - 1) {
            if (elements[this.i] == null || elements[this.i].trim().length() == 0) {
                logger.debug((Object)("atom " + this.i + ": void ..."));
            } else {
                for (int iele = 0; iele < NumEl; ++iele) {
                    if (!elements[this.i].equals(elementString[iele])) continue;
                    ilabel = iele;
                }
                double xi = this.xyz[this.i][0];
                double yi = this.xyz[this.i][1];
                double zi = this.xyz[this.i][2];
                this.j = this.i + 1;
                while (this.j < this.NumAt) {
                    block10: {
                        for (jele = 0; jele < NumEl; ++jele) {
                            if (elements[this.j] == null || elements[this.j].trim().length() == 0) {
                                logger.debug((Object)("atom " + this.j + ": void ..."));
                                break block10;
                            }
                            if (!elements[this.j].equals(elementString[jele])) continue;
                            jlabel = jele;
                        }
                        double xj = this.xyz[this.j][0];
                        double yj = this.xyz[this.j][1];
                        double zj = this.xyz[this.j][2];
                        double r2 = Math.pow(xi - xj, 2.0) + Math.pow(yi - yj, 2.0) + Math.pow(zi - zj, 2.0);
                        this.rbond = bondFactor * (covRad[ilabel] + covRad[jlabel]);
                        this.rbond /= lenMax;
                        this.rbond = Math.pow(this.rbond, 2.0);
                        logger.debug((Object)("rbond & r2: " + this.rbond + " " + r2));
                        double[] NearestNeighbor_ = new double[]{xi, yi, zi, xj, yj, zj};
                        logger.debug((Object)(xi + " " + yi + " " + zi + " " + xj + " " + yj + " " + zj));
                        this.bondInfo[pairIndex].addBondInfo(this.i, this.j, NearestNeighbor_);
                        if (r2 < this.rbond) {
                            this.bondInfo[pairIndex].isValid(true);
                            ++BondCount;
                        } else {
                            this.bondInfo[pairIndex].isValid(false);
                        }
                        ++pairIndex;
                    }
                    ++this.j;
                }
            }
            ++this.i;
        }
        this.NumBond = BondCount;
    }
}

