/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer;

import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JPanel;
import javax.vecmath.Vector3f;
import jp.advancesoft.chase.acviewer.ACVDataManager;
import jp.advancesoft.chase.acviewer.ConfigDataManager;
import jp.advancesoft.chase.acviewer.MainPanel;
import jp.advancesoft.chase.acviewer.NewElementCreater;
import jp.advancesoft.chase.acviewer.mouselistener.MyMouseRotate;
import jp.advancesoft.chase.acviewer.mouselistener.MyMouseTranslate;
import jp.advancesoft.chase.acviewer.scenegraphelements.AtomPicker;
import jp.advancesoft.chase.acviewer.scenegraphelements.SceneGraphElementCreator;
import jp.advancesoft.chase.acviewer.scenegraphelements.TGAtom;
import org.apache.log4j.Logger;

public class Show3D {
    private static Logger logger = Logger.getLogger((String)Show3D.class.getName());
    private JPanel panel;
    private MainPanel mp;
    private ACVDataManager mACVD;
    private ConfigDataManager mCD;
    private GraphicsConfiguration config;
    private Container cont;
    private int NumAt;
    private int i;
    private int NumBond;
    private TGAtom tgatom;
    private TransformGroup objTransformAxis;
    private Transform3D trans3d;
    private Transform3D trans3dAxis;
    private Transform3D translateorigin;
    private int numNewElements = 0;
    private int lastNumAt;
    private int[] selectedAts;

    public Show3D(MainPanel parent) {
        this.mp = parent;
        this.mACVD = parent.getACV();
        this.mCD = parent.getCD();
        this.tgatom = new TGAtom();
        this.translateorigin = new Transform3D();
        this.translateorigin.set(new Vector3f(-0.8f, -0.7f, 0.0f));
        this.objTransformAxis = new TransformGroup(this.translateorigin);
        this.objTransformAxis.setCapability(18);
        this.objTransformAxis.setCapability(17);
        this.trans3d = new Transform3D();
        this.trans3dAxis = new Transform3D();
        this.objTransformAxis.getTransform(this.trans3dAxis);
    }

    public void setmACVD(ACVDataManager mACVD) {
        this.mACVD = mACVD;
    }

    public ACVDataManager getACV() {
        return this.mACVD;
    }

    public ConfigDataManager getCD() {
        return this.mCD;
    }

    public void storeState() {
        this.storeTrans();
        this.storeSelected();
        this.initTGAtom();
    }

    private void storeTrans() {
        this.tgatom.getTransform(this.trans3d);
        this.objTransformAxis.getTransform(this.trans3dAxis);
    }

    private void storeSelected() {
        this.lastNumAt = this.tgatom.getLastNumAt();
        this.selectedAts = this.tgatom.getSelectedAtomsIndex();
    }

    private void initTGAtom() {
        this.tgatom = new TGAtom();
        this.tgatom.setCapability(18);
        this.tgatom.setCapability(17);
        this.tgatom.setCapability(1);
        this.objTransformAxis = new TransformGroup(this.translateorigin);
        this.objTransformAxis.setCapability(18);
        this.objTransformAxis.setCapability(17);
    }

    public void createNewElement() {
        NewElementCreater creater = new NewElementCreater(this.mACVD, this.mCD);
        this.numNewElements = creater.createNewElement();
    }

    public BranchGroup getObjRoot() {
        return this.createObjRoot();
    }

    protected void doPost() {
        this.tgatom.restoreSelection(this.lastNumAt, this.selectedAts);
    }

    private BranchGroup createObjRoot() {
        SceneGraphElementCreator creator = new SceneGraphElementCreator(this.mACVD, this.mCD);
        BranchGroup objRoot = new BranchGroup();
        objRoot.setCapability(17);
        objRoot.setCapability(12);
        objRoot.setCapability(13);
        objRoot.setCapability(14);
        AtomPicker picker = new AtomPicker(this.mACVD.getParent().getCanvas(), objRoot, (Bounds)new BoundingSphere());
        this.tgatom.setPicker(picker);
        this.tgatom.setSceneGraphElementCreator(creator);
        creator.setTGAtom(this.tgatom);
        this.tgatom.setParentFrame(this.mp);
        this.tgatom.create();
        this.tgatom.setTransform(this.trans3d);
        objRoot.addChild((Node)this.tgatom);
        MyMouseRotate myMouseRotate = new MyMouseRotate();
        myMouseRotate.setTransformGroup(this.tgatom);
        myMouseRotate.setSchedulingBounds((Bounds)new BoundingSphere());
        objRoot.addChild((Node)myMouseRotate);
        MyMouseTranslate myMouseTranslate = new MyMouseTranslate();
        myMouseTranslate.setTransformGroup(this.tgatom);
        myMouseTranslate.setSchedulingBounds((Bounds)new BoundingSphere());
        objRoot.addChild((Node)myMouseTranslate);
        MouseZoom myMouseZoom = new MouseZoom();
        myMouseZoom.setTransformGroup((TransformGroup)this.tgatom);
        myMouseZoom.setSchedulingBounds((Bounds)new BoundingSphere());
        objRoot.addChild((Node)myMouseZoom);
        this.objTransformAxis = creator.getSceneGraphElement(3);
        this.objTransformAxis.setTransform(this.trans3dAxis);
        MyMouseRotate myMouseRotateAxis = new MyMouseRotate();
        myMouseRotateAxis.setTransformGroup(this.objTransformAxis);
        myMouseRotateAxis.setSchedulingBounds((Bounds)new BoundingSphere());
        objRoot.addChild((Node)myMouseRotateAxis);
        if (this.mACVD.getLegend()) {
            objRoot.addChild((Node)creator.getSceneGraphElement(4));
        }
        if (this.mACVD.getAxis()) {
            objRoot.addChild((Node)this.objTransformAxis);
        }
        objRoot.addChild((Node)creator.getSceneGraphElement(5));
        objRoot.addChild((Node)creator.getSceneGraphElement(6));
        return objRoot;
    }

    public TransformGroup getTGAtom() {
        return this.tgatom;
    }

    public TransformGroup getTGAxis() {
        return this.objTransformAxis;
    }

    public void setTransform(Transform3D transform) {
        Transform3D at = new Transform3D();
        this.tgatom.getTransform(at);
        at.mul(transform);
        this.tgatom.setTransform(at);
        Transform3D axi = new Transform3D();
        this.objTransformAxis.getTransform(axi);
        axi.mul(transform);
        this.objTransformAxis.setTransform(axi);
    }
}

