/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer;

import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.DepthComponentFloat;
import javax.media.j3d.GraphicsContext3D;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.media.j3d.VirtualUniverse;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.vecmath.Point3f;
import jp.advancesoft.chase.acviewer.ACVButtons;
import jp.advancesoft.chase.acviewer.ACVData;
import jp.advancesoft.chase.acviewer.ACVDataManager;
import jp.advancesoft.chase.acviewer.ACVMenuBar;
import jp.advancesoft.chase.acviewer.ChaseCanvas3D;
import jp.advancesoft.chase.acviewer.ConfigData;
import jp.advancesoft.chase.acviewer.ConfigDataManager;
import jp.advancesoft.chase.acviewer.PluginParser;
import jp.advancesoft.chase.acviewer.RectangleCreator;
import jp.advancesoft.chase.acviewer.Show3D;
import jp.advancesoft.chase.acviewer.Stoppable;
import jp.advancesoft.chase.acviewer.mouselistener.ACVMouseMotionListener;
import jp.advancesoft.chase.acviewer.scenegraphelements.AtomObject;
import jp.advancesoft.chase.acviewer.unitcell.UnitCellOperations;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.mainpanel.Desktop;
import jp.advancesoft.chase.mainpanel.FrameChase;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;
import org.freehep.util.export.ExportDialog;

public class MainPanel
extends FrameChase
implements ConfigData {
    private static Logger logger = Logger.getLogger((String)MainPanel.class.getName());
    private ACVDataManager mACVD;
    private ConfigDataManager mCD;
    private ChaseCanvas3D canvas3d;
    private Show3D s3d;
    private SimpleUniverse simpleU;
    private BranchGroup objRoot_wk;
    private JDesktopPane desktop;
    private String[][] xyz;
    private String[][] cellvec;
    private String[] label;
    private int NumAt;
    private Vector editprefs = new Vector();
    private boolean cellorigin;
    private Vector frames;
    private String parentDir = System.getProperty("user.home");
    private Container cont;
    private int insetx;
    private int insety;
    private JPanel panel;
    private ACVData acvdata;
    private GlobalProperties propacv = PropertiesManager.getGlobalProperties(1);
    private RectangleCreator rectangleCreator;
    private UnitCellOperations unitcell;
    private PluginParser plugparser;
    private boolean doRedraw = true;

    public MainPanel(ACVData acvdata) {
        super("AtomicConfigurationViewer", new Dimension(512, 512));
        this.acvdata = acvdata;
        this.frames = acvdata.getFrames();
        this.parentDir = acvdata.getParentDir();
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
    }

    public MainPanel(Vector frames, String parentDir) {
        super("AtomicConfigurationViewer", new Dimension(512, 512));
        this.frames = frames;
        if (parentDir != null) {
            this.parentDir = parentDir;
        }
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
    }

    public MainPanel(Vector frames) {
        super("AtomicConfigurationViewer", new Dimension(512, 512));
        this.frames = frames;
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
    }

    public GlobalProperties getACVProperties() {
        return this.propacv;
    }

    protected void stopAllAnimations() {
        if (this.editprefs != null) {
            int num = this.editprefs.size();
            for (int i = 0; i < num; ++i) {
                Object obj = this.editprefs.get(i);
                if (!(obj instanceof Stoppable)) continue;
                ((Stoppable)obj).stop();
            }
        }
    }

    public BranchGroup getRootBranch() {
        return this.objRoot_wk;
    }

    public void doUnitCell() {
        boolean ab = new Boolean(this.propacv.getProperty("add_boundary_atoms_ab"));
        boolean ac = new Boolean(this.propacv.getProperty("add_boundary_atoms_ac"));
        boolean bc = new Boolean(this.propacv.getProperty("add_boundary_atoms_bc"));
        boolean pack = new Boolean(this.propacv.getProperty("pack_atoms_into_unit_cell"));
        String seps = this.propacv.getProperty("pack_atoms_into_unit_cell_eps");
        double eps = -1.0;
        if (seps != null) {
            try {
                eps = Double.parseDouble(seps);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if (this.unitcell == null) {
            this.unitcell = new UnitCellOperations(this.frames, this);
        }
        if (eps >= 0.0) {
            this.unitcell.setEps(eps);
        }
        this.unitcell.setAddBoundaryAtoms(ab, ac, bc);
        this.unitcell.setPackAtomsIntoUnitCell(pack);
        this.doRedraw(false);
        this.unitcell.processFrame();
        this.doRedraw(true);
    }

    public UnitCellOperations getUnitCellManipulator() {
        return this.unitcell;
    }

    private void init() {
        this.mACVD = new ACVDataManager();
        this.mACVD.setParent(this);
        GlobalProperties prop = PropertiesManager.getGlobalProperties(3);
        this.mACVD.setElementInfoFile(prop.getFileName());
        this.desktop = Desktop.getDesktop();
        this.doUnitCell();
        this.mCD = new ConfigDataManager((AtomCoords)this.frames.get(0));
        this.mCD.register(this);
        this.mCD.getAtomCoords().getAtomList().initializeUndoRedo();
        this.setLabel();
        this.cont = this.getContentPane();
        this.objRoot_wk = new BranchGroup();
        this.objRoot_wk.setCapability(17);
        this.objRoot_wk.setCapability(12);
        this.objRoot_wk.setCapability(13);
        this.objRoot_wk.setCapability(14);
        this.s3d = new Show3D(this);
        this.canvas3d = new ChaseCanvas3D(SimpleUniverse.getPreferredConfiguration());
        this.canvas3d.setDoubleBufferEnable(true);
        this.simpleU = new SimpleUniverse((Canvas3D)this.canvas3d);
        this.rectangleCreator = new RectangleCreator(this, 0.0f, 0.0f);
        this.simpleU.getViewingPlatform().setPlatformGeometry(this.rectangleCreator.getPlatformGeometry(0.0f, 0.0f));
        this.rectangleCreator.detach();
        this.simpleU.getViewingPlatform().setNominalViewingTransform();
        Panel panel = new Panel();
        panel.setLayout(new BoxLayout(panel, 1));
        ACVButtons btns = new ACVButtons(this);
        panel.add(btns);
        panel.add((Component)((Object)this.canvas3d));
        this.cont.setLayout(new BorderLayout());
        this.cont.add(panel);
        this.calculateInsets();
        ACVMouseMotionListener mouseMotionListener = new ACVMouseMotionListener(this);
        this.canvas3d.addMouseMotionListener(mouseMotionListener);
        this.canvas3d.addMouseListener(mouseMotionListener);
    }

    public PluginParser getPluginParser() {
        if (this.plugparser == null) {
            this.plugparser = new PluginParser(this);
        }
        return this.plugparser;
    }

    public void configDataUpdate() {
        this.redraw();
    }

    public void configDataUpdate(boolean boo) {
        this.redraw();
    }

    public boolean needsUpdate() {
        return true;
    }

    private void createScene() {
        this.canvas3d = new ChaseCanvas3D(SimpleUniverse.getPreferredConfiguration());
        this.canvas3d.setDoubleBufferEnable(true);
        this.simpleU = new SimpleUniverse((Canvas3D)this.canvas3d);
        this.simpleU.getViewingPlatform().setNominalViewingTransform();
        this.panel.removeAll();
        this.panel.add((Component)((Object)this.canvas3d));
    }

    private void calculateInsets() {
        Dimension canvdim = this.canvas3d.getSize();
        Dimension dim = this.getSize();
        this.insetx = dim.width - canvdim.width;
        this.insety = dim.height - canvdim.height;
    }

    public boolean isHeavyWeight() {
        return true;
    }

    public Show3D getScene() {
        return this.s3d;
    }

    public Vector getFramesAC() {
        return this.frames;
    }

    public SimpleUniverse getUniverse() {
        return this.simpleU;
    }

    public void destroy() {
        this.removeFromDesktop();
        this.removeAll();
        if (this.editprefs != null) {
            for (int i = 0; i < this.editprefs.size(); ++i) {
                Container window;
                Object editor = this.editprefs.get(i);
                if (editor instanceof JInternalFrame) {
                    window = (JInternalFrame)this.editprefs.get(i);
                    if (window == null) continue;
                    ((JInternalFrame)window).dispose();
                    continue;
                }
                if (!(editor instanceof JFrame) || (window = (JFrame)this.editprefs.get(i)) == null) continue;
                ((Window)window).dispose();
            }
        }
        this.dispose();
    }

    public void initializeRectangle(float fx, float fy) {
        this.rectangleCreator.setLocation(fx, fy);
    }

    public void updateRectangle(float w, float h) {
        this.rectangleCreator.updateRectangle(w, h);
    }

    public void finalizeRectangle() {
        this.rectangleCreator.detach();
    }

    private void removeFromDesktop() {
        this.objRoot_wk.detach();
        this.objRoot_wk = null;
        try {
            this.canvas3d.stopRenderer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.canvas3d = null;
        this.simpleU.removeAllLocales();
        this.simpleU.getViewer().setViewingPlatform(null);
        this.simpleU.getViewer().getView().removeCanvas3D((Canvas3D)this.canvas3d);
        this.simpleU.cleanup();
        this.simpleU = null;
    }

    public void setLabel() {
        this.label = new String[this.mCD.getNumAt()];
        for (int i = 0; i < this.mCD.getNumAt(); ++i) {
            this.label[i] = Integer.toString(i + 1);
        }
        this.mACVD.setLabel(this.label);
    }

    public final void display3D() throws Exception {
        this.s3d.createNewElement();
        this.objRoot_wk = new BranchGroup();
        this.objRoot_wk.setCapability(17);
        this.objRoot_wk.setCapability(12);
        this.objRoot_wk.setCapability(13);
        this.objRoot_wk.setCapability(14);
        this.objRoot_wk = this.s3d.getObjRoot();
        this.objRoot_wk.compile();
        VirtualUniverse.setJ3DThreadPriority((int)Thread.currentThread().getPriority());
        this.simpleU.addBranchGraph(this.objRoot_wk);
        this.setVisible(true);
    }

    public ACVData getData() {
        return this.acvdata;
    }

    public ACVDataManager getACV() {
        return this.mACVD;
    }

    public ConfigDataManager getCD() {
        return this.mCD;
    }

    public Vector getDisposeOnExit() {
        return this.editprefs;
    }

    public void addDisposeOnExit(Window window) {
        this.editprefs.addElement(window);
    }

    public void addDisposeOnExit(InternalFrameChase window) {
        this.editprefs.addElement(window);
    }

    public void export(String fileName) throws IOException {
        this.doExport(fileName);
    }

    public void export() throws IOException {
        this.doExport("");
    }

    public void selectedRow(int row) {
        if (row < 0) {
            return;
        }
        Enumeration enu = this.s3d.getTGAtom().getAllChildren();
        while (enu.hasMoreElements()) {
            Object node = enu.nextElement();
            if (!(node instanceof AtomObject)) continue;
            AtomObject obj = (AtomObject)node;
            obj.unSelect();
            if (!obj.getID().equals(Integer.toString(row + 1))) continue;
            logger.debug((Object)("foobar : caught atomobject: " + obj.getID()));
            obj.setSelected();
        }
        this.calculateInsets();
    }

    private BufferedImage createImage() {
        int width = this.canvas3d.getSize().width;
        int height = this.canvas3d.getSize().height;
        BufferedImage bi = new BufferedImage(width, height, 1);
        ImageComponent2D ic2d = new ImageComponent2D(1, bi);
        DepthComponentFloat dcf = new DepthComponentFloat(width, height);
        Raster readRaster = new Raster(new Point3f(0.0f, 0.0f, 0.0f), 1, 0, 0, width, height, ic2d, (DepthComponent)dcf);
        GraphicsContext3D gc3d = this.canvas3d.getGraphicsContext3D();
        gc3d.flush(true);
        gc3d.readRaster(readRaster);
        ImageComponent2D ic = readRaster.getImage();
        return ic.getImage();
    }

    public BufferedImage getImage() {
        return this.createImage();
    }

    private void doExport(String fileName) throws IOException {
        BufferedImage image = this.createImage();
        if (fileName.trim().length() == 0) {
            int width = this.canvas3d.getSize().width;
            int height = this.canvas3d.getSize().height;
            ImageIcon icon = new ImageIcon(image);
            JLabel label = new JLabel(icon);
            label.setSize(width, height);
            ExportDialog exportD = new ExportDialog();
            Properties prop = new Properties();
            prop.setProperty("org.freehep.util.export.ExportDialog.SaveAsFile", this.parentDir + File.separator + "atomic_config");
            exportD.setUserProperties(prop);
            exportD.showExportDialog((Component)this, "export view as ...", (Component)label, "atomic_config");
        } else {
            ImageIO.write((RenderedImage)image, "jpg", new File(fileName));
            logger.info((Object)("exported image to file: " + fileName));
        }
    }

    public Canvas3D getCanvas() {
        return this.canvas3d;
    }

    public void doRedraw(boolean doRedraw) {
        this.doRedraw = doRedraw;
    }

    public boolean doRedraw() {
        return this.doRedraw;
    }

    public void redraw() {
        if (!this.doRedraw) {
            return;
        }
        logger.debug((Object)"redrawing the whole panel ...");
        this.s3d.setmACVD(this.mACVD);
        this.s3d.storeState();
        BranchGroup objRoot_wk_new = this.s3d.getObjRoot();
        if (this.objRoot_wk == null || objRoot_wk_new == null) {
            return;
        }
        this.simpleU.getLocale().replaceBranchGraph(this.objRoot_wk, objRoot_wk_new);
        this.objRoot_wk = objRoot_wk_new;
        this.s3d.doPost();
        this.calculateInsets();
    }

    public void heavyRedraw(boolean always) {
        if (!always && this.frames.size() == 1) {
            this.redraw();
            return;
        }
        logger.info((Object)"redrawing the whole scene...");
        this.removeFromDesktop();
        this.init();
        try {
            this.display3D();
        }
        catch (Exception exc) {
            logger.error((Object)"failed 'heavy' redraw");
        }
    }
}

