/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.share.object;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.share.ShareObject;

public class ShareField
extends ShareObject {
    private transient Field mField;
    private transient String mNodeName;

    public ShareField() {
        this.setField(null);
        this.setNodeName(null);
    }

    public ShareField(Field field) {
        this();
        this.setField(field);
    }

    public void setField(Field field) {
        Node node;
        this.mField = field;
        if (field != null && (node = field.getNode()) != null) {
            String nodeName = node.getName();
            this.setNodeName(nodeName);
        }
    }

    public Field getField() {
        return this.mField;
    }

    public void setNodeName(String name) {
        this.mNodeName = name;
    }

    public String getNodeName() {
        return this.mNodeName;
    }

    @Override
    public boolean writeData(ObjectOutputStream out) throws IOException {
        String nodeName = this.getNodeName();
        Field field = this.getField();
        out.writeObject(nodeName);
        out.writeObject(field);
        return true;
    }

    @Override
    public boolean readData(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String nodeName = (String)in.readObject();
        Field field = (Field)in.readObject();
        this.setNodeName(nodeName);
        this.setField(field);
        return true;
    }

    @Override
    public boolean update(SceneGraph sg) {
        if (sg == null) {
            return false;
        }
        Field srcField = this.getField();
        String srcFieldName = srcField.getName();
        String dstNodeName = this.getNodeName();
        Node dstNode = sg.findNode(dstNodeName);
        if (dstNode == null) {
            return false;
        }
        Field dstField = dstNode.findField(srcFieldName);
        if (dstField == null) {
            return false;
        }
        dstField.setValue(srcField, false);
        return true;
    }
}

