/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.share;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import org.cybergarage.x3d.share.ShareObject;
import org.cybergarage.x3d.share.ShareWorld;
import org.cybergarage.x3d.share.ShareWorldClientSocket;
import org.cybergarage.x3d.util.Debug;

public class ShareWorldServer
extends ShareWorld {
    private ServerSocket serverSocket;
    Vector<ShareWorldClientSocket> clientSocketList = new Vector();

    public ShareWorldServer(int port) {
        ServerSocket serverSocket = this.createServerSocket(port);
        this.setServerSocket(serverSocket);
    }

    public ShareWorldServer() {
        this(ShareWorldServer.getDefaultSeverSocketPort());
    }

    private ServerSocket createServerSocket(int port) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return serverSocket;
    }

    private void setServerSocket(ServerSocket socket) {
        this.serverSocket = socket;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public int getNClientSockets() {
        return this.clientSocketList.size();
    }

    public void addClientSocket(ShareWorldClientSocket clientSocket) {
        this.clientSocketList.add(clientSocket);
    }

    public void removeClientSocket(ShareWorldClientSocket clientSocket) {
        this.clientSocketList.remove(clientSocket);
    }

    public ShareWorldClientSocket getClientSocket(int n) {
        return this.clientSocketList.get(n);
    }

    public ShareWorldClientSocket[] getClientSockets() {
        ShareWorldClientSocket[] socs = new ShareWorldClientSocket[this.clientSocketList.size()];
        this.clientSocketList.toArray(socs);
        return socs;
    }

    public void distributeShareObject(ShareWorldClientSocket srcClient, ShareObject shareObject) {
        ShareWorldClientSocket[] clientSocket = this.getClientSockets();
        int nCliendSockets = clientSocket.length;
        int n = 0;
        while (n < nCliendSockets) {
            ShareWorldClientSocket client = clientSocket[n];
            if (client != srcClient && !client.postShreObject(shareObject)) {
                this.removeClientSocket(client);
            }
            ++n;
        }
    }

    @Override
    public void execute() {
        ServerSocket serverSocket = this.getServerSocket();
        try {
            Debug.message("accepting .... ");
            Socket socket = serverSocket.accept();
            Debug.message("  InetAddress = " + socket.getInetAddress());
            Debug.message("  port = " + socket.getPort());
            ShareWorldClientSocket clientSocket = new ShareWorldClientSocket(this, socket);
            this.addClientSocket(clientSocket);
            clientSocket.executeThread();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

