/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.parser.wavefront;

import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.IndexedFaceSetNode;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.ShapeNode;
import org.cybergarage.x3d.parser.wavefront.OBJParserConstants;
import org.cybergarage.x3d.parser.wavefront.OBJParserTokenManager;
import org.cybergarage.x3d.parser.wavefront.ParseException;
import org.cybergarage.x3d.parser.wavefront.SimpleCharStream;
import org.cybergarage.x3d.parser.wavefront.Token;

public class OBJParser
implements OBJParserConstants {
    private ShapeNode mShapeNode;
    private IndexedFaceSetNode mIdxFaceSetNode;
    public OBJParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[12];
    private final int[] jj_la1_0 = new int[]{786432, 257984, 257984, 3840, 786432, 4096, 262144, 262144, 786432, 49152, 786432, 196608};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public OBJParser() {
    }

    public void initialize() {
        this.mShapeNode = new ShapeNode();
        this.mIdxFaceSetNode = new IndexedFaceSetNode();
        this.mShapeNode.addChildNode(this.mIdxFaceSetNode);
        this.mIdxFaceSetNode.addChildNode(new CoordinateNode());
        this.mIdxFaceSetNode.addChildNode(new NormalNode());
        this.mIdxFaceSetNode.setNormalPerVertex(true);
    }

    public ShapeNode getShapeNode() {
        return this.mShapeNode;
    }

    private IndexedFaceSetNode getIndexedFaceSetNode() {
        return this.mIdxFaceSetNode;
    }

    private CoordinateNode getCoordinateNode() {
        return this.getIndexedFaceSetNode().getCoordinateNodes();
    }

    private NormalNode getNormalNode() {
        return this.getIndexedFaceSetNode().getNormalNodes();
    }

    private void addCoodinate(float x, float y, float z) {
        this.getCoordinateNode().addPoint(x, y, z);
    }

    private void addNormal(float x, float y, float z) {
        this.getNormalNode().addVector(x, y, z);
    }

    private void addCoordIndex(int index) {
        this.getIndexedFaceSetNode().addCoordIndex(index);
    }

    public int getNCoordIndices() {
        return this.getIndexedFaceSetNode().getNCoordIndices();
    }

    public int getCoordIndex(int n) {
        return this.getIndexedFaceSetNode().getCoordIndex(n);
    }

    private void addNormalIndex(int index) {
        this.getIndexedFaceSetNode().addNormalIndex(index);
    }

    public int getNNormalIndices() {
        return this.getIndexedFaceSetNode().getNNormalIndices();
    }

    public int getNormalIndex(int n) {
        return this.getIndexedFaceSetNode().getNormalIndex(n);
    }

    private void addTexCoordIndex(int index) {
        this.getIndexedFaceSetNode().addTexCoordIndex(index);
    }

    public int getNTexCoordIndices() {
        return this.getIndexedFaceSetNode().getNTexCoordIndices();
    }

    public int getTexCoordIndex(int n) {
        return this.getIndexedFaceSetNode().getTexCoordIndex(n);
    }

    public final int IDToken() throws ParseException {
        Token t = this.jj_consume_token(18);
        return Integer.parseInt(t.image);
    }

    public final float FloatToken() throws ParseException {
        Token t = this.jj_consume_token(20);
        Float floatObj = new Float(t.image);
        return floatObj.floatValue();
    }

    public final String NameToken() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                Token t = this.jj_consume_token(18);
                return t.image;
            }
            case 19: {
                Token t = this.jj_consume_token(19);
                return t.image;
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void OBJ() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block3;
                }
            }
            this.OBJElement();
        }
    }

    public final void OBJElement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.Vertex();
                break;
            }
            case 7: {
                this.VertexNormal();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.Grouping();
                break;
            }
            case 13: {
                this.Face();
                break;
            }
            case 16: 
            case 17: {
                this.Material();
                break;
            }
            case 14: 
            case 15: {
                this.TexMap();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Vertex() throws ParseException {
        this.jj_consume_token(6);
        float x = this.FloatToken();
        float y = this.FloatToken();
        float z = this.FloatToken();
        this.addCoodinate(x, y, z);
    }

    public final void VertexNormal() throws ParseException {
        this.jj_consume_token(7);
        float x = this.FloatToken();
        float y = this.FloatToken();
        float z = this.FloatToken();
        this.addNormal(x, y, z);
    }

    public final void Grouping() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.Group();
                break;
            }
            case 9: {
                this.SmoothingGroup();
                break;
            }
            case 10: {
                this.MergingGroup();
                break;
            }
            case 11: {
                this.ObjectName();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Group() throws ParseException {
        this.jj_consume_token(8);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: 
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            String string = this.NameToken();
        }
    }

    public final void SmoothingGroup() throws ParseException {
        this.jj_consume_token(9);
        String groupName = this.NameToken();
    }

    public final void MergingGroup() throws ParseException {
        this.jj_consume_token(10);
        String groupName = this.NameToken();
    }

    public final void ObjectName() throws ParseException {
        this.jj_consume_token(11);
        String objName = this.NameToken();
    }

    public final void VertexIndex() throws ParseException {
        int v = -1;
        int t = -1;
        int n = -1;
        v = this.IDToken();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 12: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(12);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 18: {
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        break block7;
                    }
                }
                t = this.IDToken();
            }
            this.jj_consume_token(12);
            n = this.IDToken();
        }
        if (v != -1) {
            this.addCoordIndex(v - 1);
        }
        if (t != -1) {
            this.addTexCoordIndex(t - 1);
        }
        if (n != -1) {
            this.addNormalIndex(n - 1);
        }
    }

    public final void Face() throws ParseException {
        int idx;
        int nTexCoordIndices;
        int idx2;
        int nNormalIndices;
        int idx3;
        this.jj_consume_token(13);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.VertexIndex();
        }
        int nCoordIndices = this.getNCoordIndices();
        if (nCoordIndices > 0 && (idx3 = this.getCoordIndex(nCoordIndices - 1)) != -1) {
            this.addCoordIndex(-1);
        }
        if ((nNormalIndices = this.getNNormalIndices()) > 0 && (idx2 = this.getNormalIndex(nNormalIndices - 1)) != -1) {
            this.addNormalIndex(-1);
        }
        if ((nTexCoordIndices = this.getNTexCoordIndices()) > 0 && (idx = this.getTexCoordIndex(nTexCoordIndices - 1)) != -1) {
            this.addTexCoordIndex(-1);
        }
    }

    public final void TexMap() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                String mapName = this.NameToken();
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 18: 
                        case 19: {
                            break;
                        }
                        default: {
                            this.jj_la1[8] = this.jj_gen;
                            break block0;
                        }
                    }
                    String string = this.NameToken();
                }
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Material() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                String matName = this.NameToken();
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 18: 
                        case 19: {
                            break;
                        }
                        default: {
                            this.jj_la1[10] = this.jj_gen;
                            break block0;
                        }
                    }
                    String string = this.NameToken();
                }
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Input() throws ParseException {
        this.OBJ();
        this.jj_consume_token(0);
    }

    public OBJParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new OBJParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 12) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 12) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public OBJParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new OBJParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 12) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 12) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public OBJParser(OBJParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 12) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(OBJParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 12) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[22];
        int i = 0;
        while (i < 22) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 12) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 22) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

