/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFMatrix;
import org.cybergarage.x3d.field.SFRotation;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.BoundedGroupingNode;
import org.cybergarage.x3d.node.Node;

public class TransformNode
extends BoundedGroupingNode {
    private String translationFieldName = "translation";
    private String scaleFieldName = "scale";
    private String centerFieldName = "center";
    private String rotationFieldName = "rotation";
    private String scaleOrientationFieldName = "scaleOrientation";
    private SFVec3f translationField;
    private SFVec3f scaleField;
    private SFVec3f centerField;
    private SFRotation rotationField;
    private SFRotation scaleOrientationField;

    public TransformNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.TRANSFORM);
        this.translationField = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.translationField.setName(this.translationFieldName);
        this.addExposedField(this.translationField);
        this.scaleField = new SFVec3f(1.0f, 1.0f, 1.0f);
        this.scaleField.setName(this.scaleFieldName);
        this.addExposedField(this.scaleField);
        this.centerField = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.centerField.setName(this.centerFieldName);
        this.addExposedField(this.centerField);
        this.rotationField = new SFRotation(0.0f, 0.0f, 1.0f, 0.0f);
        this.rotationField.setName(this.rotationFieldName);
        this.addExposedField(this.rotationField);
        this.scaleOrientationField = new SFRotation(0.0f, 0.0f, 1.0f, 0.0f);
        this.scaleOrientationField.setName(this.scaleOrientationFieldName);
        this.addExposedField(this.scaleOrientationField);
    }

    public TransformNode(TransformNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFVec3f getTranslationField() {
        if (!this.isInstanceNode()) {
            return this.translationField;
        }
        return (SFVec3f)this.getExposedField(this.translationFieldName);
    }

    public void setTranslation(float[] value) {
        this.getTranslationField().setValue(value);
    }

    public void setTranslation(float x, float y, float z) {
        this.getTranslationField().setValue(x, y, z);
    }

    public void setTranslation(String value) {
        this.getTranslationField().setValue(value);
    }

    public void getTranslation(float[] value) {
        this.getTranslationField().getValue(value);
    }

    public void addTranslation(float[] value) {
        this.getTranslationField().add(value);
    }

    public void addTranslation(float x, float y, float z) {
        this.getTranslationField().add(x, y, z);
    }

    public SFVec3f getScaleField() {
        if (!this.isInstanceNode()) {
            return this.scaleField;
        }
        return (SFVec3f)this.getExposedField(this.scaleFieldName);
    }

    public void setScale(float[] value) {
        this.getScaleField().setValue(value);
    }

    public void setScale(float x, float y, float z) {
        this.getScaleField().setValue(x, y, z);
    }

    public void setScale(String value) {
        this.getScaleField().setValue(value);
    }

    public void getScale(float[] value) {
        this.getScaleField().getValue(value);
    }

    public void addScale(float[] value) {
        this.getScaleField().add(value);
    }

    public void addScale(float x, float y, float z) {
        this.getScaleField().add(x, y, z);
    }

    public SFVec3f getCenterField() {
        if (!this.isInstanceNode()) {
            return this.centerField;
        }
        return (SFVec3f)this.getExposedField(this.centerFieldName);
    }

    public void setCenter(float[] value) {
        this.getCenterField().setValue(value);
    }

    public void setCenter(float x, float y, float z) {
        this.getCenterField().setValue(x, y, z);
    }

    public void setCenter(String value) {
        this.getCenterField().setValue(value);
    }

    public void getCenter(float[] value) {
        this.getCenterField().getValue(value);
    }

    public void addCenter(float[] value) {
        this.getCenterField().add(value);
    }

    public void addCenter(float x, float y, float z) {
        this.getCenterField().add(x, y, z);
    }

    public SFRotation getRotationField() {
        if (!this.isInstanceNode()) {
            return this.rotationField;
        }
        return (SFRotation)this.getExposedField(this.rotationFieldName);
    }

    public void setRotation(float[] value) {
        this.getRotationField().setValue(value);
    }

    public void setRotation(float x, float y, float z, float w) {
        this.getRotationField().setValue(x, y, z, w);
    }

    public void setRotation(String value) {
        this.getRotationField().setValue(value);
    }

    public void getRotation(float[] value) {
        this.getRotationField().getValue(value);
    }

    public void addRotation(float[] value) {
        this.getRotationField().add(value);
    }

    public void addRotation(float x, float y, float z, float w) {
        this.getRotationField().add(x, y, z, w);
    }

    public SFRotation getScaleOrientationField() {
        if (!this.isInstanceNode()) {
            return this.scaleOrientationField;
        }
        return (SFRotation)this.getExposedField(this.scaleOrientationFieldName);
    }

    public void setScaleOrientation(float[] value) {
        this.getScaleOrientationField().setValue(value);
    }

    public void setScaleOrientation(float x, float y, float z, float w) {
        this.getScaleOrientationField().setValue(x, y, z, w);
    }

    public void setScaleOrientation(String value) {
        this.getScaleOrientationField().setValue(value);
    }

    public void getScaleOrientation(float[] value) {
        this.getScaleOrientationField().getValue(value);
    }

    public void addScaleOrientation(float[] value) {
        this.getScaleOrientationField().add(value);
    }

    public void addScaleOrientation(float x, float y, float z, float w) {
        this.getScaleOrientationField().add(x, y, z, w);
    }

    public void getSFMatrix(SFMatrix mOut) {
        float[] center = new float[3];
        float[] rotation = new float[4];
        float[] scale = new float[3];
        float[] scaleOri = new float[4];
        float[] trans = new float[3];
        SFMatrix mSRI = new SFMatrix();
        SFMatrix mSR = new SFMatrix();
        SFMatrix mCI = new SFMatrix();
        SFMatrix mC = new SFMatrix();
        SFMatrix mT = new SFMatrix();
        SFMatrix mR = new SFMatrix();
        SFMatrix mS = new SFMatrix();
        this.getTranslation(trans);
        mT.setValueAsTranslation(trans);
        this.getCenter(center);
        mC.setValueAsTranslation(center);
        this.getRotation(rotation);
        mR.setValueAsRotation(rotation);
        this.getScaleOrientation(scaleOri);
        mSR.setValueAsRotation(scaleOri);
        this.getScale(scale);
        mS.setValueAsScaling(scale);
        this.getScaleOrientation(scaleOri);
        scaleOri[3] = -scaleOri[3];
        mSRI.setValueAsRotation(scaleOri);
        this.getCenter(center);
        center[0] = -center[0];
        center[1] = -center[1];
        center[2] = -center[2];
        mCI.setValueAsTranslation(center);
        mOut.add(mT);
        mOut.add(mC);
        mOut.add(mR);
        mOut.add(mSR);
        mOut.add(mS);
        mOut.add(mSRI);
        mOut.add(mCI);
    }

    public SFMatrix getSFMatrix() {
        SFMatrix mx = new SFMatrix();
        this.getSFMatrix(mx);
        return mx;
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return node.isCommonNode() || node.isBindableNode() || node.isInterpolatorNode() || node.isSensorNode() || node.isGroupingNode() || node.isSpecialGroupNode();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateChildrenField();
        this.updateBoundingBox();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        float[] vec = new float[3];
        float[] rot = new float[4];
        this.getTranslation(vec);
        printStream.println(String.valueOf(indentString) + "\t" + "translation " + vec[0] + " " + vec[1] + " " + vec[2]);
        this.getRotation(rot);
        printStream.println(String.valueOf(indentString) + "\t" + "rotation " + rot[0] + " " + rot[1] + " " + rot[2] + " " + rot[3]);
        this.getScale(vec);
        printStream.println(String.valueOf(indentString) + "\t" + "scale " + vec[0] + " " + vec[1] + " " + vec[2]);
        this.getScaleOrientation(rot);
        printStream.println(String.valueOf(indentString) + "\t" + "scaleOrientation " + rot[0] + " " + rot[1] + " " + rot[2] + " " + rot[3]);
        this.getCenter(vec);
        printStream.println(String.valueOf(indentString) + "\t" + "center " + vec[0] + " " + vec[1] + " " + vec[2]);
    }
}

