/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import java.util.Date;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.field.SFTime;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.SensorNode;
import org.cybergarage.x3d.node.TimeDependentObject;

public class TimeSensorNode
extends SensorNode
implements TimeDependentObject {
    private static final String loopFieldName = "loop";
    private static final String cybleIntervalFieldName = "cycleInterval";
    private static final String startTimeFieldName = "startTime";
    private static final String stopTimeFieldName = "stopTime";
    private static final String cycleTimeFieldName = "cycleTime";
    private static final String timeFieldName = "time";
    private static final String isPausedFieldName = "isPaused";
    private static final String pauseTimeFieldName = "pauseTime";
    private static final String resumeTimeFieldName = "resumeTime";
    private static final String elapsedTimeFieldName = "elapsedTime";
    private static final String numLoopsFieldName = "numLoops";
    private SFBool loopField;
    private SFTime cybleIntervalField;
    private SFTime startTimeField;
    private SFTime stopTimeField;
    private SFTime cycleTimeField;
    private SFTime timeField;
    private SFFloat fractionField;
    private SFBool isPausedField;
    private SFTime pauseTimeField;
    private SFTime resumeTimeField;
    private SFTime elapsedTimeField;
    private SFFloat numLoopsField;
    private double currentTime = 0.0;

    public TimeSensorNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.TIMESENSOR);
        this.loopField = new SFBool(true);
        this.addExposedField(loopFieldName, this.loopField);
        this.cybleIntervalField = new SFTime(1.0);
        this.addExposedField(cybleIntervalFieldName, this.cybleIntervalField);
        this.startTimeField = new SFTime(0.0);
        this.addExposedField(startTimeFieldName, this.startTimeField);
        this.stopTimeField = new SFTime(0.0);
        this.addExposedField(stopTimeFieldName, this.stopTimeField);
        this.cycleTimeField = new SFTime(-1.0);
        this.addEventOut(cycleTimeFieldName, this.cycleTimeField);
        this.timeField = new SFTime(-1.0);
        this.addEventOut(timeFieldName, this.timeField);
        this.fractionField = new SFFloat(0.0f);
        this.addEventOut("fraction", this.fractionField);
        this.isPausedField = new SFBool(false);
        this.addEventOut(isPausedFieldName, this.isPausedField);
        this.pauseTimeField = new SFTime(0.0);
        this.addExposedField(pauseTimeFieldName, this.pauseTimeField);
        this.resumeTimeField = new SFTime(0.0);
        this.addExposedField(resumeTimeFieldName, this.resumeTimeField);
        this.elapsedTimeField = new SFTime(0.0);
        this.addEventOut(elapsedTimeFieldName, this.elapsedTimeField);
        this.numLoopsField = new SFFloat(1.0f);
        this.addExposedField(numLoopsFieldName, this.numLoopsField);
    }

    public TimeSensorNode(TimeSensorNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFBool getLoopField() {
        if (!this.isInstanceNode()) {
            return this.loopField;
        }
        return (SFBool)this.getExposedField(loopFieldName);
    }

    public void setLoop(boolean value) {
        this.getLoopField().setValue(value);
    }

    public void setLoop(String value) {
        this.getLoopField().setValue(value);
    }

    public boolean getLoop() {
        return this.getLoopField().getValue();
    }

    public boolean isLoop() {
        return this.getLoop();
    }

    public SFTime getCycleIntervalField() {
        if (!this.isInstanceNode()) {
            return this.cybleIntervalField;
        }
        return (SFTime)this.getExposedField(cybleIntervalFieldName);
    }

    public void setCycleInterval(double value) {
        this.getCycleIntervalField().setValue(value);
    }

    public void setCycleInterval(String value) {
        this.getCycleIntervalField().setValue(value);
    }

    public double getCycleInterval() {
        return this.getCycleIntervalField().getValue();
    }

    public SFTime getStartTimeField() {
        if (!this.isInstanceNode()) {
            return this.startTimeField;
        }
        return (SFTime)this.getExposedField(startTimeFieldName);
    }

    public void setStartTime(double value) {
        this.getStartTimeField().setValue(value);
    }

    public void setStartTime(String value) {
        this.getStartTimeField().setValue(value);
    }

    public double getStartTime() {
        return this.getStartTimeField().getValue();
    }

    public SFTime getStopTimeField() {
        if (!this.isInstanceNode()) {
            return this.stopTimeField;
        }
        return (SFTime)this.getExposedField(stopTimeFieldName);
    }

    public void setStopTime(double value) {
        this.getStopTimeField().setValue(value);
    }

    public void setStopTime(String value) {
        this.getStopTimeField().setValue(value);
    }

    public double getStopTime() {
        return this.getStopTimeField().getValue();
    }

    public SFFloat getFractionChangedField() {
        if (!this.isInstanceNode()) {
            return this.fractionField;
        }
        return (SFFloat)this.getEventOut("fraction");
    }

    public void setFractionChanged(float value) {
        this.getFractionChangedField().setValue(value);
    }

    public void setFractionChanged(String value) {
        this.getFractionChangedField().setValue(value);
    }

    public float getFractionChanged() {
        return this.getFractionChangedField().getValue();
    }

    public SFFloat getFractionField() {
        return this.getFractionChangedField();
    }

    public void setFraction(float value) {
        this.setFractionChanged(value);
    }

    public void setFraction(String value) {
        this.setFractionChanged(value);
    }

    public float getFraction() {
        return this.getFractionChanged();
    }

    public SFTime getCycleTimeField() {
        if (!this.isInstanceNode()) {
            return this.cycleTimeField;
        }
        return (SFTime)this.getEventOut(cycleTimeFieldName);
    }

    public void setCycleTime(double value) {
        this.getCycleTimeField().setValue(value);
    }

    public void setCycleTime(String value) {
        this.getCycleTimeField().setValue(value);
    }

    public double getCycleTime() {
        return this.getCycleTimeField().getValue();
    }

    public SFTime getTimeField() {
        if (!this.isInstanceNode()) {
            return this.timeField;
        }
        return (SFTime)this.getEventOut(timeFieldName);
    }

    public void setTime(double value) {
        this.getTimeField().setValue(value);
    }

    public void setTime(String value) {
        this.getTimeField().setValue(value);
    }

    public double getTime() {
        return this.getTimeField().getValue();
    }

    public SFBool getIsPausedField() {
        if (!this.isInstanceNode()) {
            return this.isPausedField;
        }
        return (SFBool)this.getEventOut(isPausedFieldName);
    }

    public void setIsPaused(boolean value) {
        this.getIsPausedField().setValue(value);
    }

    public void setIsPaused(String value) {
        this.getIsPausedField().setValue(value);
    }

    public boolean getIsPaused() {
        return this.getIsPausedField().getValue();
    }

    public boolean isPaused() {
        return this.getIsPaused();
    }

    public SFTime getElapsedTimeField() {
        if (!this.isInstanceNode()) {
            return this.elapsedTimeField;
        }
        return (SFTime)this.getEventOut(elapsedTimeFieldName);
    }

    public void setElapsedTime(double value) {
        this.getElapsedTimeField().setValue(value);
    }

    public void setElapsedTime(String value) {
        this.getElapsedTimeField().setValue(value);
    }

    public double getElapsedTime() {
        return this.getElapsedTimeField().getValue();
    }

    public SFTime getPauseTimeField() {
        if (!this.isInstanceNode()) {
            return this.pauseTimeField;
        }
        return (SFTime)this.getExposedField(pauseTimeFieldName);
    }

    public void setPauseTime(double value) {
        this.getPauseTimeField().setValue(value);
    }

    public void setPauseTime(String value) {
        this.getPauseTimeField().setValue(value);
    }

    public double getPauseTime() {
        return this.getPauseTimeField().getValue();
    }

    public SFTime getResumeTimeField() {
        if (!this.isInstanceNode()) {
            return this.resumeTimeField;
        }
        return (SFTime)this.getExposedField(resumeTimeFieldName);
    }

    public void setResumeTime(double value) {
        this.getResumeTimeField().setValue(value);
    }

    public void setResumeTime(String value) {
        this.getResumeTimeField().setValue(value);
    }

    public double getResumeTime() {
        return this.getResumeTimeField().getValue();
    }

    public SFFloat getNumLoopsField() {
        if (!this.isInstanceNode()) {
            return this.numLoopsField;
        }
        return (SFFloat)this.getExposedField(numLoopsFieldName);
    }

    public void setNumLoops(float value) {
        this.getNumLoopsField().setValue(value);
    }

    public void setNumLoops(String value) {
        this.getNumLoopsField().setValue(value);
    }

    public float getNumLoops() {
        return this.getNumLoopsField().getValue();
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setCycleTime(-1.0);
        this.setIsActive(false);
        this.setRunnableIntervalTime((int)(this.getCycleInterval() * 1000.0));
    }

    @Override
    public void uninitialize() {
    }

    public double getCurrentSystemTime() {
        Date date = new Date();
        return (double)date.getTime() / 1000.0;
    }

    @Override
    public void update() {
        double startTime = this.getStartTime();
        double stopTime = this.getStopTime();
        double cycleInterval = this.getCycleInterval();
        boolean bActive = this.isActive();
        boolean bEnable = this.isEnabled();
        boolean bLoop = this.isLoop();
        if (this.currentTime == 0.0) {
            this.currentTime = this.getCurrentSystemTime();
        }
        if (!bEnable && bActive) {
            this.setIsActive(false);
            this.sendEvent(this.getIsActiveField());
            return;
        }
        if (!bActive && bEnable) {
            if (startTime <= this.currentTime) {
                if (bLoop && stopTime <= startTime) {
                    bActive = true;
                } else if (!bLoop && stopTime <= startTime) {
                    bActive = true;
                } else if (this.currentTime <= stopTime) {
                    if (bLoop && startTime < stopTime) {
                        bActive = true;
                    } else if (!bLoop && startTime < startTime + cycleInterval && startTime + cycleInterval <= stopTime) {
                        bActive = true;
                    } else if (!bLoop && startTime < stopTime && stopTime < startTime + cycleInterval) {
                        bActive = true;
                    }
                }
            }
            if (bActive) {
                this.setIsActive(true);
                this.sendEvent(this.getIsActiveField());
                this.setCycleTime(this.currentTime);
                this.sendEvent(this.getCycleTimeField());
            }
        }
        this.currentTime = this.getCurrentSystemTime();
        if (bActive && bEnable) {
            if (bLoop && startTime < stopTime) {
                if (stopTime < this.currentTime) {
                    bActive = false;
                }
            } else if (!bLoop && stopTime <= startTime) {
                if (startTime + cycleInterval < this.currentTime) {
                    bActive = false;
                }
            } else if (!bLoop && startTime < startTime + cycleInterval && startTime + cycleInterval <= stopTime) {
                if (startTime + cycleInterval < this.currentTime) {
                    bActive = false;
                }
            } else if (!bLoop && startTime < stopTime && stopTime < startTime + cycleInterval && stopTime < this.currentTime) {
                bActive = false;
            }
            if (!bActive) {
                this.setIsActive(false);
                this.sendEvent(this.getIsActiveField());
            }
        }
        if (!bEnable || !this.isActive()) {
            return;
        }
        double fraction = (this.currentTime - startTime) % cycleInterval;
        fraction = fraction == 0.0 && startTime < this.currentTime ? 1.0 : (fraction /= cycleInterval);
        this.setFractionChanged((float)fraction);
        this.sendEvent(this.getFractionChangedField());
        double cycleTime = this.getCycleTime();
        double cycleEndTime = cycleTime + cycleInterval;
        while (cycleEndTime < this.currentTime) {
            this.setCycleTime(cycleEndTime);
            cycleEndTime += cycleInterval;
            this.setCycleTime(this.currentTime);
            this.sendEvent(this.getCycleTimeField());
        }
        this.setTime(this.currentTime);
        this.sendEvent(this.getTimeField());
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        SFBool bEnabled = this.getEnabledField();
        SFBool loop = this.getLoopField();
        printStream.println(String.valueOf(indentString) + "\t" + "cycleInterval " + this.getCycleInterval());
        printStream.println(String.valueOf(indentString) + "\t" + "enabled " + bEnabled);
        printStream.println(String.valueOf(indentString) + "\t" + "loop " + loop);
        printStream.println(String.valueOf(indentString) + "\t" + "startTime " + this.getStartTime());
        printStream.println(String.valueOf(indentString) + "\t" + "stopTime " + this.getStopTime());
    }
}

