/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFVec3f;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.InterpolatorNode;
import org.cybergarage.x3d.node.Node;

public class NormalInterpolatorNode
extends InterpolatorNode {
    private String keyValueFieldName = "keyValue";
    private MFVec3f keyValueField;
    private SFVec3f valueField;

    public NormalInterpolatorNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.NORMALINTERP);
        this.keyValueField = new MFVec3f();
        this.addExposedField(this.keyValueFieldName, this.keyValueField);
        this.valueField = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.addEventOut("value", this.valueField);
    }

    public NormalInterpolatorNode(NormalInterpolatorNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFVec3f getKeyValueField() {
        if (!this.isInstanceNode()) {
            return this.keyValueField;
        }
        return (MFVec3f)this.getExposedField(this.keyValueFieldName);
    }

    public void addKeyValue(float[] vector) {
        this.getKeyValueField().addValue(vector);
    }

    public void addKeyValue(float x, float y, float z) {
        this.getKeyValueField().addValue(x, y, z);
    }

    public int getNKeyValues() {
        return this.getKeyValueField().getSize();
    }

    public void setKeyValue(int index, float[] vector) {
        this.getKeyValueField().set1Value(index, vector);
    }

    public void setKeyValue(int index, float x, float y, float z) {
        this.getKeyValueField().set1Value(index, x, y, z);
    }

    public void setKeyValues(String vector) {
        this.getKeyValueField().setValues(vector);
    }

    public void setKeyValues(String[] vector) {
        this.getKeyValueField().setValues(vector);
    }

    public void getKeyValue(int index, float[] vector) {
        this.getKeyValueField().get1Value(index, vector);
    }

    public float[] getKeyValue(int index) {
        float[] value = new float[3];
        this.getKeyValue(index, value);
        return value;
    }

    public void removeKeyValue(int index) {
        this.getKeyValueField().removeValue(index);
    }

    public SFVec3f getValueField() {
        if (!this.isInstanceNode()) {
            return this.valueField;
        }
        return (SFVec3f)this.getEventOut("value");
    }

    public void setValue(float[] vector) {
        this.getValueField().setValue(vector);
    }

    public void setValue(String vector) {
        this.getValueField().setValue(vector);
    }

    public void getValue(float[] vector) {
        this.getValueField().getValue(vector);
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
        float fraction = this.getFraction();
        int index = -1;
        int n = 0;
        while (n < this.getNKeys() - 1) {
            if (this.getKey(n) <= fraction && fraction <= this.getKey(n + 1)) {
                index = n;
                break;
            }
            ++n;
        }
        if (index == -1) {
            return;
        }
        float scale = (fraction - this.getKey(index)) / (this.getKey(index + 1) - this.getKey(index));
        float[] vector1 = new float[3];
        float[] vector2 = new float[3];
        float[] vectorOut = new float[3];
        this.getKeyValue(index, vector1);
        this.getKeyValue(index + 1, vector2);
        int n2 = 0;
        while (n2 < 3) {
            vectorOut[n2] = vector1[n2] + (vector2[n2] - vector1[n2]) * scale;
            ++n2;
        }
        this.setValue(vectorOut);
        this.sendEvent(this.getValueField());
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        printStream.println(String.valueOf(indentString) + "\tkey [");
        int n = 0;
        while (n < this.getNKeys()) {
            if (n < this.getNKeys() - 1) {
                printStream.println(String.valueOf(indentString) + "\t\t" + this.getKey(n));
            } else {
                printStream.println(String.valueOf(indentString) + "\t\t" + this.getKey(n));
            }
            ++n;
        }
        printStream.println(String.valueOf(indentString) + "\t]");
        float[] vector = new float[3];
        printStream.println(String.valueOf(indentString) + "\tkeyValue [");
        int n2 = 0;
        while (n2 < this.getNKeyValues()) {
            this.getKeyValue(n2, vector);
            if (n2 < this.getNKeyValues() - 1) {
                printStream.println(String.valueOf(indentString) + "\t\t" + vector[0] + " " + vector[1] + " " + vector[2] + ",");
            } else {
                printStream.println(String.valueOf(indentString) + "\t\t" + vector[0] + " " + vector[1] + " " + vector[2]);
            }
            ++n2;
        }
        printStream.println(String.valueOf(indentString) + "\t]");
    }
}

