/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFColor;
import org.cybergarage.x3d.field.SFColor;
import org.cybergarage.x3d.node.InterpolatorNode;
import org.cybergarage.x3d.node.Node;

public class ColorInterpolatorNode
extends InterpolatorNode {
    private String keyValueFieldName = "keyValue";
    private MFColor keyValueField;
    private SFColor valueField;

    public ColorInterpolatorNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.COLORINTERP);
        this.keyValueField = new MFColor();
        this.addExposedField(this.keyValueFieldName, this.keyValueField);
        this.valueField = new SFColor(0.0f, 0.0f, 0.0f);
        this.addEventOut("value", this.valueField);
    }

    public ColorInterpolatorNode(ColorInterpolatorNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFColor getKeyValueField() {
        if (!this.isInstanceNode()) {
            return this.keyValueField;
        }
        return (MFColor)this.getExposedField(this.keyValueFieldName);
    }

    public void addKeyValue(float[] color) {
        this.getKeyValueField().addValue(color);
    }

    public void addKeyValue(float r, float g, float b) {
        this.getKeyValueField().addValue(r, g, b);
    }

    public int getNKeyValues() {
        return this.getKeyValueField().getSize();
    }

    public void setKeyValue(int index, float[] color) {
        this.getKeyValueField().set1Value(index, color);
    }

    public void setKeyValue(int index, float r, float g, float b) {
        this.getKeyValueField().set1Value(index, r, g, b);
    }

    public void setKeyValues(String color) {
        this.getKeyValueField().setValues(color);
    }

    public void setKeyValues(String[] color) {
        this.getKeyValueField().setValues(color);
    }

    public void getKeyValue(int index, float[] color) {
        this.getKeyValueField().get1Value(index, color);
    }

    public float[] getKeyValue(int index) {
        float[] value = new float[3];
        this.getKeyValue(index, value);
        return value;
    }

    public void removeKeyValue(int index) {
        this.getKeyValueField().removeValue(index);
    }

    public SFColor getValueField() {
        if (!this.isInstanceNode()) {
            return this.valueField;
        }
        return (SFColor)this.getEventOut("value");
    }

    public void setValue(float[] color) {
        this.getValueField().setValue(color);
    }

    public void setValue(String color) {
        this.getValueField().setValue(color);
    }

    public void getValue(float[] color) {
        this.getValueField().getValue(color);
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
        float fraction = this.getFraction();
        int index = -1;
        int n = 0;
        while (n < this.getNKeys() - 1) {
            if (this.getKey(n) <= fraction && fraction <= this.getKey(n + 1)) {
                index = n;
                break;
            }
            ++n;
        }
        if (index == -1) {
            return;
        }
        float scale = (fraction - this.getKey(index)) / (this.getKey(index + 1) - this.getKey(index));
        float[] color1 = new float[3];
        float[] color2 = new float[3];
        float[] colorOut = new float[3];
        this.getKeyValue(index, color1);
        this.getKeyValue(index + 1, color2);
        int n2 = 0;
        while (n2 < 3) {
            colorOut[n2] = color1[n2] + (color2[n2] - color1[n2]) * scale;
            ++n2;
        }
        this.setValue(colorOut);
        this.sendEvent(this.getValueField());
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        printStream.println(String.valueOf(indentString) + "\tkey [");
        int n = 0;
        while (n < this.getNKeys()) {
            if (n < this.getNKeys() - 1) {
                printStream.println(String.valueOf(indentString) + "\t\t" + this.getKey(n));
            } else {
                printStream.println(String.valueOf(indentString) + "\t\t" + this.getKey(n));
            }
            ++n;
        }
        printStream.println(String.valueOf(indentString) + "\t]");
        float[] color = new float[3];
        printStream.println(String.valueOf(indentString) + "\tkeyValue [");
        int n2 = 0;
        while (n2 < this.getNKeyValues()) {
            this.getKeyValue(n2, color);
            if (n2 < this.getNKeyValues() - 1) {
                printStream.println(String.valueOf(indentString) + "\t\t" + color[0] + " " + color[1] + " " + color[2] + ",");
            } else {
                printStream.println(String.valueOf(indentString) + "\t\t" + color[0] + " " + color[1] + " " + color[2]);
            }
            ++n2;
        }
        printStream.println(String.valueOf(indentString) + "\t]");
    }
}

