/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.Geometry;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.Shape3D;
import org.cybergarage.x3d.j3d.NullGeometryObject;
import org.cybergarage.x3d.node.ExtrusionNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.util.BoundingBox;
import org.cybergarage.x3d.util.Debug;
import org.cybergarage.x3d.util.Geometry3D;

public class ExtrusionNodeObject
extends IndexedTriangleArray
implements NodeObject {
    public ExtrusionNodeObject(ExtrusionNode exNode) {
        super(exNode.getVertexCount(), ExtrusionNodeObject.getVertexFormat(exNode), exNode.getNTriangleCoordIndices());
        this.setCapability(0);
        this.setCapability(1);
        this.setCapability(2);
        this.setCapability(3);
        this.setCapability(4);
        this.setCapability(5);
        this.setCapability(6);
        this.setCapability(7);
        this.setCapability(8);
        this.setCapability(20);
        this.setCapability(17);
        this.setCapability(11);
        this.setCapability(12);
        this.setCapability(9);
        this.setCapability(10);
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(15);
        this.setCapability(16);
        this.setCapability(18);
        this.initialize(exNode);
    }

    public static int getVertexFormat(ExtrusionNode exNode) {
        return 39;
    }

    public void getNormalVector(int coordIndex1, int coordIndex2, int coordIndex3, float[] normal) {
        float[][] vertex = new float[3][3];
        this.getCoordinate(coordIndex1, vertex[0]);
        this.getCoordinate(coordIndex2, vertex[1]);
        this.getCoordinate(coordIndex3, vertex[2]);
        Geometry3D.getNormalVector(vertex, normal);
    }

    public void getNormalVector(float[][] normal, int nNormal, float[] resultVector) {
        Geometry3D.initialize(resultVector);
        int n = 0;
        while (n < nNormal) {
            Geometry3D.add(resultVector, normal[n]);
            Geometry3D.normalize(resultVector);
            ++n;
        }
    }

    public void setCoordinateIndexforDebug(int n, int nCoord) {
        float[] coord = new float[3];
        this.getCoordinate(nCoord, coord);
        Debug.message("\t\t[" + n + "] = " + nCoord + " (" + coord[0] + ", " + coord[1] + ", " + coord[2] + ")");
        this.setCoordinateIndex(n, nCoord);
    }

    private void transformPoint(float[] point, float[] scale, float[][] scp, float[] orientation, float[] spine) {
        Geometry3D.scale(point, scale[0], 1.0f, scale[1]);
        if (0.0f < Geometry3D.length(scp[0]) && 0.0f < Geometry3D.length(scp[1]) && 0.0f < Geometry3D.length(scp[2])) {
            Geometry3D.rotate(point, scp);
        }
        Geometry3D.add(point, spine);
        Geometry3D.rotate(point, orientation);
    }

    @Override
    public boolean initialize(Node node) {
        int j;
        Debug.message("ExtrusionNodeObject::initialize");
        ExtrusionNode exNode = (ExtrusionNode)node;
        exNode.addDefaultParameters();
        Debug.message("\tinitialize Coordinate ..... ");
        Debug.message("\t\tTotal Coordinates = " + exNode.getVertexCount());
        int nCrossSections = exNode.getNCrossSections();
        int nOrientations = exNode.getNOrientations();
        int nScales = exNode.getNScales();
        int nSpines = exNode.getNSpines();
        float[] spineStart = new float[3];
        float[] spineEnd = new float[3];
        exNode.getSpine(0, spineStart);
        exNode.getSpine(nSpines - 1, spineEnd);
        boolean bClosed = Geometry3D.equals(spineStart, spineEnd);
        float[] scale = new float[2];
        float[] orientation = new float[4];
        float[] spine = new float[3];
        float[] spine0 = new float[3];
        float[] spine1 = new float[3];
        float[] spine2 = new float[3];
        float[][] scp = new float[3][3];
        float[] vector1 = new float[3];
        float[] vector2 = new float[3];
        float[] csPoint = new float[2];
        float[] point = new float[3];
        BoundingBox bbox = new BoundingBox();
        int i = 0;
        while (i < nSpines) {
            if (nScales == 1) {
                exNode.getScale(0, scale);
            } else if (i < nScales) {
                exNode.getScale(i, scale);
            } else {
                scale[0] = 1.0f;
                scale[1] = 1.0f;
            }
            if (nOrientations == 1) {
                exNode.getOrientation(0, orientation);
            } else if (i < nOrientations) {
                exNode.getOrientation(i, orientation);
            } else {
                orientation[0] = 0.0f;
                orientation[1] = 0.0f;
                orientation[2] = 1.0f;
                orientation[3] = 0.0f;
            }
            if (nSpines <= 2) {
                exNode.getSpine(1, spine1);
                exNode.getSpine(0, spine2);
            }
            if (bClosed && (i == 0 || i == nSpines - 1)) {
                exNode.getSpine(1, spine1);
                exNode.getSpine(nSpines - 2, spine2);
            } else if (i == 0) {
                exNode.getSpine(1, spine1);
                exNode.getSpine(0, spine2);
            } else if (i == nSpines - 1) {
                exNode.getSpine(nSpines - 1, spine1);
                exNode.getSpine(nSpines - 2, spine2);
            } else {
                exNode.getSpine(i + 1, spine1);
                exNode.getSpine(i - 1, spine2);
            }
            Geometry3D.sub(spine1, spine2, scp[1]);
            Geometry3D.normalize(scp[1]);
            if (nSpines <= 2) {
                exNode.getSpine(0, spine0);
                exNode.getSpine(1, spine1);
                exNode.getSpine(1, spine2);
            } else if (bClosed && (i == 0 || i == nSpines - 1)) {
                exNode.getSpine(0, spine0);
                exNode.getSpine(1, spine1);
                exNode.getSpine(nSpines - 2, spine2);
            } else if (i == 0) {
                exNode.getSpine(1, spine0);
                exNode.getSpine(2, spine1);
                exNode.getSpine(0, spine2);
            } else if (i == nSpines - 1) {
                exNode.getSpine(nSpines - 2, spine1);
                exNode.getSpine(nSpines - 1, spine1);
                exNode.getSpine(nSpines - 3, spine2);
            } else {
                exNode.getSpine(i, spine0);
                exNode.getSpine(i + 1, spine1);
                exNode.getSpine(i - 1, spine2);
            }
            Geometry3D.sub(spine1, spine0, vector1);
            Geometry3D.sub(spine2, spine0, vector2);
            Geometry3D.getCross(vector1, vector2, scp[2]);
            Geometry3D.getCross(scp[1], scp[2], scp[0]);
            Debug.message("scp[" + i + "] = " + scp[0][0] + " " + scp[0][1] + " " + scp[0][2] + ", " + scp[1][0] + " " + scp[1][1] + " " + scp[1][2] + ", " + scp[2][0] + " " + scp[2][1] + " " + scp[2][2]);
            exNode.getSpine(i, spine);
            j = 0;
            while (j < nCrossSections) {
                exNode.getCrossSection(j, csPoint);
                point[0] = csPoint[0];
                point[1] = 0.0f;
                point[2] = csPoint[1];
                this.transformPoint(point, scale, scp, orientation, spine);
                this.setCoordinate(i * nCrossSections + j, point);
                Debug.message("\t\tpoint[" + (i * nCrossSections + j) + "] = " + point[0] + ", " + point[1] + ", " + point[2]);
                bbox.addPoint(point);
                ++j;
            }
            ++i;
        }
        exNode.setBoundingBoxCenter(bbox.getCenter());
        exNode.setBoundingBoxSize(bbox.getSize());
        int nTriangle = 0;
        i = 0;
        while (i < nSpines - 1) {
            j = 0;
            while (j < nCrossSections - 1) {
                this.setCoordinateIndexforDebug(nTriangle * 3 + 0, (i + 1) * nCrossSections + (j + 0));
                this.setCoordinateIndexforDebug(nTriangle * 3 + 1, (i + 0) * nCrossSections + (j + 0));
                this.setCoordinateIndexforDebug(nTriangle * 3 + 2, (i + 1) * nCrossSections + (j + 1));
                this.setCoordinateIndexforDebug(++nTriangle * 3 + 0, (i + 1) * nCrossSections + (j + 1));
                this.setCoordinateIndexforDebug(nTriangle * 3 + 1, (i + 0) * nCrossSections + (j + 0));
                this.setCoordinateIndexforDebug(nTriangle * 3 + 2, (i + 0) * nCrossSections + (j + 1));
                ++nTriangle;
                ++j;
            }
            ++i;
        }
        Debug.message("\tinitialize Normal ..... ");
        float[][] coord = new float[3][3];
        float[] normal = new float[3];
        i = 0;
        while (i < nSpines) {
            j = 0;
            while (j < nCrossSections) {
                if (i < nSpines - 1) {
                    if (j < nCrossSections - 1) {
                        this.getCoordinate((i + 1) * nCrossSections + (j + 0), coord[0]);
                        this.getCoordinate((i + 1) * nCrossSections + (j + 1), coord[1]);
                        this.getCoordinate((i + 0) * nCrossSections + (j + 0), coord[2]);
                    } else if (j < nCrossSections - 1) {
                        this.getCoordinate((i + 1) * nCrossSections + (j - 1), coord[0]);
                        this.getCoordinate((i + 0) * nCrossSections + (j + 0), coord[1]);
                        this.getCoordinate((i + 0) * nCrossSections + (j - 1), coord[2]);
                    }
                } else if (j < nCrossSections - 1) {
                    this.getCoordinate((i - 1) * nCrossSections + (j + 0), coord[0]);
                    this.getCoordinate((i + 0) * nCrossSections + (j + 0), coord[1]);
                    this.getCoordinate((i + 0) * nCrossSections + (j + 1), coord[2]);
                } else if (j < nCrossSections - 1) {
                    this.getCoordinate((i - 1) * nCrossSections + (j - 1), coord[0]);
                    this.getCoordinate((i + 0) * nCrossSections + (j + 0), coord[1]);
                    this.getCoordinate((i - 1) * nCrossSections + (j + 0), coord[2]);
                }
                Geometry3D.getNormalVector(coord, normal);
                this.setNormal(i * nCrossSections + j, normal);
                ++j;
            }
            ++i;
        }
        nTriangle = 0;
        i = 0;
        while (i < nSpines - 1) {
            j = 0;
            while (j < nCrossSections - 1) {
                this.setNormalIndex(nTriangle * 3 + 0, (i + 1) * nCrossSections + (j + 0));
                this.setNormalIndex(nTriangle * 3 + 1, (i + 0) * nCrossSections + (j + 0));
                this.setNormalIndex(nTriangle * 3 + 2, (i + 1) * nCrossSections + (j + 1));
                this.setNormalIndex(++nTriangle * 3 + 0, (i + 1) * nCrossSections + (j + 1));
                this.setNormalIndex(nTriangle * 3 + 1, (i + 0) * nCrossSections + (j + 0));
                this.setNormalIndex(nTriangle * 3 + 2, (i + 0) * nCrossSections + (j + 1));
                ++nTriangle;
                ++j;
            }
            ++i;
        }
        Debug.message("\tinitialize Color ..... ");
        float[] color = new float[]{1.0f, 1.0f, 1.0f};
        i = 0;
        while (i < nSpines) {
            j = 0;
            while (j < nCrossSections) {
                this.setColor(i * nCrossSections + j, color);
                ++j;
            }
            ++i;
        }
        nTriangle = 0;
        i = 0;
        while (i < nSpines - 1) {
            j = 0;
            while (j < nCrossSections - 1) {
                this.setColorIndex(nTriangle * 3 + 0, (i + 1) * nCrossSections + (j + 0));
                this.setColorIndex(nTriangle * 3 + 1, (i + 0) * nCrossSections + (j + 0));
                this.setColorIndex(nTriangle * 3 + 2, (i + 1) * nCrossSections + (j + 1));
                this.setColorIndex(++nTriangle * 3 + 0, (i + 1) * nCrossSections + (j + 1));
                this.setColorIndex(nTriangle * 3 + 1, (i + 0) * nCrossSections + (j + 0));
                this.setColorIndex(nTriangle * 3 + 2, (i + 0) * nCrossSections + (j + 1));
                ++nTriangle;
                ++j;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean uninitialize(Node node) {
        return true;
    }

    @Override
    public boolean update(Node node) {
        return true;
    }

    @Override
    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)this);
        }
        return true;
    }

    @Override
    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)new NullGeometryObject());
        }
        return true;
    }
}

