/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.Geometry;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.cybergarage.x3d.j3d.NullGeometryObject;
import org.cybergarage.x3d.node.BoxNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;

public class BoxNodeObject
extends QuadArray
implements NodeObject {
    public BoxNodeObject(BoxNode node) {
        super(24, 35);
        this.setCapability(0);
        this.setCapability(1);
        this.setCapability(2);
        this.setCapability(3);
        this.setCapability(4);
        this.setCapability(5);
        this.setCapability(6);
        this.setCapability(7);
        this.setCapability(8);
        this.setCapability(20);
        this.setCapability(17);
        this.setCapability(18);
        float xsize = node.getX();
        float ysize = node.getY();
        float zsize = node.getZ();
        float xmin = -xsize / 2.0f;
        float xmax = xsize / 2.0f;
        float ymin = -ysize / 2.0f;
        float ymax = ysize / 2.0f;
        float zmin = -zsize / 2.0f;
        float zmax = zsize / 2.0f;
        this.createBox(xmin, xmax, ymin, ymax, zmin, zmax);
    }

    private void createBox(float x0, float x1, float y0, float y1, float z0, float z1) {
        float[][] n = new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}};
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[4];
        nArray[0] = 3;
        nArray[1] = 2;
        nArray[2] = 1;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{2, 3, 7, 6};
        nArrayArray[2] = new int[]{6, 7, 4, 5};
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[2] = 5;
        nArray2[3] = 4;
        nArrayArray[3] = nArray2;
        nArrayArray[4] = new int[]{2, 6, 5, 1};
        int[] nArray3 = new int[4];
        nArray3[0] = 7;
        nArray3[1] = 3;
        nArray3[3] = 4;
        nArrayArray[5] = nArray3;
        int[][] faces = nArrayArray;
        float[][] t = new float[][]{{0.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}};
        float[][] v = new float[8][3];
        float f = x0;
        v[7][0] = f;
        v[4][0] = f;
        v[3][0] = f;
        v[0][0] = f;
        float f2 = x1;
        v[6][0] = f2;
        v[5][0] = f2;
        v[2][0] = f2;
        v[1][0] = f2;
        float f3 = y0;
        v[7][1] = f3;
        v[6][1] = f3;
        v[3][1] = f3;
        v[2][1] = f3;
        float f4 = y1;
        v[5][1] = f4;
        v[4][1] = f4;
        v[1][1] = f4;
        v[0][1] = f4;
        float f5 = z0;
        v[7][2] = f5;
        v[6][2] = f5;
        v[5][2] = f5;
        v[4][2] = f5;
        float f6 = z1;
        v[3][2] = f6;
        v[2][2] = f6;
        v[1][2] = f6;
        v[0][2] = f6;
        Point3f[] verts = new Point3f[24];
        Vector3f[] norms = new Vector3f[24];
        Point2f[] texCoords = new Point2f[24];
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 4) {
                norms[i * 4 + j] = new Vector3f(n[i]);
                verts[i * 4 + j] = new Point3f(v[faces[i][j]]);
                texCoords[i * 4 + j] = new Point2f(t[j]);
                ++j;
            }
            ++i;
        }
        this.setCoordinates(0, verts);
        this.setNormals(0, norms);
        this.setTextureCoordinates(0, texCoords);
    }

    @Override
    public boolean initialize(Node node) {
        return true;
    }

    @Override
    public boolean uninitialize(Node node) {
        return true;
    }

    @Override
    public boolean update(Node node) {
        return true;
    }

    @Override
    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)this);
        }
        return true;
    }

    @Override
    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)new NullGeometryObject());
        }
        return true;
    }
}

