/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.sftp;

import ciss.phase_viewer.common.MyJMenuItem;
import ciss.phase_viewer.filebrowser.DefaultFileBrowserNode;
import ciss.phase_viewer.ssh.filechooser.RemoteFile;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class SftpNode
extends DefaultFileBrowserNode {
    private static Logger logger = Logger.getLogger((String)SftpNode.class.getName());
    private int mode = 0;
    private MyJMenuItem transfer;

    public SftpNode(Object userObject) {
        super(userObject);
        if (userObject instanceof RemoteFile) {
            RemoteFile uo = (RemoteFile)userObject;
            this.mode = uo.isRemote() ? 0 : 1;
        }
    }

    @Override
    protected void showMenu(MouseEvent e) {
        if (e == null) {
            logger.error((Object)"MouseEvent is null");
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        MyJMenuItem[] items = this.getDefaultMenuItems();
        String transfer_mode = "download";
        if (this.mode == 1) {
            transfer_mode = "upload";
        }
        this.transfer = new MyJMenuItem(transfer_mode);
        popup.add(this.transfer);
        popup.addSeparator();
        int i = 0;
        while (i < items.length) {
            popup.add(items[i]);
            ++i;
        }
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                SftpNode.this.transfer.setEnabled(SftpNode.this.tree.isConnected());
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }
        });
        if (e.getComponent() == null) {
            logger.error((Object)"e.getComponent() returns null...something is wrong!");
            return;
        }
        popup.show(e.getComponent(), e.getX(), e.getY());
        this.transfer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SftpNode.this.mode == 1) {
                    SftpNode.this.tree.uploadFiles();
                } else if (SftpNode.this.mode == 0) {
                    SftpNode.this.tree.downloadFiles();
                }
            }
        });
    }
}

