/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.remotehostexecuter;

import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.MyThread;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jobcontrol.JobController;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.scripting.ScriptWrapper;
import ciss.phase_viewer.scripting.scriptexecscripts.ExecScriptCreator;
import ciss.phase_viewer.scripting.scriptreplace.ScriptKeywordsReplacer;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.Execute;
import ciss.phase_viewer.ssh.SessionCreator;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.remotehostexecuter.BatchFileTransferer;
import ciss.phase_viewer.ssh.sftp.SftpEvent;
import ciss.phase_viewer.ssh.sftp.SftpListener;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class JobExecuter
implements SftpListener,
Serializable {
    private transient Logger logger = Logger.getLogger((String)JobExecuter.class.getName());
    private String projdir;
    private HostInfo hostinfo;
    private boolean islocalhost = false;
    private String script;
    private String targetdir;
    private BatchFileTransferer batchTransfer;
    private String subfile;
    private Document jobControlDocument;
    private ProjectInfo projectInfo;
    private String scriptType;
    private boolean isValid = true;
    private ScriptWrapper scriptExecScript;
    private String scriptExecScriptExecString;
    private boolean repbymail = false;
    private Vector execScripts = new Vector();
    private Vector otherScripts = new Vector();
    private Session session;

    public JobExecuter(ProjectInfo projectInfo, HostInfo hostinfo, BatchFileTransferer batchTransfer) {
        this.projectInfo = projectInfo;
        this.projdir = projectInfo.getProjectDirectory();
        this.hostinfo = hostinfo;
        this.batchTransfer = batchTransfer;
        this.jobControlDocument = projectInfo.getProjectPropertyDocument();
        if (!this.parseJobControlDocument()) {
            this.logger.error((Object)"invalid job-control document.");
            this.isValid = false;
        }
        if (!this.preProcessScript()) {
            this.logger.error((Object)"failed to preprocess script.");
            this.isValid = false;
        }
        batchTransfer.addSftpListener(this);
        this.targetdir = projectInfo.getTargetDirectory();
    }

    private boolean parseJobControlDocument() {
        if (this.jobControlDocument == null) {
            this.logger.error((Object)"jobcontrol document is null.");
            return false;
        }
        if (!this.jobControlDocument.hasRootElement()) {
            this.logger.error((Object)"jobcontrol document does not have a root element.");
            return false;
        }
        Element jobControlElement = this.jobControlDocument.getRootElement().getChild(JobController.JOBCONTROL);
        if (jobControlElement == null) {
            this.logger.error((Object)"could not find a job-control element");
            return false;
        }
        Element scriptElement = jobControlElement.getChild("script");
        if (scriptElement == null) {
            this.logger.error((Object)"no script element");
            return false;
        }
        this.scriptType = MyElement.decode(scriptElement.getChildTextTrim("script_type"));
        Element execElement = scriptElement.getChild("exec");
        if (execElement == null || execElement.getContentSize() == 0) {
            this.logger.error((Object)"no exec scripts.");
            return false;
        }
        List execList = execElement.getChildren("exec_script");
        int i = 0;
        while (i < execList.size()) {
            Element exe = (Element)execList.get(i);
            String type = MyElement.decode(exe.getChildTextTrim("script_type"));
            if (type.equals(this.scriptType)) {
                this.execScripts.addElement(new ScriptWrapper(String.valueOf(this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + MyElement.decode(exe.getChildTextTrim("script_path")), type));
            }
            ++i;
        }
        return true;
    }

    private boolean preProcessScript() {
        String dir = this.projectInfo.getProjectDirectory();
        if (!dir.endsWith(System.getProperty("file.separator"))) {
            dir = String.valueOf(dir) + System.getProperty("file.separator");
        }
        ScriptKeywordsReplacer replacer = new ScriptKeywordsReplacer();
        int i = 0;
        while (i < this.execScripts.size()) {
            ScriptWrapper script = (ScriptWrapper)this.execScripts.get(i);
            replacer.replace(script, this.jobControlDocument);
            File file = new File(script.getPath());
            String replacedFile = String.valueOf(file.getParent()) + System.getProperty("file.separator") + "__" + file.getName();
            this.batchTransfer.registerFiles(replacedFile);
            ++i;
        }
        Object[] foo = new ScriptWrapper[this.execScripts.size()];
        this.execScripts.copyInto(foo);
        String foobar = ExecScriptCreator.getScriptExecScript(this.scriptType, (ScriptWrapper[])foo, this.hostinfo);
        ScriptWrapper tmpScriptExecScript = new ScriptWrapper(foobar, ScriptWrapper.getTypeFromFile(foobar));
        replacer.replace(tmpScriptExecScript, this.jobControlDocument, true);
        String scriptExecPath = String.valueOf(dir) + new File(tmpScriptExecScript.getPath()).getName();
        this.scriptExecScript = new ScriptWrapper(scriptExecPath, ScriptWrapper.getTypeFromFile(scriptExecPath));
        try {
            new File(this.scriptExecScript.getPath()).delete();
            ExternalProgramExecuter.copyBinary(tmpScriptExecScript.getPath(), this.scriptExecScript.getPath());
        }
        catch (Exception exc) {
            this.logger.error((Object)"failed to copy script-exec script.");
        }
        if (new File(String.valueOf(dir) + "report.bsh").exists() && new File(String.valueOf(dir) + "mail.xml").exists()) {
            this.repbymail = true;
            PrintWriter writer = Utils.getPrintWriter(this.scriptExecScript.getPath(), true);
            writer.print("\"__JAVA__\" -Dpviewer.home=\"__CHASEDIR__\" -jar \"__CHASEJAR__\" interpreter_mode report.bsh\n");
            if (!this.hostinfo.isLocalHost()) {
                writer.println("rm -f report.bsh");
                writer.println("rm -f mail.xml");
            }
            new File(String.valueOf(dir) + "report.bsh").deleteOnExit();
            new File(String.valueOf(dir) + "mail.xml").deleteOnExit();
            writer.flush();
            writer.close();
            replacer.replace(this.scriptExecScript, this.jobControlDocument, true);
            this.batchTransfer.registerFiles(String.valueOf(dir) + "report.bsh");
            this.batchTransfer.registerFiles(String.valueOf(dir) + "mail.xml");
        }
        this.scriptExecScriptExecString = ExecScriptCreator.getScriptExecScriptExecString(this.scriptType, this.scriptExecScript.getPath(), this.hostinfo);
        this.batchTransfer.registerFiles(this.scriptExecScript.getPath());
        return true;
    }

    @Override
    public void uploadFinished(SftpEvent se) {
        this.submit();
    }

    @Override
    public void downloadFinished(SftpEvent se) {
    }

    public void setScriptText(String script) {
        this.script = script;
    }

    public boolean execute() {
        if (!this.isValid) {
            return false;
        }
        this.transferFiles();
        return true;
    }

    private void transferFiles() {
        if (!this.hostinfo.isLocalHost()) {
            this.batchTransfer.upload();
        } else {
            this.uploadFinished(null);
        }
    }

    private void submit() {
        this.logger.info((Object)("submitting " + this.scriptExecScript.getPath() + " to host : " + this.hostinfo.getName()));
        if (!this.hostinfo.isLocalHost()) {
            String filename = new File(this.scriptExecScript.getPath()).getName();
            String chmod = "chmod +x " + this.targetdir + "/" + filename;
            Session sess = null;
            try {
                sess = SessionCreator.getSession(this.hostinfo);
            }
            catch (JSchException e) {
                e.printStackTrace();
            }
            Execute exe = new Execute(sess);
            String ret = exe.command(chmod);
            exe.disconnect();
            if (ret != null && ret.length() != 0) {
                this.logger.info((Object)"info from 'chmod' command:");
                this.logger.info((Object)("\n" + ret));
            }
            int i = 0;
            while (i < this.execScripts.size()) {
                String name = new File(((ScriptWrapper)this.execScripts.get(i)).getPath()).getName();
                new File(String.valueOf(this.projdir) + System.getProperty("file.separator") + "__" + name).delete();
                ++i;
            }
            new File(this.scriptExecScript.getPath()).delete();
            new Thread(new RemoteExecuterThread()).start();
        } else {
            boolean execDirectly;
            boolean bl = execDirectly = new Boolean(PropertiesManager.getGlobalProperties(0).getProperty("exec_bin_directly")) != false && !this.scriptType.equals("bsh") && !this.repbymail;
            if (!execDirectly) {
                try {
                    if (!System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                        try {
                            Process p = Runtime.getRuntime().exec("chmod 755 " + this.scriptExecScript.getPath());
                            p.waitFor();
                        }
                        catch (Exception exc) {
                            this.logger.error((Object)"failed to chmod");
                            exc.printStackTrace();
                        }
                    }
                    MyThread thread = new MyThread(this.scriptExecScriptExecString);
                    this.logger.info((Object)("submitted job to: " + this.hostinfo.getName()));
                }
                catch (Exception exc) {
                    this.logger.error((Object)("failed execution of script: " + this.scriptExecScript.getPath()));
                }
            } else {
                int i = 0;
                while (i < this.execScripts.size()) {
                    block26: {
                        ScriptWrapper sw = (ScriptWrapper)this.execScripts.get(i);
                        String newfile = String.valueOf(this.projectInfo.getProjectDirectory()) + "__" + new File(sw.getPath()).getName();
                        BufferedReader rd = Utils.getReader(newfile);
                        String line = "";
                        try {
                            try {
                                while ((line = rd.readLine()) != null) {
                                    new MyThread(line.trim(), "", new File(this.projectInfo.getProjectDirectory()));
                                }
                            }
                            catch (IOException iOException) {
                                try {
                                    rd.close();
                                }
                                catch (IOException iOException2) {}
                                break block26;
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                rd.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            rd.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
        }
    }

    class LocalExecuterThread
    implements Runnable {
        LocalExecuterThread() {
        }

        @Override
        public void run() {
        }
    }

    class RemoteExecuterThread
    implements Runnable {
        private Logger logger = Logger.getLogger((String)RemoteExecuterThread.class.getName());
        private Execute exe;

        RemoteExecuterThread() {
        }

        @Override
        public void run() {
            Session sess = null;
            try {
                sess = SessionCreator.getSession(JobExecuter.this.hostinfo);
            }
            catch (JSchException e) {
                e.printStackTrace();
            }
            String filename = new File(JobExecuter.this.scriptExecScript.getPath()).getName();
            Execute exe = new Execute(sess);
            exe.isVerbose(true);
            exe.command(String.valueOf(JobExecuter.this.targetdir) + "/" + filename);
            this.logger.info((Object)("submitted job to: " + JobExecuter.this.hostinfo.getName()));
            sess.disconnect();
        }
    }
}

