/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser;

import ciss.phase_viewer.file.ChaseFileManager;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.jobcontrol.DefaultScriptCreator;
import ciss.phase_viewer.outputinterface.OutputInterface;
import ciss.phase_viewer.projectbrowser.ProjectBrowser;
import ciss.phase_viewer.projectbrowser.ProjectInfoChangeEvent;
import ciss.phase_viewer.projectbrowser.ProjectInfoListener;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import java.awt.Dimension;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class ProjectInfo
implements Serializable {
    private static final long serialVersionUID = 6020378635554945716L;
    public static final int BASE = 1;
    public static final int SUB = 2;
    private static Logger logger = Logger.getLogger((String)ProjectInfo.class.getName());
    private URL projectdescriptionURL = null;
    private String projdir;
    private String projectType;
    private int infoType = 1;
    private String name;
    private String date;
    private Vector subprojects = new Vector();
    private Element element;
    private ChaseFileManager chaseFileManager;
    private ProjectBrowser parent;
    private Document doc;
    private InputInterface inputInterface;
    private OutputInterface outputInterface;
    private DataManager dm;
    private DefaultScriptCreator defaultScriptCreator;
    private String targetDir;
    private String parentDir = null;
    private String comment;
    private boolean readProjectPropertyDoc = false;
    private String rootDir = System.getProperty("user.home");
    private HostInfo hostInfo;
    private boolean editable = true;
    private Dimension initBrowserSize = new Dimension(680, 500);
    private Class[] stdoutGUIs;
    private HashMap guiComponents = new HashMap();
    private HashMap objMap = new HashMap();
    private Vector listeners;
    private boolean callingListener = false;

    public ProjectInfo(Element element) {
        this.element = element;
        this.init();
    }

    public ProjectInfo(Element element, boolean readProjectPropertyDoc) {
        this.element = element;
        this.readProjectPropertyDoc = readProjectPropertyDoc;
        this.init();
    }

    public void addSubProjectInfo(ProjectInfo info) {
        if (this.infoType == 1) {
            this.subprojects.addElement(info);
        }
    }

    public ChaseFileManager getChaseFileManager() {
        logger.debug((Object)"at getChaseFileManager:");
        if (this.chaseFileManager == null) {
            logger.debug((Object)"chasefilemanager is null...");
        }
        return this.chaseFileManager;
    }

    public String getComment() {
        if (this.comment == null || this.comment.trim().length() == 0) {
            return null;
        }
        return this.comment;
    }

    public String getDate() {
        return this.date;
    }

    public DefaultScriptCreator getDefaultScriptCreator() {
        return this.defaultScriptCreator;
    }

    public Object getGUI(Class clazz) {
        Object obj = this.guiComponents.get(clazz.getName());
        return obj;
    }

    public HostInfo getHostInfo() {
        return this.hostInfo;
    }

    public int getInfoType() {
        return this.infoType;
    }

    public Dimension getInitialBrowserSize() {
        return this.initBrowserSize;
    }

    public DataManager getInputDataManager() {
        return this.dm;
    }

    public InputInterface getInputInterface() {
        return this.inputInterface;
    }

    public OutputInterface getOutputInterface() {
        return this.outputInterface;
    }

    public ProjectBrowser getParent() {
        return this.parent;
    }

    public String getParentDir() {
        return this.parentDir;
    }

    private String getPathFromElement(String delimiter) {
        Element parent = this.element;
        String dir = "";
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.getProjectName());
        while ((parent = parent.getParentElement()) != null && !parent.getChildTextTrim("type").equals("root")) {
            vector.addElement(MyElement.decode(parent.getChildTextTrim("name")));
        }
        int i = vector.size() - 1;
        while (i >= 0) {
            dir = String.valueOf(dir) + (String)vector.get(i) + delimiter;
            --i;
        }
        return dir;
    }

    public URL getProjectDescriptionURL() {
        return this.projectdescriptionURL;
    }

    public String getProjectDirectory() {
        if (this.isRoot()) {
            return this.rootDir;
        }
        String dir = this.getPathFromElement(System.getProperty("file.separator"));
        logger.debug((Object)("ProjectDirectory: " + dir));
        return String.valueOf(this.rootDir) + System.getProperty("file.separator") + dir;
    }

    public Element getProjectElement() {
        return this.element;
    }

    public String getProjectName() {
        return this.name;
    }

    public Document getProjectPropertyDocument() {
        return this.doc;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public Class[] getStdoutGUIs() {
        return this.stdoutGUIs;
    }

    public Vector getSubProjects() {
        return this.subprojects;
    }

    public String getTargetDirectory() {
        return this.targetDir;
    }

    private void init() {
        Attribute attr;
        Element associated;
        String elemName;
        this.hostInfo = HostList.getHostList().getHostInfo("localhost");
        String bdir = this.hostInfo.getProperty("basedir");
        if (bdir != null && bdir.trim().length() != 0 && new File(bdir).exists() && new File(bdir).isDirectory()) {
            this.rootDir = bdir;
        }
        if ((elemName = this.element.getName()).equals("project")) {
            this.infoType = 1;
        } else if (elemName.equals("subproject")) {
            this.infoType = 2;
        }
        this.name = MyElement.decode(this.element.getChildTextTrim("name"));
        this.date = MyElement.decode(this.element.getChildTextTrim("date"));
        this.projectType = MyElement.decode(this.element.getChildTextTrim("type"));
        this.projdir = MyElement.decode(this.element.getChildTextTrim("directory"));
        this.comment = MyElement.decode(this.element.getChildTextTrim("comment"));
        Element edi = this.element.getChild("editable");
        if (edi != null) {
            this.editable = new Boolean(edi.getTextTrim());
        }
        if (this.isRoot()) {
            this.name = new File(this.rootDir).getName();
            Element en = this.element.getChild("name");
            if (en == null) {
                en = new Element("name");
            }
            en.setText(MyElement.encode(this.name));
            logger.debug((Object)("root name: " + this.name));
            this.projdir = this.rootDir;
            Element dir = this.element.getChild("directory");
            if (dir == null) {
                dir = new Element("directory");
                this.element.addContent((Content)dir);
            }
            dir.setText(MyElement.encode(this.projdir));
            if (this.date == null || this.date.trim().length() == 0) {
                this.date = Calendar.getInstance().getTime().toString();
                Element de = this.element.getChild("date");
                if (de == null) {
                    de = new Element("date");
                    this.element.addContent((Content)de);
                }
                de.setText(MyElement.encode(this.date));
            }
        }
        if ((associated = this.element.getChild("associated_directory")) != null && (attr = associated.getAttribute("type")) != null && attr.getValue().trim().equals("parent")) {
            this.parentDir = MyElement.decode(associated.getTextTrim());
        }
        String hasSubs = this.element.getAttributeValue("hassub");
        boolean bhasSubs = false;
        if (hasSubs != null) {
            bhasSubs = new Boolean(hasSubs);
        }
        if (bhasSubs) {
            List list;
            String subident = this.element.getAttributeValue("subident");
            if (subident == null) {
                logger.error((Object)"invalid `subident' attribute");
            }
            if ((list = this.element.getChildren(subident)) != null) {
                int i = 0;
                while (i < list.size()) {
                    this.subprojects.addElement(new ProjectInfo((Element)list.get(i), this.readProjectPropertyDoc));
                    ++i;
                }
            }
        }
        if (this.infoType == 2) {
            // empty if block
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isRoot() {
        return this.projectType.equals("root");
    }

    public void registerGUI(Object component) {
        this.guiComponents.put(component.getClass().getName(), component);
    }

    public void put(Object key, Object obj) {
        this.objMap.put(key, obj);
    }

    public Object get(Object key) {
        return this.objMap.get(key);
    }

    public void removeSubProjectInfo(ProjectInfo info) {
        if (this.infoType == 1) {
            this.subprojects.remove(info);
        }
    }

    public void saveProjectPropertyDocument() {
        String chaseXML = String.valueOf(this.getProjectDirectory()) + System.getProperty("file.separator") + "phase-viewer.xml";
        XMLUtils.saveDocumentTo(this.doc, chaseXML);
        this.setProjectPropertyDocument(this.doc);
    }

    public void setChaseFileManager(ChaseFileManager chaseFileManager) {
        this.chaseFileManager = chaseFileManager;
        if (chaseFileManager == null) {
            logger.error((Object)"ChaseFileManager for this project seems to be null...");
        } else {
            chaseFileManager.setProjectInfo(this);
        }
        this.changed();
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.changed();
    }

    public void setDefaultScriptCreator(DefaultScriptCreator defaultScriptCreator) {
        this.defaultScriptCreator = defaultScriptCreator;
        this.changed();
    }

    public void setHostInfo(HostInfo hostInfo) {
        this.hostInfo = hostInfo;
        this.setTargetDirectory(hostInfo);
        this.changed();
    }

    public void setInitialBrowserSize(Dimension dim) {
        this.initBrowserSize = dim;
        this.changed();
    }

    public void setInputDataManager(DataManager dm) {
        this.dm = dm;
        this.changed();
    }

    public void setInputInterface(InputInterface inputInterface) {
        this.inputInterface = inputInterface;
        this.changed();
    }

    public void setOutputInterface(OutputInterface outputInterface) {
        this.outputInterface = outputInterface;
        outputInterface.setProjectInfo(this);
        this.changed();
    }

    public void setParent(ProjectBrowser parent) {
        this.parent = parent;
        this.changed();
    }

    public void setParentDir(String parentDir) {
        if (this.parentDir != null) {
            return;
        }
        this.parentDir = parentDir;
        this.changed();
    }

    public void setProjectDescriptionURL(URL projectdescriptionURL) {
        this.projectdescriptionURL = projectdescriptionURL;
        this.changed();
    }

    public void setProjectDirectory(String projdir) {
        this.projdir = projdir;
        this.name = new File(projdir).getName();
        this.setTargetDirectory(this.hostInfo);
        Element nam = this.element.getChild("name");
        if (nam != null) {
            nam.setText(MyElement.encode(this.name));
        } else {
            Element ele = new Element("name").setText(MyElement.encode(this.name));
            this.element.addContent((Content)ele);
        }
        this.changed();
    }

    public void setProjectName(String name) {
        this.name = name;
        this.changed();
    }

    public void setProjectPropertyDocument(Document doc) {
        this.doc = doc;
        this.changed();
    }

    public void setStdoutGUIs(Class[] clazz) {
        this.stdoutGUIs = clazz;
        this.changed();
    }

    public void setTargetDirectory(HostInfo hostInfo) {
        this.hostInfo = hostInfo;
        String baseDir = hostInfo.getProperty("basedir");
        if (baseDir == null || baseDir.trim().length() == 0) {
            baseDir = "$HOME";
        }
        if (hostInfo.getName().equals("localhost")) {
            this.targetDir = new String(this.getProjectDirectory());
        } else {
            String dir = this.getPathFromElement("/");
            this.targetDir = String.valueOf(baseDir) + "/" + dir;
        }
        logger.debug((Object)("set targetdir: " + this.targetDir));
        this.changed();
    }

    public String toString() {
        String ls = System.getProperty("line.separator");
        String retValue = "project info: " + ls;
        if (this.infoType == 1) {
            retValue = String.valueOf(retValue) + " project info type: base" + ls;
        } else if (this.infoType == 2) {
            retValue = String.valueOf(retValue) + " project info type: sub" + ls;
        }
        retValue = String.valueOf(retValue) + "name: " + this.name + " date: " + this.date + " type: " + this.projectType + " dir: " + this.projdir;
        return retValue;
    }

    public void update() {
        this.init();
        this.changed();
    }

    public void addProjectInfoListener(ProjectInfoListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    public void removeProjectInfoListener(ProjectInfoListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    private void changed() {
        if (this.listeners == null || this.callingListener) {
            return;
        }
        this.callingListener = true;
        ProjectInfoChangeEvent ev = new ProjectInfoChangeEvent(this);
        int i = 0;
        while (i < this.listeners.size()) {
            ((ProjectInfoListener)this.listeners.get(i)).projectInfoChanged(ev);
            ++i;
        }
        this.callingListener = false;
    }
}

