/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis.tableforinputinterface;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableModelForInputInterface;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;

public class TableModelForNonTabularData
extends TableModelForInputInterface {
    private static Logger logger = Logger.getLogger((String)TableModelForNonTabularData.class.getName());
    private Vector entryVector = new Vector();
    private int rowStart = 1;
    private boolean rowOriented = false;
    private int[] map;

    public TableModelForNonTabularData(String[] inputSpecifications, InputInterface inputInterface, int[] mapSpecCol, EventListener el) {
        super(inputSpecifications, inputInterface, mapSpecCol, el);
        super.init();
    }

    public TableModelForNonTabularData(String[] inputSpecifications, InputInterface inputInterface, int[] mapSpecCol, EventListener el, int columnIndex) {
        super(inputSpecifications, inputInterface, mapSpecCol, el, columnIndex);
        super.init();
    }

    public boolean isRowOriented() {
        return this.rowOriented;
    }

    @Override
    public void inputInterfaceInitializing() {
        TableModelListener[] listeners = this.getTableModelListeners();
        int i = 0;
        while (i < listeners.length) {
            this.removeTableModelListener(listeners[i]);
            ++i;
        }
        int row = this.getRowCount();
        int col = this.getColumnCount();
        int colStart = 1;
        int i2 = 0;
        while (i2 < row) {
            int j = colStart;
            while (j < col) {
                this.setValueAt("", i2, j);
                ++j;
            }
            ++i2;
        }
        this.restoreListeners(listeners);
    }

    @Override
    protected void createTableColumns() {
        if (this.columns == null) {
            return;
        }
        logger.debug((Object)"creating table columns...");
        Object[] colNames = null;
        if (this.spec.isRowOriented()) {
            this.rowOriented = true;
            colNames = this.spec.getColumnNamesForNonTabularData();
            this.setColumnIdentifiers(colNames);
            this.setRowCount(this.columns.length);
            int i = 0;
            while (i < this.columns.length) {
                logger.debug((Object)("set name : " + this.columns[i].getName()));
                this.setValueAt(this.columns[i].getName(), i, 0);
                ++i;
            }
        } else {
            this.rowOriented = false;
            int i = 0;
            while (i < this.columns.length) {
                this.addColumn(this.columns[i].getName());
                ++i;
            }
            int nrw = this.spec.getNumRows();
            if (nrw > 0) {
                this.setRowCount(nrw);
            }
            String[] foo = this.inputSpecifications[0].split("\\.");
            String tag = foo[foo.length - 1];
            int i2 = 0;
            while (i2 < this.getRowCount()) {
                this.setValueAt(tag, i2, 0);
                ++i2;
            }
        }
    }

    @Override
    protected void extractInputFile() {
        this.entryVector = new Vector();
        this.map = new int[this.columns.length];
        int count = 0;
        logger.debug((Object)("extraction input. " + this.inputSpecifications[0]));
        int i = 0;
        while (i < this.columns.length) {
            String fullName = String.valueOf(this.inputSpecifications[0]) + "." + this.columns[i].getName().trim();
            logger.debug((Object)("fullname: " + fullName));
            if (!this.columns[i].ignoreOnSave()) {
                InputInterfacePrimitiveEntry entry = this.input.getInputInterfacePrimitiveEntry(fullName);
                this.map[i] = count++;
                this.entryVector.addElement(entry);
            }
            ++i;
        }
        this.setInputToModel();
    }

    @Override
    protected void setInputToModel() {
        this.input.setUpdateUndoStack(false);
        this.updateInputInterface = false;
        int icol = this.getColumnCount();
        int irow = this.getRowCount();
        int idata = icol + this.rowStart;
        int idata2 = irow;
        if (this.rowOriented) {
            idata = irow;
            idata2 = icol + this.rowStart;
        }
        int i = 0;
        while (i < this.entryVector.size()) {
            if (i < idata) {
                InputInterfacePrimitiveEntry entry = (InputInterfacePrimitiveEntry)this.entryVector.get(i);
                String value = entry.getValue();
                String[] values = value.trim().split("\\s+");
                int j = 0;
                while (j < values.length) {
                    if (j < idata2) {
                        if (this.rowOriented) {
                            int tmp = j + this.rowStart;
                            logger.debug((Object)("rowOriented; set value " + values[j] + " at: " + i + " " + tmp));
                            this.setValueAt(values[j], i, tmp);
                        } else {
                            logger.debug((Object)("set value " + values[j] + " at: " + j + " " + i));
                            this.setValueAt(values[j], j, i + this.rowStart);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.input.setUpdateUndoStack(true);
        this.updateInputInterface = true;
    }

    @Override
    public void execute(EventObject e) {
        if (!this.updateInputInterface) {
            return;
        }
        TableModelListener[] listeners = this.getTableModelListeners();
        int i = 0;
        while (i < listeners.length) {
            this.removeTableModelListener(listeners[i]);
            ++i;
        }
        TableModelEvent tmde = (TableModelEvent)e;
        int first = 0;
        int last = 0;
        int chcol = 0;
        if (tmde == null) {
            this.restoreListeners(listeners);
            return;
        }
        first = tmde.getFirstRow();
        last = tmde.getLastRow();
        chcol = tmde.getColumn();
        logger.debug((Object)("first row that changed: " + tmde.getFirstRow()));
        logger.debug((Object)("last row that changed: " + tmde.getLastRow()));
        logger.debug((Object)("type: " + tmde.getType()));
        if (first < 0 || last < 0 || first >= this.getRowCount() || last >= this.getRowCount()) {
            this.restoreListeners(listeners);
            return;
        }
        logger.debug((Object)"updating table data ...");
        int icol = this.getColumnCount();
        int irow = this.getRowCount();
        int rowStart = 1;
        String[] columnName = new String[icol];
        int i2 = 0;
        while (i2 < icol) {
            columnName[i2] = this.getColumnName(i2);
            ++i2;
        }
        int change = -1;
        int targ = -1;
        if (this.rowOriented) {
            change = first;
            targ = first;
        } else {
            change = chcol;
            targ = chcol;
        }
        if (change < 0 || targ < 0) {
            this.restoreListeners(listeners);
            return;
        }
        Vector<InputInterfacePrimitiveEntry> entries = new Vector<InputInterfacePrimitiveEntry>();
        InputInterfacePrimitiveEntry pentry = this.input.getInputInterfacePrimitiveEntry(String.valueOf(this.inputSpecifications[0]) + "." + this.columns[targ].getName());
        logger.debug((Object)("targ: " + targ + "changing entry: " + this.inputSpecifications[0] + "." + this.columns[targ].getName()));
        pentry.saveState();
        String accumData = "";
        String name = "";
        if (this.rowOriented) {
            int j = rowStart;
            while (j < icol) {
                accumData = String.valueOf(accumData) + (String)this.getValueAt(change, j) + " ";
                ++j;
            }
            name = ((String)this.getValueAt(change, 0)).trim();
        } else {
            int j = 0;
            while (j < irow) {
                accumData = String.valueOf(accumData) + (String)this.getValueAt(j, change);
                ++j;
            }
            name = columnName[change].trim();
        }
        pentry.setName(name);
        pentry.setValue(accumData);
        pentry.setUnit("");
        this.input.replaceEntry(pentry, this, this.callListener);
        entries.addElement(pentry);
        this.restoreListeners(listeners);
    }

    @Override
    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
        logger.debug((Object)("at inputInterfaceEntryChaged: tag: " + e.getTag()));
        if (e == null || e.getTag() == null) {
            logger.debug((Object)"something is wrong... InputInterfaceEntryChangeEvent not properly initialized.");
            return;
        }
        if (e.getSource() == this) {
            logger.debug((Object)"source == this");
            return;
        }
        InputInterfaceEntry entry = e.getEntry();
        if (entry.getEntryType() != 0) {
            logger.debug((Object)"not primitive entry");
            return;
        }
        int target = -1;
        String tag = String.valueOf(e.getTag().trim()) + "." + e.getEntry().getName();
        String targetTag = "";
        int i = 0;
        while (i < this.columns.length) {
            if (tag.equalsIgnoreCase(String.valueOf(this.inputSpecifications[0]) + "." + this.columns[i].getName())) {
                target = i;
            }
            ++i;
        }
        if (target < 0) {
            logger.debug((Object)"not target");
            return;
        }
        logger.debug((Object)("tag: " + tag));
        logger.debug((Object)("e.getSource(): " + e.getSource()));
        logger.debug((Object)("this: " + this));
        InputInterfacePrimitiveEntry pentry = this.input.getInputInterfacePrimitiveEntry(tag);
        this.entryVector.set(this.map[target], pentry);
        this.setInputToModel();
    }
}

