/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis.tableforinputinterface;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpec;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpecManager;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableModelForAtomCoords;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableModelForNonTabularData;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableModelForTabularData;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public abstract class TableModelForInputInterface
extends DefaultTableModel
implements Command,
InputInterfaceEntryChangeListener {
    private Logger logger = Logger.getLogger((String)TableModelForInputInterface.class.getName());
    protected String[] inputSpecifications;
    protected InputInterface input;
    protected Vector tableData = new Vector();
    protected String[] idents;
    protected InputInterfaceTableSpecManager manager;
    protected InputInterfaceTableColumns[] columns;
    protected InputInterfaceTableSpec spec;
    protected int[] mapSpecCol;
    protected EventListener el;
    protected boolean updateInputInterface = true;
    private JTable parentTable;
    private int columnIndex;
    private boolean batchUpdate = false;
    protected boolean callListener = true;

    public TableModelForInputInterface(String[] inputSpecifications, InputInterface input, int[] mapSpecCol, EventListener el) {
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.input.addInputInterfaceEntryChangeListener(this);
        this.el = el;
        this.mapSpecCol = mapSpecCol;
        this.manager = input.getInputInterfaceTableSpecManager();
        this.columnIndex = 0;
    }

    public TableModelForInputInterface(String[] inputSpecifications, InputInterface input, int[] mapSpecCol, EventListener el, int columnIndex) {
        this.inputSpecifications = inputSpecifications;
        this.input = input;
        this.input.addInputInterfaceEntryChangeListener(this);
        this.el = el;
        this.mapSpecCol = mapSpecCol;
        this.manager = input.getInputInterfaceTableSpecManager();
        this.columnIndex = columnIndex;
    }

    public TableModelForInputInterface(String[] inputSpecifications, InputInterfaceTableSpecManager manager, int[] mapSpecCol, EventListener el) {
        this.inputSpecifications = inputSpecifications;
        this.el = el;
        this.mapSpecCol = mapSpecCol;
        this.manager = manager;
        this.spec = manager.getTableSpec(inputSpecifications[0]);
        this.columns = this.spec.getTableColumns();
    }

    protected void init() {
        if (this.manager != null && this.inputSpecifications != null) {
            this.spec = this.manager.getTableSpec(this.inputSpecifications[0], this.columnIndex);
            this.columns = this.spec.getTableColumns();
            this.createTableColumns();
        }
        super.addTableModelListener((TableModelListener)this.el);
        if (this.input != null && this.inputSpecifications != null) {
            this.extractInputFile();
        }
    }

    public TableModelForInputInterface(int rowCount, int columnCount) {
        super(rowCount, columnCount);
    }

    public TableModelForInputInterface(Object[][] data, Object[] columnNames) {
        super(data, columnNames);
    }

    public TableModelForInputInterface(Object[] columnNames, int rowCount) {
        super(columnNames, rowCount);
    }

    public TableModelForInputInterface(Vector columnNames, int rowCount) {
        super(columnNames, rowCount);
    }

    public TableModelForInputInterface(Vector data, Vector columnNames) {
        super(data, columnNames);
    }

    public static TableModelForInputInterface getInstance(String[] inputSpecifications, InputInterface input, int[] mapSpecCol, EventListener el, boolean non_tabular) {
        if (!non_tabular) {
            return new TableModelForTabularData(inputSpecifications, input, mapSpecCol, el);
        }
        return new TableModelForNonTabularData(inputSpecifications, input, mapSpecCol, el);
    }

    public static TableModelForInputInterface getInstance(String[] inputSpecifications, InputInterface input, int[] mapSpecCol, EventListener el, boolean non_tabular, int columnIndex) {
        if (!non_tabular) {
            return new TableModelForTabularData(inputSpecifications, input, mapSpecCol, el, columnIndex);
        }
        return new TableModelForNonTabularData(inputSpecifications, input, mapSpecCol, el, columnIndex);
    }

    public static TableModelForInputInterface getInstance(AtomCoords coords, String[] inputSpecifications, InputInterfaceTableSpecManager manager, int[] mapSpecCol, EventListener el, JTable table) {
        return new TableModelForAtomCoords(coords, inputSpecifications, manager, mapSpecCol, el, table);
    }

    protected void restoreListeners(TableModelListener[] listeners) {
        int i = 0;
        while (i < listeners.length) {
            this.addTableModelListener(listeners[i]);
            ++i;
        }
    }

    protected void setParentTable(JTable table) {
        this.parentTable = table;
    }

    protected JTable getParentTable() {
        return this.parentTable;
    }

    protected void batchUpdate(boolean batchUpdate) {
        this.batchUpdate = batchUpdate;
        this.fireTableDataChanged();
    }

    public boolean batchUpdate() {
        return this.batchUpdate;
    }

    protected abstract void createTableColumns();

    protected abstract void extractInputFile();

    protected abstract void setInputToModel();

    @Override
    public void inputInterfaceInitialized() {
    }

    public void notifyInputInterfaceChangeListeners(boolean callListener) {
        this.callListener = callListener;
    }
}

