/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis.tableforinputinterface;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableSpecManager;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableModelForInputInterface;
import java.text.DecimalFormat;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;

public class TableModelForAtomCoords
extends TableModelForInputInterface {
    private Logger logger = Logger.getLogger((String)TableModelForAtomCoords.class.getName());
    private InputInterfaceTableSpecManager manager;
    private AtomCoords coords;
    private AtomList list;
    private String[] identifiers;
    private boolean updateAtomCoords = true;
    private JTable parentTable;
    TableModelListener[] tlisteners;

    public TableModelForAtomCoords(AtomCoords coords, String[] inputSpecifications, InputInterfaceTableSpecManager manager, int[] mapSpecCol, EventListener el, JTable parentTable) {
        super(inputSpecifications, manager, mapSpecCol, el);
        this.coords = coords;
        this.manager = manager;
        this.list = coords.getAtomList();
        this.parentTable = parentTable;
        this.initThis();
    }

    private void initThis() {
        this.createTableColumns();
        this.extractInputFile();
        this.setInputToModel();
    }

    @Override
    protected void createTableColumns() {
        if (this.columns == null) {
            return;
        }
        int i = 0;
        while (i < this.mapSpecCol.length) {
            this.addColumn(this.columns[this.mapSpecCol[i]].getName());
            ++i;
        }
        this.identifiers = new String[this.getColumnCount()];
        i = 0;
        while (i < this.identifiers.length) {
            this.identifiers[i] = this.getColumnName(i);
            ++i;
        }
        int nrw = this.manager.getTableSpec(this.inputSpecifications[0]).getNumRows();
        if (nrw > 0) {
            this.setRowCount(nrw);
        }
    }

    @Override
    protected void extractInputFile() {
    }

    @Override
    protected void setInputToModel() {
        if (this.list == null) {
            return;
        }
        this.removeListeners();
        this.updateAtomCoords = false;
        int i = 0;
        while (i < this.list.size()) {
            Atom atom = this.list.getAtomAt(i);
            int j = 0;
            while (j < this.getColumnCount()) {
                String val = AtomCoords.getValueFrom(atom, this.identifiers[j]);
                this.setValueAt(val, i, j);
                ++j;
            }
            j = 0;
            while (j < this.mapSpecCol.length) {
                if (this.columns[this.mapSpecCol[j]].getDefaultValue().trim().equals("INCRE") && this.columns[this.mapSpecCol[j]].ignoreOnSave()) {
                    this.setValueAt(new Integer(i + 1), i, j);
                }
                ++j;
            }
            ++i;
        }
        this.restoreListeners();
        this.setValueAt(this.getValueAt(0, 0), 0, 0);
        this.updateAtomCoords = true;
    }

    private void removeListeners() {
        this.tlisteners = this.getTableModelListeners();
        if (this.tlisteners != null) {
            int i = 0;
            while (i < this.tlisteners.length) {
                this.removeTableModelListener(this.tlisteners[i]);
                ++i;
            }
        }
    }

    private void restoreListeners() {
        if (this.tlisteners != null) {
            int i = 0;
            while (i < this.tlisteners.length) {
                this.addTableModelListener(this.tlisteners[i]);
                ++i;
            }
        }
    }

    public void setUpdateAtomCoords(boolean updateAtomCoords) {
        this.updateAtomCoords = updateAtomCoords;
    }

    @Override
    public void execute(EventObject e) {
        TableModelListener[] listeners = this.getTableModelListeners();
        int i = 0;
        while (i < listeners.length) {
            this.removeTableModelListener(listeners[i]);
            ++i;
        }
        TableModelEvent tmde = (TableModelEvent)e;
        int first = 0;
        int last = 0;
        if (tmde == null) {
            this.restoreListeners(listeners);
            return;
        }
        first = tmde.getFirstRow();
        last = tmde.getLastRow();
        if (first < 0 || last < 0) {
            this.restoreListeners(listeners);
            return;
        }
        if (last >= this.getRowCount()) {
            this.restoreListeners(listeners);
            return;
        }
        int i2 = 0;
        while (i2 < this.mapSpecCol.length) {
            if (this.columns[this.mapSpecCol[i2]].getDefaultValue().trim().equals("INCRE") && this.columns[this.mapSpecCol[i2]].ignoreOnSave()) {
                this.setValueAt(new Integer(last + 1), last, i2);
            }
            ++i2;
        }
        if (this.updateAtomCoords) {
            this.updateAtomCoords(first, last);
        }
        this.restoreListeners(listeners);
    }

    private void updateAtomCoords(int first, int last) {
        boolean nullCount = false;
        Vector<String> id = new Vector<String>();
        int i = 0;
        while (i < this.mapSpecCol.length) {
            if (!this.columns[this.mapSpecCol[i]].ignoreOnSave()) {
                id.addElement(this.columns[this.mapSpecCol[i]].getName());
            }
            ++i;
        }
        if (id == null) {
            return;
        }
        Object[] sid = new String[id.size()];
        id.copyInto(sid);
        int i2 = first;
        while (i2 < last + 1) {
            Vector<String> data = new Vector<String>();
            int j = 0;
            while (j < this.mapSpecCol.length) {
                InputInterfaceTableColumns col = this.columns[this.mapSpecCol[j]];
                if (!col.ignoreOnSave()) {
                    Object obj = this.getValueAt(i2, j);
                    String string = "";
                    if (obj instanceof String) {
                        string = (String)obj;
                        if (string == null) {
                            string = "";
                        }
                    } else if (obj instanceof Boolean) {
                        boolean bool = (Boolean)obj;
                        string = bool ? "1" : "0";
                    }
                    data.addElement(string);
                }
                ++j;
            }
            if (data != null) {
                Object[] sdata = new String[data.size()];
                data.copyInto(sdata);
                Atom atom = AtomCoords.createAtomFrom((String[])sid, (String[])sdata);
                if (i2 >= this.list.size()) {
                    this.list.addAtom(atom);
                } else if (i2 >= 0 && i2 < this.list.size()) {
                    this.list.replaceAtomAt(i2, atom);
                }
                this.logger.debug((Object)this.list);
            }
            ++i2;
        }
    }

    @Override
    public void removeRow(int row) {
        this.logger.debug((Object)"removing row.");
        if (row < this.list.size() && row >= 0) {
            this.list.removeAtomAt(row);
        }
        super.removeRow(row);
    }

    @Override
    public void setValueAt(Object data, int row, int col) {
        if (col >= this.mapSpecCol.length) {
            super.setValueAt(data, row, col);
            return;
        }
        if (!this.columns[this.mapSpecCol[col]].format()) {
            super.setValueAt(data, row, col);
        } else {
            Object formatedData;
            DecimalFormat formatter = this.columns[this.mapSpecCol[col]].getFormatter();
            if (data instanceof Double) {
                formatedData = formatter.format((Double)data);
            } else if (data instanceof String) {
                try {
                    Double d = Double.valueOf((String)data);
                    formatedData = formatter.format(d);
                }
                catch (NumberFormatException ne) {
                    formatedData = data;
                }
            } else {
                formatedData = data;
            }
            super.setValueAt(formatedData, row, col);
        }
    }

    @Override
    public void inputInterfaceInitializing() {
    }

    @Override
    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
    }
}

