/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis.perlscriptexecuters;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlScript;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlScriptExecListener;
import ciss.phase_viewer.primitiveguis.perlscriptexecuters.PerlScriptOption;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class PerlExecPanel
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)PerlExecPanel.class.getName());
    private PerlScript perlScript;
    private PerlScriptOption[] options;
    private int numCols = 4;
    private int numRows;
    private File stdoutFile;
    private File erroutFile;
    private Vector listeners;
    private boolean closeAfterOK = true;

    public PerlExecPanel(String title, Dimension dim, PerlScript perlScript) {
        super(title, true, true, true, true, dim);
        this.perlScript = perlScript;
        this.options = perlScript.getOptions();
        this.init();
    }

    public void addListener(PerlScriptExecListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    public void removeListener(PerlScriptExecListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public PerlExecPanel(String title, Dimension dim, PerlScriptOption[] options, int numCols) {
        super(title, true, true, true, true, dim);
        this.options = options;
        this.numCols = numCols;
        this.init();
    }

    public void closeAfterOK(boolean closeAfterOK) {
        this.closeAfterOK = closeAfterOK;
    }

    public void setStdoutFile(File stdoutFile) {
        this.stdoutFile = stdoutFile;
    }

    public void setErroutFile(File erroutFile) {
        this.erroutFile = erroutFile;
    }

    private void init() {
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JPanel popts = new JPanel();
        if (this.options != null) {
            this.numRows = (int)Math.ceil((double)this.options.length / (double)this.numCols);
            popts.setLayout(new GridLayout(this.numRows, this.numCols));
            int i = 0;
            while (i < this.options.length) {
                JComponent[] component = this.options[i].getAssociatedGUI();
                int j = 0;
                while (j < component.length) {
                    popts.add(component[j]);
                    ++j;
                }
                ++i;
            }
        }
        JPanel btnpanel = new JPanel();
        btnpanel.setLayout(new BoxLayout(btnpanel, 0));
        JButton okbutton = new JButton("OK");
        JButton cancelbutton = new JButton("cancel");
        btnpanel.add(okbutton);
        btnpanel.add(cancelbutton);
        container.add(popts);
        container.add(btnpanel);
        cancelbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PerlExecPanel.this.dispose();
            }
        });
        okbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PerlExecPanel.this.doOKAction();
                if (PerlExecPanel.this.closeAfterOK) {
                    PerlExecPanel.this.dispose();
                }
            }
        });
    }

    public void disose() {
        this.listeners = null;
        super.dispose();
    }

    private void doOKAction() {
        if (this.listeners != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                ((PerlScriptExecListener)this.listeners.get(i)).perlScriptStarted();
                ++i;
            }
        }
        BufferedReader[] reader = this.perlScript.exec();
        new Thread(new Stdout(reader[0])).start();
        new Thread(new Stderrout(reader[1])).start();
    }

    class Stderrout
    implements Runnable {
        private BufferedReader reader;

        Stderrout(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public void run() {
            String line = "";
            PrintWriter writer = null;
            if (PerlExecPanel.this.erroutFile != null) {
                writer = Utils.getPrintWriter(PerlExecPanel.this.erroutFile.getAbsolutePath());
            }
            try {
                try {
                    while ((line = this.reader.readLine()) != null) {
                        if (writer == null) {
                            PerlExecPanel.this.logger.error((Object)line);
                            continue;
                        }
                        writer.println(line);
                    }
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        writer.flush();
                        writer.close();
                    }
                    try {
                        this.reader.close();
                    }
                    catch (IOException iOException2) {}
                }
            }
            finally {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    class Stdout
    implements Runnable {
        private BufferedReader reader;

        Stdout(BufferedReader reader) {
            this.reader = reader;
        }

        @Override
        public void run() {
            block19: {
                String line = "";
                PrintWriter writer = null;
                if (PerlExecPanel.this.stdoutFile != null) {
                    writer = Utils.getPrintWriter(PerlExecPanel.this.stdoutFile.getAbsolutePath());
                }
                try {
                    try {
                        while ((line = this.reader.readLine()) != null) {
                            if (writer == null) {
                                PerlExecPanel.this.logger.info((Object)line);
                                continue;
                            }
                            writer.println(line);
                        }
                    }
                    catch (IOException iOException) {
                        if (writer != null) {
                            writer.flush();
                            writer.close();
                        }
                        try {
                            this.reader.close();
                        }
                        catch (IOException iOException2) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        writer.flush();
                        writer.close();
                    }
                    try {
                        this.reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (PerlExecPanel.this.listeners != null) {
                int i = 0;
                while (i < PerlExecPanel.this.listeners.size()) {
                    ((PerlScriptExecListener)PerlExecPanel.this.listeners.get(i)).perlScriptFinished();
                    ++i;
                }
            }
        }
    }
}

